/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.service;

import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.core.catalog.domain.ProductOption;
import org.broadleafcommerce.core.catalog.service.type.ProductOptionValidationType;
import org.broadleafcommerce.core.order.service.ProductOptionValidationService;
import org.broadleafcommerce.core.order.service.exception.ProductOptionValidationException;
import org.springframework.stereotype.Service;

@Service(value="blProductOptionValidationService")
public class ProductOptionValidationServiceImpl
implements ProductOptionValidationService {
    private static final Log LOG = LogFactory.getLog(ProductOptionValidationServiceImpl.class);

    @Override
    public Boolean validate(ProductOption productOption, String value) {
        if (productOption.getProductOptionValidationType() == ProductOptionValidationType.REGEX && !this.validateRegex(productOption.getValidationString(), value).booleanValue()) {
            LOG.error((Object)(productOption.getErrorMessage() + ". Value [" + value + "] does not match regex string [" + productOption.getValidationString() + "]"));
            String exceptionMessage = productOption.getAttributeName() + " " + productOption.getErrorMessage() + ". Value [" + value + "] does not match regex string [" + productOption.getValidationString() + "]";
            throw new ProductOptionValidationException(exceptionMessage, productOption.getErrorCode(), productOption.getAttributeName(), value, productOption.getValidationString(), productOption.getErrorMessage());
        }
        return true;
    }

    protected Boolean validateRegex(String regex, String value) {
        if (value == null) {
            return false;
        }
        return Pattern.matches(regex, value);
    }
}

