/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.domain;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrency;
import org.broadleafcommerce.common.currency.util.BroadleafCurrencyUtils;
import org.broadleafcommerce.common.currency.util.CurrencyCodeIdentifiable;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationToOneLookup;
import org.broadleafcommerce.common.presentation.client.SupportedFieldType;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeEntry;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeOverride;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeOverrides;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupImpl;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.OrderItemImpl;
import org.broadleafcommerce.core.order.domain.TaxDetail;
import org.broadleafcommerce.core.order.domain.TaxDetailImpl;
import org.broadleafcommerce.core.order.service.type.FulfillmentGroupStatusType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;

@Entity
@DiscriminatorColumn(name="TYPE")
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_FULFILLMENT_GROUP_ITEM")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
@AdminPresentationMergeOverrides(value={@AdminPresentationMergeOverride(name="", mergeEntries={@AdminPresentationMergeEntry(propertyType="readOnly", booleanOverrideValue=true)})})
public class FulfillmentGroupItemImpl
implements FulfillmentGroupItem,
Cloneable,
CurrencyCodeIdentifiable {
    private static final Log LOG = LogFactory.getLog(FulfillmentGroupItemImpl.class);
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="FulfillmentGroupItemId")
    @GenericGenerator(name="FulfillmentGroupItemId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="FulfillmentGroupItemImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.order.domain.FulfillmentGroupItemImpl")})
    @Column(name="FULFILLMENT_GROUP_ITEM_ID")
    protected Long id;
    @ManyToOne(targetEntity=FulfillmentGroupImpl.class, optional=false)
    @JoinColumn(name="FULFILLMENT_GROUP_ID")
    @Index(name="FGITEM_FG_INDEX", columnNames={"FULFILLMENT_GROUP_ID"})
    protected FulfillmentGroup fulfillmentGroup;
    @ManyToOne(targetEntity=OrderItemImpl.class, optional=false)
    @JoinColumn(name="ORDER_ITEM_ID")
    @AdminPresentation(friendlyName="FulfillmentGroupItemImpl_Order_Item", prominent=true, order=1000, gridOrder=1000)
    @AdminPresentationToOneLookup
    protected OrderItem orderItem;
    @Column(name="QUANTITY", nullable=false)
    @AdminPresentation(friendlyName="FulfillmentGroupItemImpl_Quantity", prominent=true, order=2000, gridOrder=2000)
    protected int quantity;
    @Column(name="STATUS")
    @Index(name="FGITEM_STATUS_INDEX", columnNames={"STATUS"})
    @AdminPresentation(friendlyName="FulfillmentGroupItemImpl_Status", prominent=true, order=3000, gridOrder=3000)
    private String status;
    @OneToMany(fetch=FetchType.LAZY, targetEntity=TaxDetailImpl.class, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinTable(name="BLC_FG_ITEM_TAX_XREF", joinColumns={@JoinColumn(name="FULFILLMENT_GROUP_ITEM_ID")}, inverseJoinColumns={@JoinColumn(name="TAX_DETAIL_ID")})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected List<TaxDetail> taxes = new ArrayList<TaxDetail>();
    @Column(name="TOTAL_ITEM_TAX", precision=19, scale=5)
    @AdminPresentation(friendlyName="FulfillmentGroupItemImpl_Total_Item_Tax", order=4000, fieldType=SupportedFieldType.MONEY)
    protected BigDecimal totalTax;
    @Column(name="TOTAL_ITEM_AMOUNT", precision=19, scale=5)
    @AdminPresentation(friendlyName="FulfillmentGroupItemImpl_Total_Item_Amount", order=5000, fieldType=SupportedFieldType.MONEY)
    protected BigDecimal totalItemAmount;
    @Column(name="TOTAL_ITEM_TAXABLE_AMOUNT", precision=19, scale=5)
    @AdminPresentation(friendlyName="FulfillmentGroupItemImpl_Total_Item_Taxable_Amount", order=6000, fieldType=SupportedFieldType.MONEY)
    protected BigDecimal totalItemTaxableAmount;
    @Column(name="PRORATED_ORDER_ADJ")
    @AdminPresentation(friendlyName="FulfillmentGroupItemImpl_Prorated_Adjustment", order=7000, fieldType=SupportedFieldType.MONEY)
    protected BigDecimal proratedOrderAdjustment;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public FulfillmentGroup getFulfillmentGroup() {
        return this.fulfillmentGroup;
    }

    @Override
    public void setFulfillmentGroup(FulfillmentGroup fulfillmentGroup) {
        this.fulfillmentGroup = fulfillmentGroup;
    }

    @Override
    public OrderItem getOrderItem() {
        return this.orderItem;
    }

    @Override
    public void setOrderItem(OrderItem orderItem) {
        this.orderItem = orderItem;
    }

    @Override
    public int getQuantity() {
        return this.quantity;
    }

    @Override
    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    @Override
    public Money getRetailPrice() {
        return this.orderItem.getRetailPrice();
    }

    @Override
    public Money getSalePrice() {
        return this.orderItem.getSalePrice();
    }

    @Override
    public Money getPrice() {
        return this.orderItem.getAveragePrice();
    }

    protected Money convertToMoney(BigDecimal amount) {
        return amount == null ? null : BroadleafCurrencyUtils.getMoney((BigDecimal)amount, (BroadleafCurrency)this.orderItem.getOrder().getCurrency());
    }

    @Override
    public Money getTotalItemAmount() {
        return this.convertToMoney(this.totalItemAmount);
    }

    @Override
    public void setTotalItemAmount(Money amount) {
        this.totalItemAmount = amount.getAmount();
    }

    @Override
    public Money getProratedOrderAdjustmentAmount() {
        return this.convertToMoney(this.proratedOrderAdjustment);
    }

    @Override
    public void setProratedOrderAdjustmentAmount(Money proratedOrderAdjustment) {
        this.proratedOrderAdjustment = proratedOrderAdjustment.getAmount();
    }

    @Override
    public Money getTotalItemTaxableAmount() {
        return this.convertToMoney(this.totalItemTaxableAmount);
    }

    @Override
    public void setTotalItemTaxableAmount(Money taxableAmount) {
        this.totalItemTaxableAmount = taxableAmount.getAmount();
    }

    @Override
    public FulfillmentGroupStatusType getStatus() {
        return FulfillmentGroupStatusType.getInstance(this.status);
    }

    @Override
    public void setStatus(FulfillmentGroupStatusType status) {
        this.status = status.getType();
    }

    @Override
    public void removeAssociations() {
        if (this.getFulfillmentGroup() != null) {
            this.getFulfillmentGroup().getFulfillmentGroupItems().remove(this);
        }
        this.setFulfillmentGroup(null);
        this.setOrderItem(null);
    }

    @Override
    public List<TaxDetail> getTaxes() {
        return this.taxes;
    }

    @Override
    public void setTaxes(List<TaxDetail> taxes) {
        this.taxes = taxes;
    }

    @Override
    public Money getTotalTax() {
        return this.totalTax == null ? null : BroadleafCurrencyUtils.getMoney((BigDecimal)this.totalTax, (BroadleafCurrency)this.getFulfillmentGroup().getOrder().getCurrency());
    }

    @Override
    public void setTotalTax(Money totalTax) {
        this.totalTax = Money.toAmount((Money)totalTax);
    }

    public String getCurrencyCode() {
        return ((CurrencyCodeIdentifiable)this.fulfillmentGroup).getCurrencyCode();
    }

    public void checkCloneable(FulfillmentGroupItem fulfillmentGroupItem) throws CloneNotSupportedException, SecurityException, NoSuchMethodException {
        Method cloneMethod = fulfillmentGroupItem.getClass().getMethod("clone", new Class[0]);
        if (cloneMethod.getDeclaringClass().getName().startsWith("org.broadleafcommerce") && !this.orderItem.getClass().getName().startsWith("org.broadleafcommerce")) {
            throw new CloneNotSupportedException("Custom extensions and implementations should implement clone in order to guarantee split and merge operations are performed accurately");
        }
    }

    @Override
    public FulfillmentGroupItem clone() {
        FulfillmentGroupItem clonedFulfillmentGroupItem;
        try {
            clonedFulfillmentGroupItem = (FulfillmentGroupItem)Class.forName(this.getClass().getName()).newInstance();
            try {
                this.checkCloneable(clonedFulfillmentGroupItem);
            }
            catch (CloneNotSupportedException e) {
                LOG.warn((Object)("Clone implementation missing in inheritance hierarchy outside of Broadleaf: " + clonedFulfillmentGroupItem.getClass().getName()), (Throwable)e);
            }
            clonedFulfillmentGroupItem.setFulfillmentGroup(this.getFulfillmentGroup());
            clonedFulfillmentGroupItem.setOrderItem(this.getOrderItem());
            clonedFulfillmentGroupItem.setQuantity(this.getQuantity());
            clonedFulfillmentGroupItem.setTotalItemAmount(this.getTotalItemAmount());
            clonedFulfillmentGroupItem.setTotalItemTaxableAmount(this.getTotalItemTaxableAmount());
            if (this.getStatus() != null) {
                clonedFulfillmentGroupItem.setStatus(this.getStatus());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return clonedFulfillmentGroupItem;
    }

    @Override
    public boolean getHasProratedOrderAdjustments() {
        if (this.proratedOrderAdjustment != null) {
            return this.proratedOrderAdjustment.compareTo(BigDecimal.ZERO) == 0;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FulfillmentGroupItemImpl other = (FulfillmentGroupItemImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        return !(this.orderItem == null ? other.orderItem != null : !this.orderItem.equals(other.orderItem));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.orderItem == null ? 0 : this.orderItem.hashCode());
        return result;
    }
}

