/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.domain;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrency;
import org.broadleafcommerce.common.currency.util.BroadleafCurrencyUtils;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.AdminPresentationCollection;
import org.broadleafcommerce.common.presentation.AdminPresentationToOneLookup;
import org.broadleafcommerce.common.presentation.client.SupportedFieldType;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductBundle;
import org.broadleafcommerce.core.catalog.domain.ProductBundleImpl;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.domain.SkuImpl;
import org.broadleafcommerce.core.catalog.service.type.ProductBundlePricingModelType;
import org.broadleafcommerce.core.order.domain.BundleOrderItem;
import org.broadleafcommerce.core.order.domain.BundleOrderItemFeePrice;
import org.broadleafcommerce.core.order.domain.BundleOrderItemFeePriceImpl;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItemImpl;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.OrderItemImpl;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_BUNDLE_ORDER_ITEM")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
@AdminPresentationClass(friendlyName="BundleOrderItemImpl_bundleOrderItem")
public class BundleOrderItemImpl
extends OrderItemImpl
implements BundleOrderItem {
    private static final long serialVersionUID = 1L;
    @OneToMany(mappedBy="bundleOrderItem", targetEntity=DiscreteOrderItemImpl.class, cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    @AdminPresentationCollection(friendlyName="BundleOrderItemImpl_Discrete_Order_Items", tab="OrderImpl_Advanced", tabOrder=2000)
    protected List<DiscreteOrderItem> discreteOrderItems = new ArrayList<DiscreteOrderItem>();
    @OneToMany(mappedBy="bundleOrderItem", targetEntity=BundleOrderItemFeePriceImpl.class, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    @AdminPresentationCollection(friendlyName="BundleOrderItemImpl_Item_Fee_Prices", tab="OrderImpl_Advanced", tabOrder=2000)
    protected List<BundleOrderItemFeePrice> bundleOrderItemFeePrices = new ArrayList<BundleOrderItemFeePrice>();
    @Column(name="BASE_RETAIL_PRICE", precision=19, scale=5)
    @AdminPresentation(friendlyName="BundleOrderItemImpl_Base_Retail_Price", order=2, group="BundleOrderItemImpl_Pricing", fieldType=SupportedFieldType.MONEY)
    protected BigDecimal baseRetailPrice;
    @Column(name="BASE_SALE_PRICE", precision=19, scale=5)
    @AdminPresentation(friendlyName="BundleOrderItemImpl_Base_Sale_Price", order=2, group="BundleOrderItemImpl_Pricing", fieldType=SupportedFieldType.MONEY)
    protected BigDecimal baseSalePrice;
    @ManyToOne(targetEntity=SkuImpl.class)
    @JoinColumn(name="SKU_ID")
    @NotFound(action=NotFoundAction.IGNORE)
    @AdminPresentation(friendlyName="BundleOrderItemImpl_Sku", order=3000, group="OrderItemImpl_Catalog", groupOrder=3000)
    @AdminPresentationToOneLookup
    protected Sku sku;
    @ManyToOne(targetEntity=ProductBundleImpl.class)
    @JoinColumn(name="PRODUCT_BUNDLE_ID")
    @AdminPresentation(friendlyName="BundleOrderItemImpl_Product", order=2000, group="OrderItemImpl_Catalog", groupOrder=3000)
    @AdminPresentationToOneLookup
    protected ProductBundle productBundle;

    @Override
    public Sku getSku() {
        return this.sku;
    }

    @Override
    public void setSku(Sku sku) {
        this.sku = sku;
        if (sku != null) {
            if (sku.getRetailPrice() != null) {
                this.baseRetailPrice = sku.getRetailPrice().getAmount();
            }
            if (sku.getSalePrice() != null) {
                this.baseSalePrice = sku.getSalePrice().getAmount();
            }
            this.itemTaxable = sku.isTaxable();
            this.setName(sku.getName());
        }
    }

    @Override
    public ProductBundle getProductBundle() {
        return this.productBundle;
    }

    @Override
    public void setProductBundle(ProductBundle productBundle) {
        this.productBundle = productBundle;
    }

    @Override
    public List<? extends OrderItem> getOrderItems() {
        return this.discreteOrderItems;
    }

    @Override
    public boolean getAllowDiscountsOnChildItems() {
        if (this.shouldSumItems()) {
            if (this.productBundle != null) {
                return this.productBundle.getItemsPromotable();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isPricingAtContainerLevel() {
        return !this.shouldSumItems();
    }

    @Override
    public boolean isDiscountingAllowed() {
        if (this.shouldSumItems()) {
            return false;
        }
        return this.productBundle.getBundlePromotable();
    }

    @Override
    public List<DiscreteOrderItem> getDiscreteOrderItems() {
        return this.discreteOrderItems;
    }

    @Override
    public void setDiscreteOrderItems(List<DiscreteOrderItem> discreteOrderItems) {
        this.discreteOrderItems = discreteOrderItems;
    }

    @Override
    public List<BundleOrderItemFeePrice> getBundleOrderItemFeePrices() {
        return this.bundleOrderItemFeePrices;
    }

    @Override
    public void setBundleOrderItemFeePrices(List<BundleOrderItemFeePrice> bundleOrderItemFeePrices) {
        this.bundleOrderItemFeePrices = bundleOrderItemFeePrices;
    }

    @Override
    public Money getTaxablePrice() {
        if (this.shouldSumItems()) {
            Money currentBundleTaxablePrice = BroadleafCurrencyUtils.getMoney((BroadleafCurrency)this.getOrder().getCurrency());
            for (DiscreteOrderItem discreteOrderItem : this.discreteOrderItems) {
                BigDecimal currentItemTaxablePrice = discreteOrderItem.getTaxablePrice().getAmount();
                BigDecimal priceWithQuantity = currentItemTaxablePrice.multiply(new BigDecimal(discreteOrderItem.getQuantity()));
                currentBundleTaxablePrice = currentBundleTaxablePrice.add(BroadleafCurrencyUtils.getMoney((BigDecimal)priceWithQuantity, (BroadleafCurrency)this.getOrder().getCurrency()));
            }
            for (BundleOrderItemFeePrice fee : this.getBundleOrderItemFeePrices()) {
                if (!fee.isTaxable().booleanValue()) continue;
                currentBundleTaxablePrice = currentBundleTaxablePrice.add(fee.getAmount());
            }
            return currentBundleTaxablePrice;
        }
        return super.getTaxablePrice();
    }

    @Override
    public Boolean isTaxable() {
        return this.sku == null || this.sku.isTaxable() == null || this.sku.isTaxable() != false;
    }

    @Override
    public boolean shouldSumItems() {
        if (this.productBundle != null) {
            return ProductBundlePricingModelType.ITEM_SUM.equals(this.productBundle.getPricingModel());
        }
        return true;
    }

    @Override
    public Money getRetailPrice() {
        if (this.shouldSumItems()) {
            Money bundleRetailPrice = BroadleafCurrencyUtils.getMoney((BroadleafCurrency)this.getOrder().getCurrency());
            for (DiscreteOrderItem discreteOrderItem : this.discreteOrderItems) {
                BigDecimal itemRetailPrice = discreteOrderItem.getRetailPrice().getAmount();
                BigDecimal quantityPrice = itemRetailPrice.multiply(new BigDecimal(discreteOrderItem.getQuantity()));
                bundleRetailPrice = bundleRetailPrice.add(BroadleafCurrencyUtils.getMoney((BigDecimal)quantityPrice, (BroadleafCurrency)this.getOrder().getCurrency()));
            }
            for (BundleOrderItemFeePrice fee : this.getBundleOrderItemFeePrices()) {
                bundleRetailPrice = bundleRetailPrice.add(fee.getAmount());
            }
            return bundleRetailPrice;
        }
        return super.getRetailPrice();
    }

    @Override
    public Money getSalePrice() {
        if (this.shouldSumItems()) {
            Money bundleSalePrice = null;
            if (this.hasSaleItems()) {
                bundleSalePrice = BroadleafCurrencyUtils.getMoney((BroadleafCurrency)this.getOrder().getCurrency());
                for (DiscreteOrderItem discreteOrderItem : this.discreteOrderItems) {
                    BigDecimal itemSalePrice = null;
                    itemSalePrice = discreteOrderItem.getSalePrice() != null ? discreteOrderItem.getSalePrice().getAmount() : discreteOrderItem.getRetailPrice().getAmount();
                    BigDecimal quantityPrice = itemSalePrice.multiply(new BigDecimal(discreteOrderItem.getQuantity()));
                    bundleSalePrice = bundleSalePrice.add(BroadleafCurrencyUtils.getMoney((BigDecimal)quantityPrice, (BroadleafCurrency)this.getOrder().getCurrency()));
                }
                for (BundleOrderItemFeePrice fee : this.getBundleOrderItemFeePrices()) {
                    bundleSalePrice = bundleSalePrice.add(fee.getAmount());
                }
            }
            return bundleSalePrice;
        }
        return super.getSalePrice();
    }

    @Override
    public Money getBaseRetailPrice() {
        return this.convertToMoney(this.baseRetailPrice);
    }

    @Override
    public void setBaseRetailPrice(Money baseRetailPrice) {
        this.baseRetailPrice = baseRetailPrice == null ? null : baseRetailPrice.getAmount();
    }

    @Override
    public Money getBaseSalePrice() {
        return this.convertToMoney(this.baseSalePrice);
    }

    @Override
    public void setBaseSalePrice(Money baseSalePrice) {
        this.baseSalePrice = baseSalePrice == null ? null : baseSalePrice.getAmount();
    }

    private boolean hasSaleItems() {
        for (DiscreteOrderItem discreteOrderItem : this.discreteOrderItems) {
            if (discreteOrderItem.getSalePrice() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasAdjustedItems() {
        return false;
    }

    private boolean updateSalePrice() {
        if (this.isSalePriceOverride()) {
            return false;
        }
        if (!this.shouldSumItems() && this.getSku() != null && this.getSku().getSalePrice() != null && !this.getSku().getSalePrice().equals((Object)this.salePrice)) {
            this.baseSalePrice = this.getSku().getSalePrice().getAmount();
            this.salePrice = this.getSku().getSalePrice().getAmount();
            return true;
        }
        return false;
    }

    private boolean updateRetailPrice() {
        if (this.isRetailPriceOverride()) {
            return false;
        }
        if (!this.shouldSumItems() && this.getSku() != null && !this.getSku().getRetailPrice().equals((Object)this.retailPrice)) {
            this.baseRetailPrice = this.getSku().getRetailPrice().getAmount();
            this.retailPrice = this.getSku().getRetailPrice().getAmount();
            return true;
        }
        return false;
    }

    @Override
    public boolean updateSaleAndRetailPrices() {
        boolean saleUpdated = this.updateSalePrice();
        boolean retailUpdated = this.updateRetailPrice();
        return saleUpdated || retailUpdated;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BundleOrderItemImpl other = (BundleOrderItemImpl)obj;
        if (!super.equals(obj)) {
            return false;
        }
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public Product getProduct() {
        return this.getProductBundle();
    }

    @Override
    protected Money convertToMoney(BigDecimal amount) {
        return amount == null ? null : BroadleafCurrencyUtils.getMoney((BigDecimal)amount, (BroadleafCurrency)this.getOrder().getCurrency());
    }

    @Override
    public Money getTotalPrice() {
        Money returnValue = this.convertToMoney(BigDecimal.ZERO);
        if (this.shouldSumItems()) {
            for (OrderItem orderItem : this.getOrderItems()) {
                returnValue = returnValue.add(orderItem.getTotalPrice());
            }
            returnValue = returnValue.multiply(this.quantity);
        } else {
            returnValue = super.getTotalPrice();
        }
        return returnValue;
    }

    @Override
    public boolean isSkuActive() {
        if (this.getSku() != null && !this.getSku().isActive()) {
            return false;
        }
        for (DiscreteOrderItem discreteItem : this.getDiscreteOrderItems()) {
            if (discreteItem.isSkuActive()) continue;
            return false;
        }
        return true;
    }

    @Override
    public OrderItem clone() {
        BundleOrderItemImpl orderItem = (BundleOrderItemImpl)super.clone();
        if (this.discreteOrderItems != null) {
            for (DiscreteOrderItem discreteOrderItem : this.discreteOrderItems) {
                DiscreteOrderItem temp = (DiscreteOrderItem)discreteOrderItem.clone();
                temp.setBundleOrderItem(orderItem);
                orderItem.getDiscreteOrderItems().add(temp);
            }
        }
        if (this.bundleOrderItemFeePrices != null) {
            for (BundleOrderItemFeePrice feePrice : this.bundleOrderItemFeePrices) {
                BundleOrderItemFeePrice cloneFeePrice = feePrice.clone();
                cloneFeePrice.setBundleOrderItem(orderItem);
                orderItem.getBundleOrderItemFeePrices().add(cloneFeePrice);
            }
        }
        orderItem.setBaseRetailPrice(this.convertToMoney(this.baseRetailPrice));
        orderItem.setBaseSalePrice(this.convertToMoney(this.baseSalePrice));
        orderItem.setSku(this.sku);
        orderItem.setProductBundle(this.productBundle);
        return orderItem;
    }

    @Override
    public int hashCode() {
        int prime = super.hashCode();
        int result = 1;
        result = prime * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public static class Presentation {

        public static class FieldOrder {
            public static final int PRODUCT = 2000;
            public static final int SKU = 3000;
        }

        public static class Group {

            public static class Order {
            }

            public static class Name {
            }
        }

        public static class Tab {

            public static class Order {
                public static final int OrderItems = 2000;
            }

            public static class Name {
                public static final String OrderItems = "OrderImpl_Order_Items_Tab";
            }
        }
    }
}

