/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.domain;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrency;
import org.broadleafcommerce.common.currency.util.BroadleafCurrencyUtils;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeEntry;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeOverride;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeOverrides;
import org.broadleafcommerce.core.order.domain.BundleOrderItem;
import org.broadleafcommerce.core.order.domain.BundleOrderItemFeePrice;
import org.broadleafcommerce.core.order.domain.BundleOrderItemImpl;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@DiscriminatorColumn(name="TYPE")
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_BUND_ITEM_FEE_PRICE")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
@AdminPresentationMergeOverrides(value={@AdminPresentationMergeOverride(name="", mergeEntries={@AdminPresentationMergeEntry(propertyType="readOnly", booleanOverrideValue=true)})})
public class BundleOrderItemFeePriceImpl
implements BundleOrderItemFeePrice {
    public static final Log LOG = LogFactory.getLog(BundleOrderItemFeePriceImpl.class);
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="BundleOrderItemFeePriceId")
    @GenericGenerator(name="BundleOrderItemFeePriceId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="BundleOrderItemFeePriceImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.order.domain.BundleOrderItemFeePriceImpl")})
    @Column(name="BUND_ITEM_FEE_PRICE_ID")
    protected Long id;
    @ManyToOne(targetEntity=BundleOrderItemImpl.class, optional=false)
    @JoinColumn(name="BUND_ORDER_ITEM_ID")
    protected BundleOrderItem bundleOrderItem;
    @Column(name="AMOUNT", precision=19, scale=5)
    @AdminPresentation(friendlyName="BundleOrderItemFeePriceImpl_Amount", order=2, prominent=true)
    protected BigDecimal amount;
    @Column(name="NAME")
    @AdminPresentation(friendlyName="BundleOrderItemFeePriceImpl_Name", order=1, prominent=true)
    private String name;
    @Column(name="REPORTING_CODE")
    @AdminPresentation(friendlyName="BundleOrderItemFeePriceImpl_Reporting_Code", order=3, prominent=true)
    private String reportingCode;
    @Column(name="IS_TAXABLE")
    @AdminPresentation(friendlyName="BundleOrderItemFeePriceImpl_Taxable", order=4)
    private Boolean isTaxable = Boolean.FALSE;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public BundleOrderItem getBundleOrderItem() {
        return this.bundleOrderItem;
    }

    @Override
    public void setBundleOrderItem(BundleOrderItem bundleOrderItem) {
        this.bundleOrderItem = bundleOrderItem;
    }

    @Override
    public Money getAmount() {
        return this.convertToMoney(this.amount);
    }

    @Override
    public void setAmount(Money amount) {
        this.amount = Money.toAmount((Money)amount);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Boolean isTaxable() {
        return this.isTaxable;
    }

    @Override
    public void setTaxable(Boolean isTaxable) {
        this.isTaxable = isTaxable;
    }

    @Override
    public String getReportingCode() {
        return this.reportingCode;
    }

    @Override
    public void setReportingCode(String reportingCode) {
        this.reportingCode = reportingCode;
    }

    public void checkCloneable(BundleOrderItemFeePrice bundleFeePrice) throws CloneNotSupportedException, SecurityException, NoSuchMethodException {
        Method cloneMethod = bundleFeePrice.getClass().getMethod("clone", new Class[0]);
        if (cloneMethod.getDeclaringClass().getName().startsWith("org.broadleafcommerce") && !bundleFeePrice.getClass().getName().startsWith("org.broadleafcommerce")) {
            throw new CloneNotSupportedException("Custom extensions and implementations should implement clone in order to guarantee split and merge operations are performed accurately");
        }
    }

    protected Money convertToMoney(BigDecimal amount) {
        return amount == null ? null : BroadleafCurrencyUtils.getMoney((BigDecimal)amount, (BroadleafCurrency)this.bundleOrderItem.getOrder().getCurrency());
    }

    @Override
    public BundleOrderItemFeePrice clone() {
        BundleOrderItemFeePrice clone;
        try {
            clone = (BundleOrderItemFeePrice)Class.forName(this.getClass().getName()).newInstance();
            try {
                this.checkCloneable(clone);
            }
            catch (CloneNotSupportedException e) {
                LOG.warn((Object)("Clone implementation missing in inheritance hierarchy outside of Broadleaf: " + clone.getClass().getName()), (Throwable)e);
            }
            clone.setAmount(this.convertToMoney(this.amount));
            clone.setName(this.name);
            clone.setReportingCode(this.reportingCode);
            clone.setBundleOrderItem(this.bundleOrderItem);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return clone;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.amount == null ? 0 : this.amount.hashCode());
        result = 31 * result + (this.bundleOrderItem == null ? 0 : this.bundleOrderItem.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.isTaxable != false ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.reportingCode == null ? 0 : this.reportingCode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BundleOrderItemFeePriceImpl other = (BundleOrderItemFeePriceImpl)obj;
        if (this.amount == null ? other.amount != null : !this.amount.equals(other.amount)) {
            return false;
        }
        if (this.bundleOrderItem == null ? other.bundleOrderItem != null : !this.bundleOrderItem.equals(other.bundleOrderItem)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.isTaxable != other.isTaxable) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.reportingCode == null ? other.reportingCode != null : !this.reportingCode.equals(other.reportingCode));
    }
}

