/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.discount.domain;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrency;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.service.discount.domain.AbstractPromotionRounding;
import org.broadleafcommerce.core.offer.service.discount.domain.OfferHolder;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateFulfillmentGroupOffer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableFulfillmentGroup;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableFulfillmentGroupAdjustment;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOfferUtility;
import org.broadleafcommerce.core.offer.service.type.OfferDiscountType;

public class PromotableFulfillmentGroupAdjustmentImpl
extends AbstractPromotionRounding
implements PromotableFulfillmentGroupAdjustment,
OfferHolder {
    private static final long serialVersionUID = 1L;
    protected PromotableCandidateFulfillmentGroupOffer promotableCandidateFulfillmentGroupOffer;
    protected PromotableFulfillmentGroup promotableFulfillmentGroup;
    protected Money saleAdjustmentValue;
    protected Money retailAdjustmentValue;
    protected Money adjustmentValue;
    protected boolean appliedToSalePrice;

    public PromotableFulfillmentGroupAdjustmentImpl(PromotableCandidateFulfillmentGroupOffer promotableCandidateFulfillmentGroupOffer, PromotableFulfillmentGroup fulfillmentGroup) {
        this.promotableCandidateFulfillmentGroupOffer = promotableCandidateFulfillmentGroupOffer;
        this.promotableFulfillmentGroup = fulfillmentGroup;
        this.computeAdjustmentValues();
    }

    @Override
    public Offer getOffer() {
        return this.promotableCandidateFulfillmentGroupOffer.getOffer();
    }

    protected void computeAdjustmentValues() {
        this.saleAdjustmentValue = new Money(this.getCurrency());
        this.retailAdjustmentValue = new Money(this.getCurrency());
        Offer offer = this.promotableCandidateFulfillmentGroupOffer.getOffer();
        Money currentPriceDetailSalesValue = this.promotableFulfillmentGroup.calculatePriceWithAdjustments(true);
        Money currentPriceDetailRetailValue = this.promotableFulfillmentGroup.calculatePriceWithAdjustments(false);
        this.retailAdjustmentValue = PromotableOfferUtility.computeAdjustmentValue(currentPriceDetailRetailValue, offer.getValue(), this, this);
        if (offer.getApplyDiscountToSalePrice()) {
            this.saleAdjustmentValue = PromotableOfferUtility.computeAdjustmentValue(currentPriceDetailSalesValue, offer.getValue(), this, this);
        }
    }

    protected Money computeAdjustmentValue(Money currentPriceDetailValue) {
        Offer offer = this.promotableCandidateFulfillmentGroupOffer.getOffer();
        OfferDiscountType discountType = offer.getDiscountType();
        Money adjustmentValue = new Money(this.getCurrency());
        if (OfferDiscountType.AMOUNT_OFF.equals(discountType)) {
            adjustmentValue = new Money(offer.getValue(), this.getCurrency());
        }
        if (OfferDiscountType.FIX_PRICE.equals(discountType)) {
            adjustmentValue = currentPriceDetailValue;
        }
        if (OfferDiscountType.PERCENT_OFF.equals(discountType)) {
            BigDecimal offerValue = currentPriceDetailValue.getAmount().multiply(offer.getValue().divide(new BigDecimal("100"), 5, RoundingMode.HALF_EVEN));
            if (this.isRoundOfferValues()) {
                offerValue = offerValue.setScale(this.roundingScale, this.roundingMode);
            }
            adjustmentValue = new Money(offerValue, this.getCurrency(), 5);
        }
        if (currentPriceDetailValue.lessThan(adjustmentValue)) {
            adjustmentValue = currentPriceDetailValue;
        }
        return adjustmentValue;
    }

    @Override
    public PromotableFulfillmentGroup getPromotableFulfillmentGroup() {
        return this.promotableFulfillmentGroup;
    }

    @Override
    public PromotableCandidateFulfillmentGroupOffer getPromotableCandidateFulfillmentGroupOffer() {
        return this.promotableCandidateFulfillmentGroupOffer;
    }

    @Override
    public Money getAdjustmentValue() {
        return this.adjustmentValue;
    }

    @Override
    public BroadleafCurrency getCurrency() {
        return this.promotableFulfillmentGroup.getFulfillmentGroup().getOrder().getCurrency();
    }

    @Override
    public boolean isCombinable() {
        Boolean combinable = this.getOffer().isCombinableWithOtherOffers();
        return combinable != null && combinable != false;
    }

    @Override
    public boolean isTotalitarian() {
        Boolean totalitarian = this.getOffer().isTotalitarianOffer();
        return totalitarian != null && totalitarian != false;
    }

    @Override
    public Money getSaleAdjustmentValue() {
        return this.saleAdjustmentValue;
    }

    @Override
    public Money getRetailAdjustmentValue() {
        return this.retailAdjustmentValue;
    }

    @Override
    public boolean isAppliedToSalePrice() {
        return this.appliedToSalePrice;
    }

    @Override
    public void finalizeAdjustment(boolean useSalePrice) {
        this.appliedToSalePrice = useSalePrice;
        this.adjustmentValue = useSalePrice ? this.saleAdjustmentValue : this.retailAdjustmentValue;
    }
}

