/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.discount;

import java.io.Serializable;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferItemCriteria;

public class PromotionQualifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Offer promotion;
    private OfferItemCriteria itemCriteria;
    private int quantity;
    private int finalizedQuantity;

    public Offer getPromotion() {
        return this.promotion;
    }

    public void setPromotion(Offer promotion) {
        this.promotion = promotion;
    }

    public OfferItemCriteria getItemCriteria() {
        return this.itemCriteria;
    }

    public void setItemCriteria(OfferItemCriteria itemCriteria) {
        this.itemCriteria = itemCriteria;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    public int getFinalizedQuantity() {
        return this.finalizedQuantity;
    }

    public void setFinalizedQuantity(int finalizedQuantity) {
        this.finalizedQuantity = finalizedQuantity;
    }

    public void incrementQuantity(int quantity) {
        this.quantity += quantity;
    }

    public PromotionQualifier copy() {
        PromotionQualifier pq = new PromotionQualifier();
        pq.setItemCriteria(this.itemCriteria);
        pq.setPromotion(this.promotion);
        pq.setQuantity(this.quantity);
        pq.setFinalizedQuantity(this.finalizedQuantity);
        return pq;
    }

    public void resetQty(int qty) {
        this.quantity = qty;
        this.finalizedQuantity = qty;
    }

    public PromotionQualifier split(int splitItemQty) {
        PromotionQualifier returnQualifier = this.copy();
        int newQty = this.finalizedQuantity - splitItemQty;
        if (newQty <= 0) {
            throw new IllegalArgumentException("Splitting PromotionQualifier resulted in a negative quantity");
        }
        this.setFinalizedQuantity(newQty);
        this.setQuantity(newQty);
        returnQualifier.setQuantity(splitItemQty);
        returnQualifier.setFinalizedQuantity(splitItemQty);
        return returnQualifier;
    }

    public boolean isFinalized() {
        return this.quantity == this.finalizedQuantity;
    }
}

