/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.checkout.service.workflow;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.payment.PaymentTransactionType;
import org.broadleafcommerce.common.payment.dto.PaymentResponseDTO;
import org.broadleafcommerce.common.payment.service.PaymentGatewayConfigurationService;
import org.broadleafcommerce.common.payment.service.PaymentGatewayConfigurationServiceProvider;
import org.broadleafcommerce.core.checkout.service.exception.CheckoutException;
import org.broadleafcommerce.core.checkout.service.workflow.CheckoutSeed;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.payment.domain.OrderPayment;
import org.broadleafcommerce.core.payment.domain.PaymentTransaction;
import org.broadleafcommerce.core.payment.service.OrderPaymentService;
import org.broadleafcommerce.core.payment.service.OrderToPaymentRequestDTOService;
import org.broadleafcommerce.core.workflow.BaseActivity;
import org.broadleafcommerce.core.workflow.ProcessContext;
import org.broadleafcommerce.core.workflow.state.ActivityStateManagerImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class ValidateAndConfirmPaymentActivity
extends BaseActivity<ProcessContext<CheckoutSeed>> {
    protected static final Log LOG = LogFactory.getLog(ValidateAndConfirmPaymentActivity.class);
    public static final String CONFIRMED_TRANSACTIONS = "confirmedTransactions";
    @Autowired(required=false)
    @Qualifier(value="blPaymentGatewayConfigurationServiceProvider")
    protected PaymentGatewayConfigurationServiceProvider paymentConfigurationServiceProvider;
    @Resource(name="blOrderToPaymentRequestDTOService")
    protected OrderToPaymentRequestDTOService orderToPaymentRequestService;
    @Resource(name="blOrderPaymentService")
    protected OrderPaymentService orderPaymentService;

    @Override
    public ProcessContext<CheckoutSeed> execute(ProcessContext<CheckoutSeed> context) throws Exception {
        Order order = context.getSeedData().getOrder();
        HashMap<String, Object> rollbackState = new HashMap<String, Object>();
        HashMap<OrderPayment, PaymentTransaction> additionalTransactions = new HashMap<OrderPayment, PaymentTransaction>();
        ArrayList<PaymentTransaction> confirmedTransactions = new ArrayList<PaymentTransaction>();
        for (OrderPayment payment : order.getPayments()) {
            if (!payment.isActive()) continue;
            for (PaymentTransaction tx : payment.getTransactions()) {
                if (PaymentTransactionType.UNCONFIRMED.equals((Object)tx.getType())) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Transaction " + tx.getId() + " is not confirmed. Proceeding to confirm transaction."));
                    }
                    if (this.paymentConfigurationServiceProvider == null) {
                        String msg = "There are unconfirmed payment transactions on this payment but no payment gateway configuration or transaction confirmation service configured";
                        LOG.error((Object)msg);
                        throw new CheckoutException(msg, context.getSeedData());
                    }
                    PaymentGatewayConfigurationService cfg = this.paymentConfigurationServiceProvider.getGatewayConfigurationService(tx.getOrderPayment().getGatewayType());
                    PaymentResponseDTO responseDTO = cfg.getTransactionConfirmationService().confirmTransaction(this.orderToPaymentRequestService.translatePaymentTransaction(payment.getAmount(), tx));
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Transaction Confirmation Raw Response: " + responseDTO.getRawResponse()));
                    }
                    if (responseDTO.isSuccessful()) {
                        PaymentTransaction transaction = this.orderPaymentService.createTransaction();
                        transaction.setAmount(responseDTO.getAmount());
                        transaction.setRawResponse(responseDTO.getRawResponse());
                        transaction.setSuccess(responseDTO.isSuccessful());
                        transaction.setType(responseDTO.getPaymentTransactionType());
                        transaction.setParentTransaction(tx);
                        transaction.setOrderPayment(payment);
                        transaction.setAdditionalFields(responseDTO.getResponseMap());
                        confirmedTransactions.add(transaction);
                        additionalTransactions.put(payment, transaction);
                        continue;
                    }
                    String msg = "Transaction confirmation attempt with id: " + tx.getId() + " was unsuccessful";
                    LOG.error((Object)msg);
                    throw new CheckoutException(msg, context.getSeedData());
                }
                if (!PaymentTransactionType.AUTHORIZE.equals((Object)tx.getType()) && !PaymentTransactionType.AUTHORIZE_AND_CAPTURE.equals((Object)tx.getType())) continue;
                confirmedTransactions.add(tx);
            }
        }
        rollbackState.put(CONFIRMED_TRANSACTIONS, confirmedTransactions);
        ActivityStateManagerImpl.getStateManager().registerState(this, context, this.getRollbackHandler(), rollbackState);
        for (OrderPayment payment : order.getPayments()) {
            if (!additionalTransactions.containsKey(payment)) continue;
            payment.addTransaction((PaymentTransaction)additionalTransactions.get(payment));
        }
        Money paymentSum = new Money(BigDecimal.ZERO);
        for (OrderPayment payment : order.getPayments()) {
            if (!payment.isActive()) continue;
            paymentSum = paymentSum.add(payment.getSuccessfulTransactionAmountForType(PaymentTransactionType.AUTHORIZE)).add(payment.getSuccessfulTransactionAmountForType(PaymentTransactionType.AUTHORIZE_AND_CAPTURE));
        }
        if (paymentSum.lessThan(order.getTotal())) {
            throw new IllegalArgumentException("There are not enough payments to pay for the total order. The sum of the payments is " + paymentSum.getAmount().toPlainString() + " and the order total is " + order.getTotal().getAmount().toPlainString());
        }
        return context;
    }
}

