/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.checkout.service.workflow;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.broadleafcommerce.common.time.SystemTime;
import org.broadleafcommerce.core.checkout.service.workflow.CheckoutSeed;
import org.broadleafcommerce.core.order.service.type.OrderStatus;
import org.broadleafcommerce.core.workflow.BaseActivity;
import org.broadleafcommerce.core.workflow.ProcessContext;

public class CompleteOrderActivity
extends BaseActivity<ProcessContext<CheckoutSeed>> {
    public CompleteOrderActivity() {
        this.setAutomaticallyRegisterRollbackHandler(true);
    }

    @Override
    public ProcessContext<CheckoutSeed> execute(ProcessContext<CheckoutSeed> context) throws Exception {
        CheckoutSeed seed = context.getSeedData();
        seed.getOrder().setStatus(this.getCompletedStatus());
        seed.getOrder().setOrderNumber(new SimpleDateFormat("yyyyMMddHHmmssS").format(SystemTime.asDate()) + seed.getOrder().getId());
        seed.getOrder().setSubmitDate(Calendar.getInstance().getTime());
        return context;
    }

    protected OrderStatus getCompletedStatus() {
        return OrderStatus.SUBMITTED;
    }
}

