/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.domain;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.admin.domain.AdminMainEntity;
import org.broadleafcommerce.common.extensibility.jpa.clone.ClonePolicy;
import org.broadleafcommerce.common.extensibility.jpa.clone.ClonePolicyAdornedTargetCollection;
import org.broadleafcommerce.common.extensibility.jpa.clone.ClonePolicyCollection;
import org.broadleafcommerce.common.extensibility.jpa.clone.ClonePolicyMap;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransform;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransformMember;
import org.broadleafcommerce.common.extension.ExtensionResultHolder;
import org.broadleafcommerce.common.extension.ExtensionResultStatusType;
import org.broadleafcommerce.common.media.domain.Media;
import org.broadleafcommerce.common.persistence.ArchiveStatus;
import org.broadleafcommerce.common.persistence.Status;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationAdornedTargetCollection;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.AdminPresentationCollection;
import org.broadleafcommerce.common.presentation.AdminPresentationMap;
import org.broadleafcommerce.common.presentation.AdminPresentationToOneLookup;
import org.broadleafcommerce.common.presentation.PopulateToOneFieldsEnum;
import org.broadleafcommerce.common.presentation.RequiredOverride;
import org.broadleafcommerce.common.presentation.ValidationConfiguration;
import org.broadleafcommerce.common.presentation.client.VisibilityEnum;
import org.broadleafcommerce.common.util.DateUtil;
import org.broadleafcommerce.common.vendor.service.type.ContainerShapeType;
import org.broadleafcommerce.common.vendor.service.type.ContainerSizeType;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.common.web.Locatable;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.CategoryImpl;
import org.broadleafcommerce.core.catalog.domain.CategoryProductXref;
import org.broadleafcommerce.core.catalog.domain.CategoryProductXrefImpl;
import org.broadleafcommerce.core.catalog.domain.CrossSaleProductImpl;
import org.broadleafcommerce.core.catalog.domain.Dimension;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductAttribute;
import org.broadleafcommerce.core.catalog.domain.ProductAttributeImpl;
import org.broadleafcommerce.core.catalog.domain.ProductOption;
import org.broadleafcommerce.core.catalog.domain.ProductOptionXref;
import org.broadleafcommerce.core.catalog.domain.ProductOptionXrefImpl;
import org.broadleafcommerce.core.catalog.domain.RelatedProduct;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.domain.SkuImpl;
import org.broadleafcommerce.core.catalog.domain.UpSaleProductImpl;
import org.broadleafcommerce.core.catalog.domain.Weight;
import org.broadleafcommerce.core.catalog.extension.ProductEntityExtensionHandler;
import org.broadleafcommerce.core.catalog.extension.ProductEntityExtensionManager;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.SQLDelete;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_PRODUCT")
@org.hibernate.annotations.Table(appliesTo="BLC_PRODUCT", indexes={@Index(name="PRODUCT_URL_INDEX", columnNames={"URL", "URL_KEY"})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blProducts")
@AdminPresentationClass(populateToOneFields=PopulateToOneFieldsEnum.TRUE, friendlyName="baseProduct")
@SQLDelete(sql="UPDATE BLC_PRODUCT SET ARCHIVED = 'Y' WHERE PRODUCT_ID = ?")
@DirectCopyTransform(value={@DirectCopyTransformMember(templateTokens={"sandbox"}, skipOverlaps=true), @DirectCopyTransformMember(templateTokens={"sandboxPreCloneInformation"}), @DirectCopyTransformMember(templateTokens={"multiTenantCatalog"})})
public class ProductImpl
implements Product,
Status,
AdminMainEntity,
Locatable {
    private static final Log LOG = LogFactory.getLog(ProductImpl.class);
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="ProductId")
    @GenericGenerator(name="ProductId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="ProductImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.catalog.domain.ProductImpl")})
    @Column(name="PRODUCT_ID")
    @AdminPresentation(friendlyName="ProductImpl_Product_ID", visibility=VisibilityEnum.HIDDEN_ALL)
    protected Long id;
    @Column(name="URL")
    @AdminPresentation(friendlyName="ProductImpl_Product_Url", order=7000, group="ProductImpl_Product_Description", groupOrder=1000, prominent=true, gridOrder=3, columnWidth="200px", requiredOverride=RequiredOverride.REQUIRED, validationConfigurations={@ValidationConfiguration(validationImplementation="blUriPropertyValidator")})
    protected String url;
    @Column(name="URL_KEY")
    @AdminPresentation(friendlyName="ProductImpl_Product_UrlKey", tab="ProductImpl_Advanced_Tab", tabOrder=7000, group="ProductImpl_Product_Description", groupOrder=1000, excluded=true)
    protected String urlKey;
    @Column(name="DISPLAY_TEMPLATE")
    @AdminPresentation(friendlyName="ProductImpl_Product_Display_Template", tab="ProductImpl_Advanced_Tab", tabOrder=7000, group="ProductImpl_Advanced", groupOrder=1000)
    protected String displayTemplate;
    @Column(name="MODEL")
    @AdminPresentation(friendlyName="ProductImpl_Product_Model", tab="ProductImpl_Advanced_Tab", tabOrder=7000, group="ProductImpl_Advanced", groupOrder=1000)
    protected String model;
    @Column(name="MANUFACTURE")
    @AdminPresentation(friendlyName="ProductImpl_Product_Manufacturer", order=6000, group="ProductImpl_Product_Description", groupOrder=1000, prominent=true, gridOrder=4)
    protected String manufacturer;
    @Column(name="IS_FEATURED_PRODUCT", nullable=false)
    @AdminPresentation(friendlyName="ProductImpl_Is_Featured_Product", requiredOverride=RequiredOverride.NOT_REQUIRED, tab="ProductImpl_Marketing_Tab", tabOrder=2000, group="ProductImpl_Badges", groupOrder=1000)
    protected Boolean isFeaturedProduct = false;
    @OneToOne(targetEntity=SkuImpl.class, cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blProducts")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    @JoinColumn(name="DEFAULT_SKU_ID")
    @ClonePolicy(toOneProperty="defaultProduct")
    protected Sku defaultSku;
    @Column(name="CAN_SELL_WITHOUT_OPTIONS")
    @AdminPresentation(friendlyName="ProductImpl_Can_Sell_Without_Options", tab="ProductImpl_Advanced_Tab", tabOrder=7000, group="ProductImpl_Advanced", groupOrder=1000)
    protected Boolean canSellWithoutOptions = false;
    @Transient
    protected List<Sku> skus = new ArrayList<Sku>();
    @Transient
    protected String promoMessage;
    @OneToMany(mappedBy="product", targetEntity=CrossSaleProductImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blProducts")
    @OrderBy(value="sequence")
    @AdminPresentationAdornedTargetCollection(friendlyName="crossSaleProductsTitle", order=1000, tab="ProductImpl_Marketing_Tab", tabOrder=2000, targetObjectProperty="relatedSaleProduct", sortProperty="sequence", maintainedAdornedTargetFields={"promotionMessage"}, gridVisibleFields={"defaultSku.name", "promotionMessage"})
    @ClonePolicyAdornedTargetCollection
    protected List<RelatedProduct> crossSaleProducts = new ArrayList<RelatedProduct>();
    @OneToMany(mappedBy="product", targetEntity=UpSaleProductImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blProducts")
    @OrderBy(value="sequence")
    @AdminPresentationAdornedTargetCollection(friendlyName="upsaleProductsTitle", order=2000, tab="ProductImpl_Marketing_Tab", tabOrder=2000, targetObjectProperty="relatedSaleProduct", sortProperty="sequence", maintainedAdornedTargetFields={"promotionMessage"}, gridVisibleFields={"defaultSku.name", "promotionMessage"})
    @ClonePolicyAdornedTargetCollection
    protected List<RelatedProduct> upSaleProducts = new ArrayList<RelatedProduct>();
    @OneToMany(fetch=FetchType.LAZY, targetEntity=SkuImpl.class, mappedBy="product")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blProducts")
    @BatchSize(size=50)
    @AdminPresentationCollection(friendlyName="ProductImpl_Additional_Skus", order=1000, tab="ProductImpl_Product_Options_Tab", tabOrder=4000)
    @ClonePolicyCollection
    protected List<Sku> additionalSkus = new ArrayList<Sku>();
    @ManyToOne(targetEntity=CategoryImpl.class)
    @JoinColumn(name="DEFAULT_CATEGORY_ID")
    @Index(name="PRODUCT_CATEGORY_INDEX", columnNames={"DEFAULT_CATEGORY_ID"})
    @AdminPresentation(friendlyName="ProductImpl_Product_Default_Category", order=5000, group="ProductImpl_Product_Description", groupOrder=1000, prominent=true, gridOrder=2, requiredOverride=RequiredOverride.REQUIRED)
    @AdminPresentationToOneLookup
    protected Category defaultCategory;
    @OneToMany(targetEntity=CategoryProductXrefImpl.class, mappedBy="product", orphanRemoval=true)
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST})
    @OrderBy(value="displayOrder")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blProducts")
    @BatchSize(size=50)
    @AdminPresentationAdornedTargetCollection(friendlyName="allParentCategoriesTitle", order=3000, tab="ProductImpl_Marketing_Tab", tabOrder=2000, joinEntityClass="org.broadleafcommerce.core.catalog.domain.CategoryProductXrefImpl", targetObjectProperty="category", parentObjectProperty="product", gridVisibleFields={"name"})
    @ClonePolicyAdornedTargetCollection(unowned=true)
    protected List<CategoryProductXref> allParentCategoryXrefs = new ArrayList<CategoryProductXref>();
    @OneToMany(mappedBy="product", targetEntity=ProductAttributeImpl.class, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blProducts")
    @MapKey(name="name")
    @BatchSize(size=50)
    @AdminPresentationMap(friendlyName="productAttributesTitle", tab="ProductImpl_Advanced_Tab", tabOrder=7000, deleteEntityUponRemove=true, forceFreeFormKeys=true, keyPropertyFriendlyName="ProductAttributeImpl_Attribute_Name")
    @ClonePolicyMap
    protected Map<String, ProductAttribute> productAttributes = new HashMap<String, ProductAttribute>();
    @OneToMany(targetEntity=ProductOptionXrefImpl.class, mappedBy="product")
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blProducts")
    @BatchSize(size=50)
    @AdminPresentationAdornedTargetCollection(friendlyName="productOptionsTitle", tab="ProductImpl_Product_Options_Tab", tabOrder=4000, joinEntityClass="org.broadleafcommerce.core.catalog.domain.ProductOptionXrefImpl", targetObjectProperty="productOption", parentObjectProperty="product", gridVisibleFields={"label", "required"})
    protected List<ProductOptionXref> productOptions = new ArrayList<ProductOptionXref>();
    @Embedded
    protected ArchiveStatus archiveStatus = new ArchiveStatus();

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.getDefaultSku().getName();
    }

    @Override
    public void setName(String name) {
        this.getDefaultSku().setName(name);
    }

    @Override
    public String getDescription() {
        return this.getDefaultSku().getDescription();
    }

    @Override
    public void setDescription(String description) {
        this.getDefaultSku().setDescription(description);
    }

    @Override
    public String getLongDescription() {
        return this.getDefaultSku().getLongDescription();
    }

    @Override
    public void setLongDescription(String longDescription) {
        this.getDefaultSku().setLongDescription(longDescription);
    }

    @Override
    public Date getActiveStartDate() {
        return this.getDefaultSku().getActiveStartDate();
    }

    @Override
    public void setActiveStartDate(Date activeStartDate) {
        this.getDefaultSku().setActiveStartDate(activeStartDate);
    }

    @Override
    public Date getActiveEndDate() {
        return this.getDefaultSku().getActiveEndDate();
    }

    @Override
    public void setActiveEndDate(Date activeEndDate) {
        this.getDefaultSku().setActiveEndDate(activeEndDate);
    }

    @Override
    public boolean isActive() {
        if (LOG.isDebugEnabled()) {
            if (!DateUtil.isActive((Date)this.getActiveStartDate(), (Date)this.getActiveEndDate(), (boolean)true)) {
                LOG.debug((Object)("product, " + this.id + ", inactive due to date"));
            }
            if ('Y' == this.getArchived().charValue()) {
                LOG.debug((Object)("product, " + this.id + ", inactive due to archived status"));
            }
        }
        return DateUtil.isActive((Date)this.getActiveStartDate(), (Date)this.getActiveEndDate(), (boolean)true) && 'Y' != this.getArchived().charValue();
    }

    @Override
    public String getModel() {
        return this.model;
    }

    @Override
    public void setModel(String model) {
        this.model = model;
    }

    @Override
    public String getManufacturer() {
        return this.manufacturer;
    }

    @Override
    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    @Override
    public boolean isFeaturedProduct() {
        return this.isFeaturedProduct;
    }

    @Override
    public void setFeaturedProduct(boolean isFeaturedProduct) {
        this.isFeaturedProduct = isFeaturedProduct;
    }

    @Override
    public Sku getDefaultSku() {
        return this.defaultSku;
    }

    @Override
    public Boolean getCanSellWithoutOptions() {
        return this.canSellWithoutOptions == null ? false : this.canSellWithoutOptions;
    }

    @Override
    public void setCanSellWithoutOptions(Boolean canSellWithoutOptions) {
        this.canSellWithoutOptions = canSellWithoutOptions;
    }

    @Override
    public void setDefaultSku(Sku defaultSku) {
        defaultSku.setDefaultProduct(this);
        this.defaultSku = defaultSku;
    }

    @Override
    public String getPromoMessage() {
        return this.promoMessage;
    }

    @Override
    public void setPromoMessage(String promoMessage) {
        this.promoMessage = promoMessage;
    }

    @Override
    public List<Sku> getAllSkus() {
        ArrayList<Sku> allSkus = new ArrayList<Sku>();
        allSkus.add(this.getDefaultSku());
        for (Sku additionalSku : this.additionalSkus) {
            if (additionalSku.getId().equals(this.getDefaultSku().getId())) continue;
            allSkus.add(additionalSku);
        }
        return allSkus;
    }

    @Override
    public List<Sku> getSkus() {
        if (this.skus.size() == 0) {
            List<Sku> additionalSkus = this.getAdditionalSkus();
            for (Sku sku : additionalSkus) {
                if (!sku.isActive()) continue;
                this.skus.add(sku);
            }
        }
        return this.skus;
    }

    @Override
    public List<Sku> getAdditionalSkus() {
        return this.additionalSkus;
    }

    @Override
    public void setAdditionalSkus(List<Sku> skus) {
        this.additionalSkus.clear();
        for (Sku sku : skus) {
            this.additionalSkus.add(sku);
        }
    }

    @Override
    public Category getDefaultCategory() {
        return this.defaultCategory;
    }

    @Override
    public Map<String, Media> getMedia() {
        return this.getDefaultSku().getSkuMedia();
    }

    @Override
    public void setMedia(Map<String, Media> media) {
        this.getDefaultSku().setSkuMedia(media);
    }

    @Override
    public Map<String, Media> getAllSkuMedia() {
        HashMap<String, Media> result = new HashMap<String, Media>();
        result.putAll(this.getMedia());
        for (Sku additionalSku : this.getAdditionalSkus()) {
            if (additionalSku.getId().equals(this.getDefaultSku().getId())) continue;
            result.putAll(additionalSku.getSkuMedia());
        }
        return result;
    }

    @Override
    public void setDefaultCategory(Category defaultCategory) {
        this.defaultCategory = defaultCategory;
    }

    @Override
    public List<CategoryProductXref> getAllParentCategoryXrefs() {
        BroadleafRequestContext context = BroadleafRequestContext.getBroadleafRequestContext();
        if (context != null && context.getAdditionalProperties().containsKey("blProductEntityExtensionManager")) {
            ProductEntityExtensionManager extensionManager = (ProductEntityExtensionManager)((Object)context.getAdditionalProperties().get("blProductEntityExtensionManager"));
            ExtensionResultHolder holder = new ExtensionResultHolder();
            ExtensionResultStatusType result = ((ProductEntityExtensionHandler)extensionManager.getProxy()).getAllParentCategoryXrefs(this, holder);
            if (ExtensionResultStatusType.HANDLED.equals((Object)result)) {
                return (List)holder.getResult();
            }
        }
        return this.allParentCategoryXrefs;
    }

    @Override
    public void setAllParentCategoryXrefs(List<CategoryProductXref> allParentCategories) {
        this.allParentCategoryXrefs.clear();
        this.allParentCategoryXrefs.addAll(allParentCategories);
    }

    @Override
    @Deprecated
    public List<Category> getAllParentCategories() {
        BroadleafRequestContext context = BroadleafRequestContext.getBroadleafRequestContext();
        if (context != null && context.getAdditionalProperties().containsKey("blProductEntityExtensionManager")) {
            ProductEntityExtensionManager extensionManager = (ProductEntityExtensionManager)((Object)context.getAdditionalProperties().get("blProductEntityExtensionManager"));
            ExtensionResultHolder holder = new ExtensionResultHolder();
            ExtensionResultStatusType result = ((ProductEntityExtensionHandler)extensionManager.getProxy()).getAllParentCategories(this, holder);
            if (ExtensionResultStatusType.HANDLED.equals((Object)result)) {
                return (List)holder.getResult();
            }
        }
        ArrayList<Category> parents = new ArrayList<Category>();
        for (CategoryProductXref xref : this.allParentCategoryXrefs) {
            parents.add(xref.getCategory());
        }
        return Collections.unmodifiableList(parents);
    }

    @Override
    @Deprecated
    public void setAllParentCategories(List<Category> allParentCategories) {
        throw new UnsupportedOperationException("Not Supported - Use setAllParentCategoryXrefs()");
    }

    @Override
    public Dimension getDimension() {
        return this.getDefaultSku().getDimension();
    }

    @Override
    public void setDimension(Dimension dimension) {
        this.getDefaultSku().setDimension(dimension);
    }

    @Override
    public BigDecimal getWidth() {
        return this.getDefaultSku().getDimension().getWidth();
    }

    @Override
    public void setWidth(BigDecimal width) {
        this.getDefaultSku().getDimension().setWidth(width);
    }

    @Override
    public BigDecimal getHeight() {
        return this.getDefaultSku().getDimension().getHeight();
    }

    @Override
    public void setHeight(BigDecimal height) {
        this.getDefaultSku().getDimension().setHeight(height);
    }

    @Override
    public BigDecimal getDepth() {
        return this.getDefaultSku().getDimension().getDepth();
    }

    @Override
    public void setDepth(BigDecimal depth) {
        this.getDefaultSku().getDimension().setDepth(depth);
    }

    @Override
    public BigDecimal getGirth() {
        return this.getDefaultSku().getDimension().getGirth();
    }

    @Override
    public void setGirth(BigDecimal girth) {
        this.getDefaultSku().getDimension().setGirth(girth);
    }

    @Override
    public ContainerSizeType getSize() {
        return this.getDefaultSku().getDimension().getSize();
    }

    @Override
    public void setSize(ContainerSizeType size) {
        this.getDefaultSku().getDimension().setSize(size);
    }

    @Override
    public ContainerShapeType getContainer() {
        return this.getDefaultSku().getDimension().getContainer();
    }

    @Override
    public void setContainer(ContainerShapeType container) {
        this.getDefaultSku().getDimension().setContainer(container);
    }

    @Override
    public String getDimensionString() {
        return this.getDefaultSku().getDimension().getDimensionString();
    }

    @Override
    public Weight getWeight() {
        return this.getDefaultSku().getWeight();
    }

    @Override
    public void setWeight(Weight weight) {
        this.getDefaultSku().setWeight(weight);
    }

    @Override
    public List<RelatedProduct> getCrossSaleProducts() {
        BroadleafRequestContext context = BroadleafRequestContext.getBroadleafRequestContext();
        if (context != null && context.getAdditionalProperties().containsKey("blProductEntityExtensionManager")) {
            ProductEntityExtensionManager extensionManager = (ProductEntityExtensionManager)((Object)context.getAdditionalProperties().get("blProductEntityExtensionManager"));
            ExtensionResultHolder holder = new ExtensionResultHolder();
            ExtensionResultStatusType result = ((ProductEntityExtensionHandler)extensionManager.getProxy()).getCrossSaleProducts(this, holder);
            if (ExtensionResultStatusType.HANDLED.equals((Object)result)) {
                return (List)holder.getResult();
            }
        }
        return this.crossSaleProducts;
    }

    @Override
    public void setCrossSaleProducts(List<RelatedProduct> crossSaleProducts) {
        this.crossSaleProducts.clear();
        for (RelatedProduct relatedProduct : crossSaleProducts) {
            this.crossSaleProducts.add(relatedProduct);
        }
    }

    @Override
    public List<RelatedProduct> getUpSaleProducts() {
        BroadleafRequestContext context = BroadleafRequestContext.getBroadleafRequestContext();
        if (context != null && context.getAdditionalProperties().containsKey("blProductEntityExtensionManager")) {
            ProductEntityExtensionManager extensionManager = (ProductEntityExtensionManager)((Object)context.getAdditionalProperties().get("blProductEntityExtensionManager"));
            ExtensionResultHolder holder = new ExtensionResultHolder();
            ExtensionResultStatusType result = ((ProductEntityExtensionHandler)extensionManager.getProxy()).getUpSaleProducts(this, holder);
            if (ExtensionResultStatusType.HANDLED.equals((Object)result)) {
                return (List)holder.getResult();
            }
        }
        return this.upSaleProducts;
    }

    @Override
    public void setUpSaleProducts(List<RelatedProduct> upSaleProducts) {
        this.upSaleProducts.clear();
        for (RelatedProduct relatedProduct : upSaleProducts) {
            this.upSaleProducts.add(relatedProduct);
        }
        this.upSaleProducts = upSaleProducts;
    }

    @Override
    public List<RelatedProduct> getCumulativeCrossSaleProducts() {
        List<RelatedProduct> categoryProducts;
        List<RelatedProduct> returnProducts = this.getCrossSaleProducts();
        if (this.defaultCategory != null && (categoryProducts = this.defaultCategory.getCumulativeCrossSaleProducts()) != null) {
            returnProducts.addAll(categoryProducts);
        }
        Iterator<RelatedProduct> itr = returnProducts.iterator();
        while (itr.hasNext()) {
            RelatedProduct relatedProduct = itr.next();
            if (!relatedProduct.getRelatedProduct().equals(this)) continue;
            itr.remove();
        }
        return returnProducts;
    }

    @Override
    public List<RelatedProduct> getCumulativeUpSaleProducts() {
        List<RelatedProduct> categoryProducts;
        List<RelatedProduct> returnProducts = this.getUpSaleProducts();
        if (this.defaultCategory != null && (categoryProducts = this.defaultCategory.getCumulativeUpSaleProducts()) != null) {
            returnProducts.addAll(categoryProducts);
        }
        Iterator<RelatedProduct> itr = returnProducts.iterator();
        while (itr.hasNext()) {
            RelatedProduct relatedProduct = itr.next();
            if (!relatedProduct.getRelatedProduct().equals(this)) continue;
            itr.remove();
        }
        return returnProducts;
    }

    @Override
    public Map<String, ProductAttribute> getProductAttributes() {
        return this.productAttributes;
    }

    @Override
    public void setProductAttributes(Map<String, ProductAttribute> productAttributes) {
        this.productAttributes = productAttributes;
    }

    @Override
    public List<ProductOptionXref> getProductOptionXrefs() {
        BroadleafRequestContext context = BroadleafRequestContext.getBroadleafRequestContext();
        if (context != null && context.getAdditionalProperties().containsKey("blProductEntityExtensionManager")) {
            ProductEntityExtensionManager extensionManager = (ProductEntityExtensionManager)((Object)context.getAdditionalProperties().get("blProductEntityExtensionManager"));
            ExtensionResultHolder holder = new ExtensionResultHolder();
            ExtensionResultStatusType result = ((ProductEntityExtensionHandler)extensionManager.getProxy()).getProductOptionXrefs(this, holder);
            if (ExtensionResultStatusType.HANDLED.equals((Object)result)) {
                return (List)holder.getResult();
            }
        }
        return this.productOptions;
    }

    @Override
    public void setProductOptionXrefs(List<ProductOptionXref> productOptions) {
        this.productOptions = productOptions;
    }

    @Override
    public List<ProductOption> getProductOptions() {
        BroadleafRequestContext context = BroadleafRequestContext.getBroadleafRequestContext();
        if (context != null && context.getAdditionalProperties().containsKey("blProductEntityExtensionManager")) {
            ProductEntityExtensionManager extensionManager = (ProductEntityExtensionManager)((Object)context.getAdditionalProperties().get("blProductEntityExtensionManager"));
            ExtensionResultHolder holder = new ExtensionResultHolder();
            ExtensionResultStatusType result = ((ProductEntityExtensionHandler)extensionManager.getProxy()).getProductOptions(this, holder);
            if (ExtensionResultStatusType.HANDLED.equals((Object)result)) {
                return (List)holder.getResult();
            }
        }
        ArrayList<ProductOption> response = new ArrayList<ProductOption>();
        for (ProductOptionXref xref : this.productOptions) {
            response.add(xref.getProductOption());
        }
        return Collections.unmodifiableList(response);
    }

    @Override
    public void setProductOptions(List<ProductOption> productOptions) {
        throw new UnsupportedOperationException("Use setProductOptionXrefs(..) instead");
    }

    @Override
    public String getUrl() {
        if (this.url == null) {
            return this.getGeneratedUrl();
        }
        return this.url;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String getDisplayTemplate() {
        return this.displayTemplate;
    }

    @Override
    public void setDisplayTemplate(String displayTemplate) {
        this.displayTemplate = displayTemplate;
    }

    public Character getArchived() {
        if (this.archiveStatus == null) {
            this.archiveStatus = new ArchiveStatus();
        }
        return this.archiveStatus.getArchived();
    }

    public void setArchived(Character archived) {
        if (this.archiveStatus == null) {
            this.archiveStatus = new ArchiveStatus();
        }
        this.archiveStatus.setArchived(archived);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.skus == null ? 0 : this.skus.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProductImpl other = (ProductImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        return !(this.skus == null ? other.skus != null : !this.skus.equals(other.skus));
    }

    @Override
    public String getUrlKey() {
        if (this.urlKey != null) {
            return this.urlKey;
        }
        if (this.getName() != null) {
            String returnKey = this.getName().toLowerCase();
            returnKey = returnKey.replaceAll(" ", "-");
            return returnKey.replaceAll("[^A-Za-z0-9/-]", "");
        }
        return null;
    }

    @Override
    public void setUrlKey(String urlKey) {
        this.urlKey = urlKey;
    }

    @Override
    public String getGeneratedUrl() {
        if (this.getDefaultCategory() != null && this.getDefaultCategory().getGeneratedUrl() != null) {
            String generatedUrl = this.getDefaultCategory().getGeneratedUrl();
            if (generatedUrl.endsWith("//")) {
                return generatedUrl + this.getUrlKey();
            }
            return generatedUrl + "//" + this.getUrlKey();
        }
        return null;
    }

    @Override
    public void clearDynamicPrices() {
        for (Sku sku : this.getAllSkus()) {
            sku.clearDynamicPrices();
        }
    }

    public String getMainEntityName() {
        String manufacturer = this.getManufacturer();
        return StringUtils.isBlank((CharSequence)manufacturer) ? this.getName() : manufacturer + " " + this.getName();
    }

    @Override
    public String getTaxCode() {
        return this.getDefaultSku().getTaxCode();
    }

    @Override
    public void setTaxCode(String taxCode) {
        this.getDefaultSku().setTaxCode(taxCode);
    }

    public String getLocation() {
        return this.getUrl();
    }

    public static class Presentation {

        public static class FieldOrder {
            public static final int NAME = 1000;
            public static final int SHORT_DESCRIPTION = 2000;
            public static final int PRIMARY_MEDIA = 3000;
            public static final int LONG_DESCRIPTION = 4000;
            public static final int DEFAULT_CATEGORY = 5000;
            public static final int MANUFACTURER = 6000;
            public static final int URL = 7000;
        }

        public static class Group {

            public static class Order {
                public static final int General = 1000;
                public static final int Price = 2000;
                public static final int ActiveDateRange = 3000;
                public static final int Advanced = 1000;
                public static final int Inventory = 1000;
                public static final int Badges = 1000;
                public static final int Shipping = 1000;
            }

            public static class Name {
                public static final String General = "ProductImpl_Product_Description";
                public static final String Price = "SkuImpl_Price";
                public static final String ActiveDateRange = "ProductImpl_Product_Active_Date_Range";
                public static final String Advanced = "ProductImpl_Advanced";
                public static final String Inventory = "SkuImpl_Sku_Inventory";
                public static final String Badges = "ProductImpl_Badges";
                public static final String Shipping = "ProductWeight_Shipping";
                public static final String Financial = "ProductImpl_Financial";
            }
        }

        public static class Tab {

            public static class Order {
                public static final int Marketing = 2000;
                public static final int Media = 3000;
                public static final int ProductOptions = 4000;
                public static final int Inventory = 5000;
                public static final int Shipping = 6000;
                public static final int Advanced = 7000;
            }

            public static class Name {
                public static final String Marketing = "ProductImpl_Marketing_Tab";
                public static final String Media = "SkuImpl_Media_Tab";
                public static final String ProductOptions = "ProductImpl_Product_Options_Tab";
                public static final String Inventory = "ProductImpl_Inventory_Tab";
                public static final String Shipping = "ProductImpl_Shipping_Tab";
                public static final String Advanced = "ProductImpl_Advanced_Tab";
            }
        }
    }
}

