/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.payment.service.module;

import javax.annotation.Resource;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrency;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.time.SystemTime;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.payment.domain.PaymentInfoDetail;
import org.broadleafcommerce.core.payment.domain.PaymentInfoDetailImpl;
import org.broadleafcommerce.core.payment.domain.PaymentInfoDetailType;
import org.broadleafcommerce.core.payment.domain.PaymentResponseItem;
import org.broadleafcommerce.core.payment.service.PaymentContext;
import org.broadleafcommerce.core.payment.service.PaymentInfoService;
import org.broadleafcommerce.core.payment.service.exception.PaymentException;
import org.broadleafcommerce.core.payment.service.module.PaymentModule;

public abstract class AbstractModule
implements PaymentModule {
    @Resource(name="blPaymentInfoService")
    private PaymentInfoService paymentInfoService;

    @Override
    public PaymentResponseItem authorize(PaymentContext paymentContext) throws PaymentException {
        Money amountToAuthorize = paymentContext.getRemainingTransactionAmount();
        PaymentResponseItem responseItem = this.getNewResponseItem(amountToAuthorize, this.findPaymentInfoFromContext(paymentContext).getCurrency());
        return this.processAuthorize(paymentContext, amountToAuthorize, responseItem);
    }

    @Override
    public PaymentResponseItem reverseAuthorize(PaymentContext paymentContext) throws PaymentException {
        Money amountAvailableToReverseAuthorize = this.getAmountAvailableToReverseAuthorize(paymentContext);
        PaymentInfo paymentInfo = this.findPaymentInfoFromContext(paymentContext);
        PaymentResponseItem responseItem = this.getNewResponseItem(amountAvailableToReverseAuthorize, paymentInfo.getCurrency());
        paymentInfo.getPaymentInfoDetails().add(this.getNewReverseAuthPaymentInfoDetail(paymentInfo, amountAvailableToReverseAuthorize));
        return this.processReverseAuthorize(paymentContext, amountAvailableToReverseAuthorize, responseItem);
    }

    @Override
    public PaymentResponseItem debit(PaymentContext paymentContext) throws PaymentException {
        Money amountAvailableToDebit = this.getAmountAvailableToDebit(paymentContext);
        PaymentInfo paymentInfo = this.findPaymentInfoFromContext(paymentContext);
        PaymentResponseItem responseItem = this.getNewResponseItem(amountAvailableToDebit, paymentInfo.getCurrency());
        paymentInfo.getPaymentInfoDetails().add(this.getNewCapturePaymentInfoDetail(paymentInfo, amountAvailableToDebit));
        return this.processDebit(paymentContext, amountAvailableToDebit, responseItem);
    }

    @Override
    public PaymentResponseItem authorizeAndDebit(PaymentContext paymentContext) throws PaymentException {
        return this.processAuthorizeAndDebit(paymentContext, this.getAmountAvailableToDebit(paymentContext), this.getNewResponseItem());
    }

    @Override
    public PaymentResponseItem credit(PaymentContext paymentContext) throws PaymentException {
        Money amountAvailableToCredit = this.getAmountAvailableToCredit(paymentContext);
        PaymentInfo paymentInfo = this.findPaymentInfoFromContext(paymentContext);
        PaymentResponseItem responseItem = this.getNewResponseItem(amountAvailableToCredit, paymentInfo.getCurrency());
        paymentInfo.getPaymentInfoDetails().add(this.getNewRefundPaymentInfoDetail(paymentInfo, amountAvailableToCredit));
        return this.processCredit(paymentContext, amountAvailableToCredit, responseItem);
    }

    @Override
    public PaymentResponseItem voidPayment(PaymentContext paymentContext) throws PaymentException {
        PaymentInfo paymentInfo = this.findPaymentInfoFromContext(paymentContext);
        Money amountAlreadyCaptured = paymentInfo.getPaymentCapturedAmount();
        PaymentResponseItem responseItem = this.getNewResponseItem(amountAlreadyCaptured, paymentInfo.getCurrency());
        return this.processVoidPayment(paymentContext, amountAlreadyCaptured, responseItem);
    }

    @Override
    public PaymentResponseItem balance(PaymentContext paymentContext) throws PaymentException {
        return this.processBalance(paymentContext, this.getNewResponseItem());
    }

    @Override
    public PaymentResponseItem partialPayment(PaymentContext paymentContext) throws PaymentException {
        Money amountAvailableToDebit = this.getAmountAvailableToDebit(paymentContext);
        PaymentInfo paymentInfo = this.findPaymentInfoFromContext(paymentContext);
        PaymentResponseItem responseItem = this.getNewResponseItem(amountAvailableToDebit, paymentInfo.getCurrency());
        paymentInfo.getPaymentInfoDetails().add(this.getNewCapturePaymentInfoDetail(paymentInfo, amountAvailableToDebit));
        return this.processPartialPayment(paymentContext, amountAvailableToDebit, responseItem);
    }

    protected PaymentResponseItem getNewResponseItem() {
        return this.getNewResponseItem(null, null);
    }

    protected PaymentResponseItem getNewResponseItem(Money amount, BroadleafCurrency currency) {
        PaymentResponseItem responseItem = this.paymentInfoService.createResponseItem();
        responseItem.setTransactionAmount(amount);
        responseItem.setCurrency(currency);
        return responseItem;
    }

    protected PaymentInfoDetail getNewPaymentInfoDetail(PaymentInfo paymentInfo, PaymentInfoDetailType type, Money amount) {
        PaymentInfoDetailImpl paymentInfoDetail = new PaymentInfoDetailImpl();
        paymentInfoDetail.setPaymentInfo(paymentInfo);
        paymentInfoDetail.setType(type);
        paymentInfoDetail.setDate(SystemTime.asDate());
        paymentInfoDetail.setAmount(amount);
        return paymentInfoDetail;
    }

    protected PaymentInfoDetail getNewCapturePaymentInfoDetail(PaymentInfo paymentInfo, Money amount) {
        return this.getNewPaymentInfoDetail(paymentInfo, PaymentInfoDetailType.CAPTURE, amount);
    }

    protected PaymentInfoDetail getNewRefundPaymentInfoDetail(PaymentInfo paymentInfo, Money amount) {
        return this.getNewPaymentInfoDetail(paymentInfo, PaymentInfoDetailType.REFUND, amount);
    }

    protected PaymentInfoDetail getNewReverseAuthPaymentInfoDetail(PaymentInfo paymentInfo, Money amount) {
        return this.getNewPaymentInfoDetail(paymentInfo, PaymentInfoDetailType.REVERSE_AUTH, amount);
    }

    protected PaymentInfo findPaymentInfoFromContext(PaymentContext paymentContext) {
        PaymentInfo paymentInfo = paymentContext.getPaymentInfo();
        for (PaymentInfo pi : paymentContext.getPaymentInfo().getOrder().getPaymentInfos()) {
            if (!paymentInfo.equals(pi)) continue;
            return pi;
        }
        return null;
    }

    protected Money getAmountAvailableToDebit(PaymentContext paymentContext) {
        Money amountAvailableToDebit;
        Money amountToDebit = paymentContext.getRemainingTransactionAmount();
        PaymentInfo paymentInfo = this.findPaymentInfoFromContext(paymentContext);
        Money amountCaptured = paymentInfo.getPaymentCapturedAmount();
        Money amountAlreadyReversed = paymentInfo.getReverseAuthAmount();
        Money amount = paymentInfo.getAmount();
        Money orderTotal = paymentInfo.getOrder().getTotal();
        Money appliedCreditAdjustment = orderTotal.subtract(amount);
        Money adjustedAmountToDebit = amountToDebit.subtract(appliedCreditAdjustment).abs();
        if (adjustedAmountToDebit.lessThan(amountToDebit) && paymentInfo.getOrder().getCapturedTotal().equals((Object)appliedCreditAdjustment)) {
            amountToDebit = adjustedAmountToDebit;
        }
        if ((amountAvailableToDebit = amount.subtract(amountCaptured).subtract(amountAlreadyReversed)).lessThan(amountToDebit)) {
            return amountAvailableToDebit;
        }
        return amountToDebit;
    }

    protected Money getAmountAvailableToCredit(PaymentContext paymentContext) {
        Money amountAlreadyCredited;
        Money amountToCredit = paymentContext.getRemainingTransactionAmount();
        PaymentInfo paymentInfo = this.findPaymentInfoFromContext(paymentContext);
        Money amountCaptured = paymentInfo.getPaymentCapturedAmount();
        Money amountAvailableToCredit = amountCaptured.subtract(amountAlreadyCredited = paymentInfo.getPaymentCreditedAmount());
        if (amountAvailableToCredit.lessThan(amountToCredit)) {
            return amountAvailableToCredit;
        }
        return amountToCredit;
    }

    protected Money getAmountAvailableToReverseAuthorize(PaymentContext paymentContext) {
        Money amountToReverse = paymentContext.getRemainingTransactionAmount();
        PaymentInfo paymentInfo = this.findPaymentInfoFromContext(paymentContext);
        Money amountCaptured = paymentInfo.getPaymentCapturedAmount();
        Money amountAlreadyReversed = paymentInfo.getReverseAuthAmount();
        Money amount = paymentInfo.getAmount();
        Money amountAvailableToReverse = amount.subtract(amountCaptured).subtract(amountAlreadyReversed);
        if (amountAvailableToReverse.lessThan(amountToReverse)) {
            return amountAvailableToReverse;
        }
        return amountToReverse;
    }
}

