/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.payment.domain;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.broadleafcommerce.common.BroadleafEnumerationType;

public class PaymentInfoDetailType
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, PaymentInfoDetailType> TYPES = new LinkedHashMap<String, PaymentInfoDetailType>();
    public static final PaymentInfoDetailType CAPTURE = new PaymentInfoDetailType("CAPTURE", "Capture");
    public static final PaymentInfoDetailType REFUND = new PaymentInfoDetailType("REFUND", "Refund");
    public static final PaymentInfoDetailType REVERSE_AUTH = new PaymentInfoDetailType("REVERSE_AUTH", "Reverse Auth");
    private String type;
    private String friendlyType;

    public static PaymentInfoDetailType getInstance(String type) {
        return TYPES.get(type);
    }

    public PaymentInfoDetailType() {
    }

    public PaymentInfoDetailType(String type, String friendlyType) {
        this.friendlyType = friendlyType;
        this.setType(type);
    }

    public String getType() {
        return this.type;
    }

    public String getFriendlyType() {
        return this.friendlyType;
    }

    private void setType(String type) {
        this.type = type;
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PaymentInfoDetailType other = (PaymentInfoDetailType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

