/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.service.legacy;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.core.catalog.dao.CategoryDao;
import org.broadleafcommerce.core.catalog.dao.ProductDao;
import org.broadleafcommerce.core.catalog.dao.SkuDao;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductBundle;
import org.broadleafcommerce.core.catalog.domain.ProductOption;
import org.broadleafcommerce.core.catalog.domain.ProductOptionValue;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.domain.SkuBundleItem;
import org.broadleafcommerce.core.order.dao.FulfillmentGroupDao;
import org.broadleafcommerce.core.order.dao.FulfillmentGroupItemDao;
import org.broadleafcommerce.core.order.dao.OrderDao;
import org.broadleafcommerce.core.order.dao.OrderItemDao;
import org.broadleafcommerce.core.order.domain.BundleOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.OrderItemAttribute;
import org.broadleafcommerce.core.order.domain.OrderItemAttributeImpl;
import org.broadleafcommerce.core.order.domain.PersonalMessage;
import org.broadleafcommerce.core.order.service.FulfillmentGroupService;
import org.broadleafcommerce.core.order.service.OrderItemService;
import org.broadleafcommerce.core.order.service.OrderServiceImpl;
import org.broadleafcommerce.core.order.service.call.BundleOrderItemRequest;
import org.broadleafcommerce.core.order.service.call.DiscreteOrderItemRequest;
import org.broadleafcommerce.core.order.service.call.FulfillmentGroupItemRequest;
import org.broadleafcommerce.core.order.service.call.FulfillmentGroupRequest;
import org.broadleafcommerce.core.order.service.call.GiftWrapOrderItemRequest;
import org.broadleafcommerce.core.order.service.call.OrderItemRequestDTO;
import org.broadleafcommerce.core.order.service.exception.ItemNotFoundException;
import org.broadleafcommerce.core.order.service.exception.RequiredAttributeNotProvidedException;
import org.broadleafcommerce.core.order.service.legacy.LegacyOrderService;
import org.broadleafcommerce.core.order.service.type.OrderItemType;
import org.broadleafcommerce.core.payment.dao.PaymentInfoDao;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.Customer;

@Deprecated
public class LegacyOrderServiceImpl
extends OrderServiceImpl
implements LegacyOrderService {
    private static final Log LOG = LogFactory.getLog(LegacyOrderServiceImpl.class);
    @Resource(name="blFulfillmentGroupDao")
    protected FulfillmentGroupDao fulfillmentGroupDao;
    @Resource(name="blFulfillmentGroupItemDao")
    protected FulfillmentGroupItemDao fulfillmentGroupItemDao;
    @Resource(name="blOrderItemService")
    protected OrderItemService orderItemService;
    @Resource(name="blOrderItemDao")
    protected OrderItemDao orderItemDao;
    @Resource(name="blSkuDao")
    protected SkuDao skuDao;
    @Resource(name="blProductDao")
    protected ProductDao productDao;
    @Resource(name="blCategoryDao")
    protected CategoryDao categoryDao;
    @Resource(name="blFulfillmentGroupService")
    protected FulfillmentGroupService fulfillmentGroupService;

    @Override
    public FulfillmentGroup findDefaultFulfillmentGroupForOrder(Order order) {
        return this.fulfillmentGroupDao.readDefaultFulfillmentGroupForOrder(order);
    }

    public DiscreteOrderItemRequest createDiscreteOrderItemRequest(Order order, BundleOrderItem bundleOrderItem, Sku sku, Product product, Category category, Integer quantity, Map<String, String> itemAttributes) {
        DiscreteOrderItemRequest itemRequest = new DiscreteOrderItemRequest();
        itemRequest.setOrder(order);
        itemRequest.setBundleOrderItem(bundleOrderItem);
        itemRequest.setCategory(category);
        itemRequest.setProduct(product);
        itemRequest.setQuantity(quantity);
        itemRequest.setSku(sku);
        itemRequest.setItemAttributes(itemAttributes);
        return itemRequest;
    }

    @Override
    public DiscreteOrderItemRequest createDiscreteOrderItemRequest(Long orderId, Long skuId, Long productId, Long categoryId, Integer quantity) {
        Sku sku = this.skuDao.readSkuById(skuId);
        Product product = productId != null ? this.productDao.readProductById(productId) : null;
        Category category = categoryId != null ? this.categoryDao.readCategoryById(categoryId) : null;
        Order order = this.orderDao.readOrderById(orderId);
        return this.createDiscreteOrderItemRequest(order, null, sku, product, category, quantity, null);
    }

    @Override
    public OrderItem addGiftWrapItemToOrder(Order order, GiftWrapOrderItemRequest itemRequest) throws PricingException {
        itemRequest.setOrder(order);
        return this.addGiftWrapItemToOrder(order, itemRequest, true);
    }

    @Override
    public OrderItem addBundleItemToOrder(Order order, BundleOrderItemRequest itemRequest) throws PricingException {
        return this.addBundleItemToOrder(order, itemRequest, true);
    }

    @Override
    public OrderItem addBundleItemToOrder(Order order, BundleOrderItemRequest itemRequest, boolean priceOrder) throws PricingException {
        itemRequest.setOrder(order);
        BundleOrderItem item = this.orderItemService.createBundleOrderItem(itemRequest);
        return this.addOrderItemToOrder(order, item, priceOrder);
    }

    @Override
    public Order removeItemFromOrder(Long orderId, Long itemId) throws PricingException {
        return this.removeItemFromOrder(orderId, itemId, true);
    }

    @Override
    public Order removeItemFromOrder(Long orderId, Long itemId, boolean priceOrder) throws PricingException {
        Order order = this.findOrderById(orderId);
        OrderItem orderItem = this.orderItemService.readOrderItemById(itemId);
        return this.removeItemFromOrder(order, orderItem, priceOrder);
    }

    @Override
    public Order removeItemFromOrder(Order order, OrderItem item) throws PricingException {
        return this.removeItemFromOrder(order, item, true);
    }

    @Override
    public Order removeItemFromOrder(Order order, OrderItem item, boolean priceOrder) throws PricingException {
        this.fulfillmentGroupService.removeOrderItemFromFullfillmentGroups(order, item);
        OrderItem itemFromOrder = order.getOrderItems().remove(order.getOrderItems().indexOf(item));
        itemFromOrder.setOrder(null);
        this.orderItemService.delete(itemFromOrder);
        order = this.updateOrder(order, priceOrder);
        return order;
    }

    public Order moveItemToOrder(Order originalOrder, Order destinationOrder, OrderItem item) throws PricingException {
        return this.moveItemToOrder(originalOrder, destinationOrder, item, true);
    }

    public Order moveItemToOrder(Order originalOrder, Order destinationOrder, OrderItem item, boolean priceOrder) throws PricingException {
        this.fulfillmentGroupService.removeOrderItemFromFullfillmentGroups(originalOrder, item);
        OrderItem itemFromOrder = originalOrder.getOrderItems().remove(originalOrder.getOrderItems().indexOf(item));
        itemFromOrder.setOrder(null);
        originalOrder = this.updateOrder(originalOrder, priceOrder);
        this.addOrderItemToOrder(destinationOrder, item, priceOrder);
        return destinationOrder;
    }

    @Override
    public PaymentInfo addPaymentToOrder(Order order, PaymentInfo payment) {
        return this.addPaymentToOrder(order, payment, null);
    }

    @Override
    public FulfillmentGroup addFulfillmentGroupToOrder(FulfillmentGroupRequest fulfillmentGroupRequest) throws PricingException {
        return this.addFulfillmentGroupToOrder(fulfillmentGroupRequest, true);
    }

    @Override
    public FulfillmentGroup addFulfillmentGroupToOrder(FulfillmentGroupRequest fulfillmentGroupRequest, boolean priceOrder) throws PricingException {
        FulfillmentGroup fg = this.fulfillmentGroupDao.create();
        fg.setAddress(fulfillmentGroupRequest.getAddress());
        fg.setOrder(fulfillmentGroupRequest.getOrder());
        fg.setPhone(fulfillmentGroupRequest.getPhone());
        fg.setMethod(fulfillmentGroupRequest.getMethod());
        fg.setService(fulfillmentGroupRequest.getService());
        for (int i = 0; i < fulfillmentGroupRequest.getFulfillmentGroupItemRequests().size(); ++i) {
            FulfillmentGroupItemRequest request = fulfillmentGroupRequest.getFulfillmentGroupItemRequests().get(i);
            boolean shouldPriceOrder = priceOrder && i == fulfillmentGroupRequest.getFulfillmentGroupItemRequests().size() - 1;
            fg = this.addItemToFulfillmentGroup(request.getOrderItem(), fg, request.getQuantity(), shouldPriceOrder);
        }
        return fg;
    }

    @Override
    public FulfillmentGroup addFulfillmentGroupToOrder(Order order, FulfillmentGroup fulfillmentGroup) throws PricingException {
        return this.addFulfillmentGroupToOrder(order, fulfillmentGroup, true);
    }

    @Override
    public FulfillmentGroup addFulfillmentGroupToOrder(Order order, FulfillmentGroup fulfillmentGroup, boolean priceOrder) throws PricingException {
        FulfillmentGroup dfg = this.findDefaultFulfillmentGroupForOrder(order);
        if (dfg == null) {
            fulfillmentGroup.setPrimary(true);
        } else if (dfg.equals(fulfillmentGroup)) {
            fulfillmentGroup.setPrimary(true);
            order.getFulfillmentGroups().remove(dfg);
        }
        fulfillmentGroup.setOrder(order);
        for (FulfillmentGroupItem fgItem : fulfillmentGroup.getFulfillmentGroupItems()) {
            for (FulfillmentGroup fg : order.getFulfillmentGroups()) {
                if (fg.equals(fulfillmentGroup)) continue;
                fg.getFulfillmentGroupItems().remove(fgItem);
            }
        }
        fulfillmentGroup = this.fulfillmentGroupDao.save(fulfillmentGroup);
        order.getFulfillmentGroups().add(fulfillmentGroup);
        int fulfillmentGroupIndex = order.getFulfillmentGroups().size() - 1;
        order = this.updateOrder(order, priceOrder);
        return order.getFulfillmentGroups().get(fulfillmentGroupIndex);
    }

    @Override
    public FulfillmentGroup addItemToFulfillmentGroup(OrderItem item, FulfillmentGroup fulfillmentGroup, int quantity) throws PricingException {
        return this.addItemToFulfillmentGroup(item, fulfillmentGroup, quantity, true);
    }

    @Override
    public FulfillmentGroup addItemToFulfillmentGroup(OrderItem item, FulfillmentGroup fulfillmentGroup, int quantity, boolean priceOrder) throws PricingException {
        return this.addItemToFulfillmentGroup(item.getOrder(), item, fulfillmentGroup, quantity, priceOrder);
    }

    @Override
    public FulfillmentGroup addItemToFulfillmentGroup(Order order, OrderItem item, FulfillmentGroup fulfillmentGroup, int quantity, boolean priceOrder) throws PricingException {
        for (FulfillmentGroup fg : order.getFulfillmentGroups()) {
            Iterator<FulfillmentGroupItem> itr = fg.getFulfillmentGroupItems().iterator();
            while (itr.hasNext()) {
                FulfillmentGroupItem fgItem = itr.next();
                if (!fgItem.getOrderItem().equals(item)) continue;
                itr.remove();
                this.fulfillmentGroupItemDao.delete(fgItem);
            }
        }
        if (fulfillmentGroup.getId() == null) {
            fulfillmentGroup = this.addFulfillmentGroupToOrder(order, fulfillmentGroup, priceOrder);
        }
        FulfillmentGroupItem fgi = this.createFulfillmentGroupItemFromOrderItem(item, fulfillmentGroup, quantity);
        fgi = this.fulfillmentGroupItemDao.save(fgi);
        fulfillmentGroup.addFulfillmentGroupItem(fgi);
        order = this.updateOrder(order, priceOrder);
        return fulfillmentGroup;
    }

    @Override
    public FulfillmentGroup addItemToFulfillmentGroup(OrderItem item, FulfillmentGroup fulfillmentGroup) throws PricingException {
        return this.addItemToFulfillmentGroup(item, fulfillmentGroup, true);
    }

    @Override
    public FulfillmentGroup addItemToFulfillmentGroup(OrderItem item, FulfillmentGroup fulfillmentGroup, boolean priceOrder) throws PricingException {
        return this.addItemToFulfillmentGroup(item, fulfillmentGroup, item.getQuantity(), priceOrder);
    }

    @Override
    public void updateItemQuantity(Order order, OrderItem item) throws ItemNotFoundException, PricingException {
        this.updateItemQuantity(order, item, true);
    }

    @Override
    public void updateItemQuantity(Order order, OrderItemRequestDTO orderItemRequestDTO) throws ItemNotFoundException, PricingException {
        OrderItem orderItem = null;
        for (DiscreteOrderItem doi : order.getDiscreteOrderItems()) {
            if (!doi.getId().equals(orderItemRequestDTO.getOrderItemId())) continue;
            orderItem = doi;
        }
        orderItem.setQuantity(orderItemRequestDTO.getQuantity());
        this.updateItemQuantity(order, orderItem, true);
    }

    @Override
    public void updateItemQuantity(Order order, OrderItem item, boolean priceOrder) throws ItemNotFoundException, PricingException {
        if (!order.getOrderItems().contains(item)) {
            throw new ItemNotFoundException("Order Item (" + item.getId() + ") not found in Order (" + order.getId() + ")");
        }
        if (item.getQuantity() == 0) {
            this.removeItemFromOrder(order, item);
        } else {
            if (item.getQuantity() < 0) {
                throw new IllegalArgumentException("Quantity cannot be negative");
            }
            OrderItem itemFromOrder = order.getOrderItems().get(order.getOrderItems().indexOf(item));
            itemFromOrder.setQuantity(item.getQuantity());
            order = this.updateOrder(order, priceOrder);
        }
    }

    @Override
    public void removeAllFulfillmentGroupsFromOrder(Order order) throws PricingException {
        this.removeAllFulfillmentGroupsFromOrder(order, false);
    }

    @Override
    public void removeAllFulfillmentGroupsFromOrder(Order order, boolean priceOrder) throws PricingException {
        if (order.getFulfillmentGroups() != null) {
            Iterator<FulfillmentGroup> iterator = order.getFulfillmentGroups().iterator();
            while (iterator.hasNext()) {
                FulfillmentGroup fulfillmentGroup = iterator.next();
                iterator.remove();
                this.fulfillmentGroupDao.delete(fulfillmentGroup);
            }
            this.updateOrder(order, priceOrder);
        }
    }

    @Override
    public void removeFulfillmentGroupFromOrder(Order order, FulfillmentGroup fulfillmentGroup) throws PricingException {
        this.removeFulfillmentGroupFromOrder(order, fulfillmentGroup, true);
    }

    @Override
    public void removeFulfillmentGroupFromOrder(Order order, FulfillmentGroup fulfillmentGroup, boolean priceOrder) throws PricingException {
        order.getFulfillmentGroups().remove(fulfillmentGroup);
        this.fulfillmentGroupDao.delete(fulfillmentGroup);
        this.updateOrder(order, priceOrder);
    }

    @Override
    public void removeNamedOrderForCustomer(String name, Customer customer) {
        Order namedOrder = this.findNamedOrderForCustomer(name, customer);
        this.cancelOrder(namedOrder);
    }

    @Override
    public List<PaymentInfo> readPaymentInfosForOrder(Order order) {
        return this.paymentInfoDao.readPaymentInfosForOrder(order);
    }

    protected boolean itemMatches(DiscreteOrderItem item1, DiscreteOrderItem item2) {
        return item1.getSku() != null && item2.getSku() != null ? item1.getSku().getId().equals(item2.getSku().getId()) : item1.getProduct() != null && item2.getProduct() != null && item1.getProduct().getId().equals(item2.getProduct().getId());
    }

    protected OrderItem findMatchingDiscreteItem(Order order, DiscreteOrderItem itemToFind) {
        for (int i = order.getOrderItems().size() - 1; i >= 0; --i) {
            OrderItem currentItem = order.getOrderItems().get(i);
            if (currentItem instanceof DiscreteOrderItem) {
                DiscreteOrderItem discreteItem = (DiscreteOrderItem)currentItem;
                if (!this.itemMatches(discreteItem, itemToFind)) continue;
                return discreteItem;
            }
            if (!(currentItem instanceof BundleOrderItem)) continue;
            for (DiscreteOrderItem discreteItem : ((BundleOrderItem)currentItem).getDiscreteOrderItems()) {
                if (!this.itemMatches(discreteItem, itemToFind)) continue;
                return discreteItem;
            }
        }
        return null;
    }

    protected boolean bundleItemMatches(BundleOrderItem item1, BundleOrderItem item2) {
        Integer qty;
        if (item1.getSku() != null && item2.getSku() != null) {
            return item1.getSku().getId().equals(item2.getSku().getId());
        }
        HashMap<Long, Integer> skuMap = new HashMap<Long, Integer>();
        for (DiscreteOrderItem item : item1.getDiscreteOrderItems()) {
            if (skuMap.get(item.getSku().getId()) == null) {
                skuMap.put(item.getSku().getId(), item.getQuantity());
                continue;
            }
            qty = (Integer)skuMap.get(item.getSku().getId());
            skuMap.put(item.getSku().getId(), qty + item.getQuantity());
        }
        for (DiscreteOrderItem item : item2.getDiscreteOrderItems()) {
            if (skuMap.containsKey(item.getSku().getId())) {
                qty = (Integer)skuMap.get(item.getSku().getId());
                Integer newQty = qty - item.getQuantity();
                if (newQty == 0) {
                    skuMap.remove(item.getSku().getId());
                    continue;
                }
                if (newQty > 0) {
                    skuMap.put(item.getSku().getId(), newQty);
                    continue;
                }
                return false;
            }
            return false;
        }
        return skuMap.isEmpty();
    }

    protected OrderItem findMatchingBundleItem(Order order, BundleOrderItem itemToFind) {
        for (int i = order.getOrderItems().size() - 1; i >= 0; --i) {
            OrderItem currentItem = order.getOrderItems().get(i);
            if (!(currentItem instanceof BundleOrderItem) || !this.bundleItemMatches((BundleOrderItem)currentItem, itemToFind)) continue;
            return currentItem;
        }
        return null;
    }

    protected OrderItem findMatchingItem(Order order, OrderItem itemToFind) {
        if (itemToFind instanceof BundleOrderItem) {
            return this.findMatchingBundleItem(order, (BundleOrderItem)itemToFind);
        }
        if (itemToFind instanceof DiscreteOrderItem) {
            return this.findMatchingDiscreteItem(order, (DiscreteOrderItem)itemToFind);
        }
        return null;
    }

    @Override
    public OrderItem addOrderItemToBundle(Order order, BundleOrderItem bundle, DiscreteOrderItem newOrderItem, boolean priceOrder) throws PricingException {
        List<DiscreteOrderItem> orderItems = bundle.getDiscreteOrderItems();
        orderItems.add(newOrderItem);
        newOrderItem.setBundleOrderItem(bundle);
        order = this.updateOrder(order, priceOrder);
        return this.findMatchingItem(order, bundle);
    }

    @Override
    public Order removeItemFromBundle(Order order, BundleOrderItem bundle, OrderItem item, boolean priceOrder) throws PricingException {
        DiscreteOrderItem itemFromBundle = bundle.getDiscreteOrderItems().remove(bundle.getDiscreteOrderItems().indexOf(item));
        this.orderItemService.delete(itemFromBundle);
        itemFromBundle.setBundleOrderItem(null);
        order = this.updateOrder(order, priceOrder);
        return order;
    }

    @Override
    public Order addOrUpdateOrderItemAttributes(Order order, OrderItem item, Map<String, String> attributeValues, boolean priceOrder) throws ItemNotFoundException, PricingException {
        if (!order.getOrderItems().contains(item)) {
            throw new ItemNotFoundException("Order Item (" + item.getId() + ") not found in Order (" + order.getId() + ")");
        }
        OrderItem itemFromOrder = order.getOrderItems().get(order.getOrderItems().indexOf(item));
        Map<String, OrderItemAttribute> orderItemAttributes = itemFromOrder.getOrderItemAttributes();
        if (orderItemAttributes == null) {
            orderItemAttributes = new HashMap<String, OrderItemAttribute>();
            itemFromOrder.setOrderItemAttributes(orderItemAttributes);
        }
        boolean changeMade = false;
        for (String attributeName : attributeValues.keySet()) {
            String attributeValue = attributeValues.get(attributeName);
            OrderItemAttribute attribute = orderItemAttributes.get(attributeName);
            if (attribute != null && ((String)((Object)attribute.getValue())).equals(attributeValue)) continue;
            changeMade = true;
            if (attribute == null) {
                attribute = new OrderItemAttributeImpl();
                attribute.setOrderItem(itemFromOrder);
                attribute.setName(attributeName);
                attribute.setValue((Serializable)((Object)attributeValue));
                continue;
            }
            if (attributeValue == null) {
                orderItemAttributes.remove(attributeValue);
                continue;
            }
            attribute.setValue((Serializable)((Object)attributeValue));
        }
        if (changeMade) {
            return this.updateOrder(order, priceOrder);
        }
        return order;
    }

    @Override
    public Order removeOrderItemAttribute(Order order, OrderItem item, String attributeName, boolean priceOrder) throws ItemNotFoundException, PricingException {
        if (!order.getOrderItems().contains(item)) {
            throw new ItemNotFoundException("Order Item (" + item.getId() + ") not found in Order (" + order.getId() + ")");
        }
        OrderItem itemFromOrder = order.getOrderItems().get(order.getOrderItems().indexOf(item));
        boolean changeMade = false;
        Map<String, OrderItemAttribute> orderItemAttributes = itemFromOrder.getOrderItemAttributes();
        if (orderItemAttributes != null && orderItemAttributes.containsKey(attributeName)) {
            changeMade = true;
            orderItemAttributes.remove(attributeName);
        }
        if (changeMade) {
            return this.updateOrder(order, priceOrder);
        }
        return order;
    }

    @Override
    public FulfillmentGroup createDefaultFulfillmentGroup(Order order, Address address) {
        for (FulfillmentGroup fulfillmentGroup : order.getFulfillmentGroups()) {
            if (!fulfillmentGroup.isPrimary()) continue;
            return fulfillmentGroup;
        }
        FulfillmentGroup newFg = this.fulfillmentGroupService.createEmptyFulfillmentGroup();
        newFg.setOrder(order);
        newFg.setPrimary(true);
        newFg.setAddress(address);
        for (OrderItem orderItem : order.getOrderItems()) {
            newFg.addFulfillmentGroupItem(this.createFulfillmentGroupItemFromOrderItem(orderItem, newFg, orderItem.getQuantity()));
        }
        return newFg;
    }

    public OrderDao getOrderDao() {
        return this.orderDao;
    }

    public void setOrderDao(OrderDao orderDao) {
        this.orderDao = orderDao;
    }

    public PaymentInfoDao getPaymentInfoDao() {
        return this.paymentInfoDao;
    }

    public void setPaymentInfoDao(PaymentInfoDao paymentInfoDao) {
        this.paymentInfoDao = paymentInfoDao;
    }

    public FulfillmentGroupDao getFulfillmentGroupDao() {
        return this.fulfillmentGroupDao;
    }

    public void setFulfillmentGroupDao(FulfillmentGroupDao fulfillmentGroupDao) {
        this.fulfillmentGroupDao = fulfillmentGroupDao;
    }

    public FulfillmentGroupItemDao getFulfillmentGroupItemDao() {
        return this.fulfillmentGroupItemDao;
    }

    public void setFulfillmentGroupItemDao(FulfillmentGroupItemDao fulfillmentGroupItemDao) {
        this.fulfillmentGroupItemDao = fulfillmentGroupItemDao;
    }

    public OrderItemService getOrderItemService() {
        return this.orderItemService;
    }

    public void setOrderItemService(OrderItemService orderItemService) {
        this.orderItemService = orderItemService;
    }

    @Override
    public Order findOrderByOrderNumber(String orderNumber) {
        return this.orderDao.readOrderByOrderNumber(orderNumber);
    }

    protected Order updateOrder(Order order, Boolean priceOrder) throws PricingException {
        if (priceOrder.booleanValue()) {
            order = this.pricingService.executePricing(order);
        }
        return this.persistOrder(order);
    }

    protected Order persistOrder(Order order) {
        return this.orderDao.save(order);
    }

    protected FulfillmentGroupItem createFulfillmentGroupItemFromOrderItem(OrderItem orderItem, FulfillmentGroup fulfillmentGroup, int quantity) {
        FulfillmentGroupItem fgi = this.fulfillmentGroupItemDao.create();
        fgi.setFulfillmentGroup(fulfillmentGroup);
        fgi.setOrderItem(orderItem);
        fgi.setQuantity(quantity);
        return fgi;
    }

    protected void removeOrderItemFromFullfillmentGroup(Order order, OrderItem orderItem) {
        List<FulfillmentGroup> fulfillmentGroups = order.getFulfillmentGroups();
        for (FulfillmentGroup fulfillmentGroup : fulfillmentGroups) {
            Iterator<FulfillmentGroupItem> itr = fulfillmentGroup.getFulfillmentGroupItems().iterator();
            block1: while (itr.hasNext()) {
                FulfillmentGroupItem fulfillmentGroupItem = itr.next();
                if (fulfillmentGroupItem.getOrderItem().equals(orderItem)) {
                    itr.remove();
                    this.fulfillmentGroupItemDao.delete(fulfillmentGroupItem);
                    continue;
                }
                if (!(orderItem instanceof BundleOrderItem)) continue;
                BundleOrderItem bundleOrderItem = (BundleOrderItem)orderItem;
                for (DiscreteOrderItem discreteOrderItem : bundleOrderItem.getDiscreteOrderItems()) {
                    if (!fulfillmentGroupItem.getOrderItem().equals(discreteOrderItem)) continue;
                    itr.remove();
                    this.fulfillmentGroupItemDao.delete(fulfillmentGroupItem);
                    continue block1;
                }
            }
        }
    }

    protected DiscreteOrderItemRequest createDiscreteOrderItemRequest(DiscreteOrderItem discreteOrderItem) {
        DiscreteOrderItemRequest itemRequest = new DiscreteOrderItemRequest();
        itemRequest.setCategory(discreteOrderItem.getCategory());
        itemRequest.setProduct(discreteOrderItem.getProduct());
        itemRequest.setQuantity(discreteOrderItem.getQuantity());
        itemRequest.setSku(discreteOrderItem.getSku());
        if (discreteOrderItem.getPersonalMessage() != null) {
            PersonalMessage personalMessage = this.orderItemService.createPersonalMessage();
            try {
                BeanUtils.copyProperties((Object)personalMessage, (Object)discreteOrderItem.getPersonalMessage());
                personalMessage.setId(null);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            itemRequest.setPersonalMessage(personalMessage);
        }
        return itemRequest;
    }

    protected BundleOrderItemRequest createBundleOrderItemRequest(BundleOrderItem bundleOrderItem, List<DiscreteOrderItemRequest> discreteOrderItemRequests) {
        BundleOrderItemRequest bundleOrderItemRequest = new BundleOrderItemRequest();
        bundleOrderItemRequest.setCategory(bundleOrderItem.getCategory());
        bundleOrderItemRequest.setName(bundleOrderItem.getName());
        bundleOrderItemRequest.setQuantity(bundleOrderItem.getQuantity());
        bundleOrderItemRequest.setDiscreteOrderItems(discreteOrderItemRequests);
        return bundleOrderItemRequest;
    }

    protected Order validateOrder(Long orderId) {
        if (orderId == null) {
            throw new IllegalArgumentException("orderId required when adding item to order.");
        }
        Order order = this.findOrderById(orderId);
        if (order == null) {
            throw new IllegalArgumentException("No order found matching passed in orderId " + orderId + " while trying to addItemToOrder.");
        }
        return order;
    }

    protected Product validateProduct(Long productId) {
        if (productId != null) {
            Product product = this.productDao.readProductById(productId);
            if (product == null) {
                throw new IllegalArgumentException("No product found matching passed in productId " + productId + " while trying to addItemToOrder.");
            }
            return product;
        }
        return null;
    }

    protected Category determineCategory(Product product, Long categoryId) {
        Category category = null;
        if (categoryId != null) {
            category = this.categoryDao.readCategoryById(categoryId);
        }
        if (category == null && product != null) {
            category = product.getDefaultCategory();
        }
        return category;
    }

    protected Sku determineSku(Product product, Long skuId, Map<String, String> attributeValues) {
        Sku sku = this.findMatchingSku(product, attributeValues);
        if (sku == null && skuId != null) {
            sku = this.skuDao.readSkuById(skuId);
        }
        if (sku == null && product != null) {
            if (product.getAdditionalSkus() != null && product.getAdditionalSkus().size() > 0) {
                throw new RequiredAttributeNotProvidedException("Unable to find non-default sku matching given options");
            }
            sku = product.getDefaultSku();
        }
        return sku;
    }

    protected Sku findMatchingSku(Product product, Map<String, String> attributeValues) {
        HashMap<String, String> attributeValuesForSku = new HashMap<String, String>();
        if (product != null && product.getProductOptions() != null && product.getProductOptions().size() > 0) {
            for (ProductOption productOption : product.getProductOptions()) {
                if (!productOption.getRequired().booleanValue()) continue;
                if (attributeValues.get(productOption.getAttributeName()) == null) {
                    throw new RequiredAttributeNotProvidedException("Unable to add to cart. Required attribute was not provided: " + productOption.getAttributeName());
                }
                attributeValuesForSku.put(productOption.getAttributeName(), attributeValues.get(productOption.getAttributeName()));
            }
            if (product != null && product.getSkus() != null) {
                for (Sku sku : product.getSkus()) {
                    if (!this.checkSkuForMatch(sku, attributeValuesForSku)) continue;
                    return sku;
                }
            }
        }
        return null;
    }

    protected boolean checkSkuForMatch(Sku sku, Map<String, String> attributeValues) {
        if (attributeValues == null || attributeValues.size() == 0) {
            return false;
        }
        for (String attributeName : attributeValues.keySet()) {
            boolean optionValueMatchFound = false;
            for (ProductOptionValue productOptionValue : sku.getProductOptionValues()) {
                if (!productOptionValue.getProductOption().getAttributeName().equals(attributeName)) continue;
                if (productOptionValue.getAttributeValue().equals(attributeValues.get(attributeName))) {
                    optionValueMatchFound = true;
                    break;
                }
                return false;
            }
            if (optionValueMatchFound) continue;
            return false;
        }
        return true;
    }

    @Override
    public Order addItemToOrder(Long orderId, OrderItemRequestDTO orderItemRequestDTO, boolean priceOrder) throws PricingException {
        if (orderItemRequestDTO.getQuantity() == null || orderItemRequestDTO.getQuantity() == 0) {
            LOG.debug((Object)"Not adding item to order because quantity is zero.");
            return null;
        }
        if (orderItemRequestDTO.getQuantity() < 0) {
            throw new IllegalArgumentException("Quantity cannot be negative");
        }
        Order order = this.validateOrder(orderId);
        Product product = this.validateProduct(orderItemRequestDTO.getProductId());
        Sku sku = this.determineSku(product, orderItemRequestDTO.getSkuId(), orderItemRequestDTO.getItemAttributes());
        if (sku == null) {
            return null;
        }
        Category category = this.determineCategory(product, orderItemRequestDTO.getCategoryId());
        if (product == null || !(product instanceof ProductBundle)) {
            DiscreteOrderItem item = this.orderItemService.createDiscreteOrderItem(this.createDiscreteOrderItemRequest(order, null, sku, product, category, orderItemRequestDTO.getQuantity(), orderItemRequestDTO.getItemAttributes()));
            item.setOrder(order);
            List<OrderItem> orderItems = order.getOrderItems();
            orderItems.add(item);
            return this.updateOrder(order, priceOrder);
        }
        ProductBundle bundle = (ProductBundle)product;
        BundleOrderItem bundleOrderItem = (BundleOrderItem)this.orderItemDao.create(OrderItemType.BUNDLE);
        bundleOrderItem.setQuantity(orderItemRequestDTO.getQuantity());
        bundleOrderItem.setCategory(category);
        bundleOrderItem.setSku(sku);
        bundleOrderItem.setName(product.getName());
        bundleOrderItem.setProductBundle(bundle);
        bundleOrderItem.setOrder(order);
        for (SkuBundleItem skuBundleItem : bundle.getSkuBundleItems()) {
            ProductBundle bundleProduct = skuBundleItem.getBundle();
            Sku bundleSku = skuBundleItem.getSku();
            Category bundleCategory = this.determineCategory(bundleProduct, orderItemRequestDTO.getCategoryId());
            DiscreteOrderItem bundleDiscreteItem = this.orderItemService.createDiscreteOrderItem(this.createDiscreteOrderItemRequest(null, bundleOrderItem, bundleSku, bundleProduct, bundleCategory, skuBundleItem.getQuantity(), orderItemRequestDTO.getItemAttributes()));
            bundleDiscreteItem.setBundleOrderItem(bundleOrderItem);
            bundleDiscreteItem.setSkuBundleItem(skuBundleItem);
            bundleOrderItem.getDiscreteOrderItems().add(bundleDiscreteItem);
        }
        List<OrderItem> orderItems = order.getOrderItems();
        orderItems.add(bundleOrderItem);
        return this.updateOrder(order, priceOrder);
    }

    @Override
    @Deprecated
    public OrderItem addDiscreteItemToOrder(Order order, DiscreteOrderItemRequest itemRequest) throws PricingException {
        return this.addDiscreteItemToOrder(order, itemRequest, true);
    }

    @Override
    @Deprecated
    public OrderItem addDiscreteItemToOrder(Order order, DiscreteOrderItemRequest itemRequest, boolean priceOrder) throws PricingException {
        itemRequest.setOrder(order);
        DiscreteOrderItem item = this.orderItemService.createDiscreteOrderItem(itemRequest);
        return this.addOrderItemToOrder(order, item, priceOrder);
    }

    @Override
    @Deprecated
    public OrderItem addSkuToOrder(Long orderId, Long skuId, Long productId, Long categoryId, Integer quantity) throws PricingException {
        return this.addSkuToOrder(orderId, skuId, productId, categoryId, quantity, true, null);
    }

    @Override
    @Deprecated
    public OrderItem addSkuToOrder(Long orderId, Long skuId, Long productId, Long categoryId, Integer quantity, Map<String, String> itemAttributes) throws PricingException {
        return this.addSkuToOrder(orderId, skuId, productId, categoryId, quantity, true, itemAttributes);
    }

    @Override
    @Deprecated
    public OrderItem addSkuToOrder(Long orderId, Long skuId, Long productId, Long categoryId, Integer quantity, boolean priceOrder) throws PricingException {
        return this.addSkuToOrder(orderId, skuId, productId, categoryId, quantity, priceOrder, null);
    }

    @Override
    @Deprecated
    public OrderItem addSkuToOrder(Long orderId, Long skuId, Long productId, Long categoryId, Integer quantity, boolean priceOrder, Map<String, String> itemAttributes) throws PricingException {
        if (orderId == null || productId == null && skuId == null || quantity == null) {
            return null;
        }
        OrderItemRequestDTO orderItemRequestDTO = new OrderItemRequestDTO();
        orderItemRequestDTO.setCategoryId(categoryId);
        orderItemRequestDTO.setProductId(productId);
        orderItemRequestDTO.setSkuId(skuId);
        orderItemRequestDTO.setQuantity(quantity);
        orderItemRequestDTO.setItemAttributes(itemAttributes);
        Order order = this.addItemToOrder(orderId, orderItemRequestDTO, priceOrder);
        if (order == null) {
            return null;
        }
        return this.findLastMatchingItem(order, skuId, productId);
    }

    @Override
    @Deprecated
    public OrderItem addOrderItemToOrder(Order order, OrderItem newOrderItem, boolean priceOrder) throws PricingException {
        OrderItem item;
        if (this.automaticallyMergeLikeItems && (item = this.findMatchingItem(order, newOrderItem)) != null) {
            item.setQuantity(item.getQuantity() + newOrderItem.getQuantity());
            try {
                this.updateItemQuantity(order, item, priceOrder);
            }
            catch (ItemNotFoundException e) {
                LOG.error((Object)e);
            }
            return this.findMatchingItem(order, newOrderItem);
        }
        List<OrderItem> orderItems = order.getOrderItems();
        orderItems.add(newOrderItem);
        newOrderItem.setOrder(order);
        order = this.updateOrder(order, priceOrder);
        return this.findMatchingItem(order, newOrderItem);
    }

    @Override
    @Deprecated
    public OrderItem addOrderItemToOrder(Order order, OrderItem newOrderItem) throws PricingException {
        return this.addOrderItemToOrder(order, newOrderItem, true);
    }

    @Override
    @Deprecated
    public OrderItem addDynamicPriceDiscreteItemToOrder(Order order, DiscreteOrderItemRequest itemRequest, HashMap skuPricingConsiderations) throws PricingException {
        return this.addDynamicPriceDiscreteItemToOrder(order, itemRequest, skuPricingConsiderations, true);
    }

    @Override
    @Deprecated
    public OrderItem addDynamicPriceDiscreteItemToOrder(Order order, DiscreteOrderItemRequest itemRequest, HashMap skuPricingConsiderations, boolean priceOrder) throws PricingException {
        DiscreteOrderItem item = this.orderItemService.createDynamicPriceDiscreteOrderItem(itemRequest, skuPricingConsiderations);
        return this.addOrderItemToOrder(order, item, priceOrder);
    }
}

