/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.pricing.service.fulfillment;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Map;
import junit.framework.TestCase;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupImpl;
import org.broadleafcommerce.core.order.fulfillment.domain.FixedPriceFulfillmentOption;
import org.broadleafcommerce.core.order.fulfillment.domain.FixedPriceFulfillmentOptionImpl;
import org.broadleafcommerce.core.pricing.service.fulfillment.provider.FixedPriceFulfillmentPricingProvider;
import org.broadleafcommerce.core.pricing.service.fulfillment.provider.FulfillmentEstimationResponse;

public class FixedPriceFulfillmentTest
extends TestCase {
    public void testNullFulfillmentOptionInEstimation() throws Exception {
        HashSet<FixedPriceFulfillmentOptionImpl> options = new HashSet<FixedPriceFulfillmentOptionImpl>();
        FixedPriceFulfillmentOptionImpl option1 = new FixedPriceFulfillmentOptionImpl();
        option1.setPrice(new Money(BigDecimal.ONE));
        FixedPriceFulfillmentOptionImpl option2 = new FixedPriceFulfillmentOptionImpl();
        option2.setPrice(new Money(BigDecimal.TEN));
        options.add(option1);
        options.add(option2);
        FixedPriceFulfillmentPricingProvider provider = new FixedPriceFulfillmentPricingProvider();
        FulfillmentGroupImpl fg = new FulfillmentGroupImpl();
        FulfillmentEstimationResponse response = provider.estimateCostForFulfillmentGroup((FulfillmentGroup)fg, options);
        for (Map.Entry entry : response.getFulfillmentOptionPrices().entrySet()) {
            FixedPriceFulfillmentTest.assertEquals((Object)((FixedPriceFulfillmentOption)entry.getKey()).getPrice(), entry.getValue());
        }
    }
}

