/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.pricing.service.workflow;

import java.math.BigDecimal;
import javax.annotation.Resource;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrency;
import org.broadleafcommerce.common.currency.util.BroadleafCurrencyUtils;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.pricing.service.FulfillmentPricingService;
import org.broadleafcommerce.core.pricing.service.workflow.PricingContext;
import org.broadleafcommerce.core.workflow.BaseActivity;
import org.broadleafcommerce.core.workflow.ProcessContext;

public class FulfillmentGroupPricingActivity
extends BaseActivity {
    @Resource(name="blFulfillmentPricingService")
    private FulfillmentPricingService fulfillmentPricingService;

    public void setFulfillmentPricingService(FulfillmentPricingService fulfillmentPricingService) {
        this.fulfillmentPricingService = fulfillmentPricingService;
    }

    @Override
    public ProcessContext execute(ProcessContext context) throws Exception {
        Order order = ((PricingContext)context).getSeedData();
        Money totalFulfillmentCharges = BroadleafCurrencyUtils.getMoney((BigDecimal)BigDecimal.ZERO, (BroadleafCurrency)order.getCurrency());
        for (FulfillmentGroup fulfillmentGroup : order.getFulfillmentGroups()) {
            if (fulfillmentGroup == null || (fulfillmentGroup = this.fulfillmentPricingService.calculateCostForFulfillmentGroup(fulfillmentGroup)).getFulfillmentPrice() == null) continue;
            totalFulfillmentCharges = totalFulfillmentCharges.add(fulfillmentGroup.getFulfillmentPrice());
        }
        order.setTotalFulfillmentCharges(totalFulfillmentCharges);
        context.setSeedData(order);
        return context;
    }
}

