/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.domain;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrency;
import org.broadleafcommerce.common.currency.util.BroadleafCurrencyUtils;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.client.SupportedFieldType;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupFee;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupImpl;
import org.broadleafcommerce.core.order.domain.TaxDetail;
import org.broadleafcommerce.core.order.domain.TaxDetailImpl;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;

@Entity
@DiscriminatorColumn(name="TYPE")
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_FULFILLMENT_GROUP_FEE")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
public class FulfillmentGroupFeeImpl
implements FulfillmentGroupFee {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="FulfillmentGroupFeeId", strategy=GenerationType.TABLE)
    @TableGenerator(name="FulfillmentGroupFeeId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="FulfillmentGroupFeeImpl", allocationSize=50)
    @Column(name="FULFILLMENT_GROUP_FEE_ID")
    protected Long id;
    @ManyToOne(targetEntity=FulfillmentGroupImpl.class, optional=false)
    @JoinColumn(name="FULFILLMENT_GROUP_ID")
    protected FulfillmentGroup fulfillmentGroup;
    @Column(name="AMOUNT", precision=19, scale=5)
    protected BigDecimal amount;
    @Column(name="NAME")
    protected String name;
    @Column(name="REPORTING_CODE")
    protected String reportingCode;
    @Column(name="FEE_TAXABLE_FLAG")
    @AdminPresentation(excluded=true)
    protected Boolean feeTaxable;
    @OneToMany(fetch=FetchType.LAZY, targetEntity=TaxDetailImpl.class, cascade={CascadeType.ALL})
    @JoinTable(name="BLC_FG_FEE_TAX_XREF", joinColumns={@JoinColumn(name="FULFILLMENT_GROUP_FEE_ID")}, inverseJoinColumns={@JoinColumn(name="TAX_DETAIL_ID")})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected List<TaxDetail> taxes = new ArrayList<TaxDetail>();
    @Column(name="TOTAL_FEE_TAX", precision=19, scale=5)
    @AdminPresentation(friendlyName="FulfillmentGroupFeeImpl_Total_Fee_Tax", order=9, group="FulfillmentGroupFeeImpl_Pricing", fieldType=SupportedFieldType.MONEY)
    protected BigDecimal totalTax;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public FulfillmentGroup getFulfillmentGroup() {
        return this.fulfillmentGroup;
    }

    @Override
    public void setFulfillmentGroup(FulfillmentGroup fulfillmentGroup) {
        this.fulfillmentGroup = fulfillmentGroup;
    }

    @Override
    public Money getAmount() {
        return this.amount == null ? null : BroadleafCurrencyUtils.getMoney((BigDecimal)this.amount, (BroadleafCurrency)this.getFulfillmentGroup().getOrder().getCurrency());
    }

    @Override
    public void setAmount(Money amount) {
        this.amount = Money.toAmount((Money)amount);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getReportingCode() {
        return this.reportingCode;
    }

    @Override
    public void setReportingCode(String reportingCode) {
        this.reportingCode = reportingCode;
    }

    @Override
    public Boolean isTaxable() {
        return this.feeTaxable == null ? true : this.feeTaxable;
    }

    @Override
    public void setTaxable(Boolean taxable) {
        this.feeTaxable = taxable;
    }

    @Override
    public List<TaxDetail> getTaxes() {
        return this.taxes;
    }

    @Override
    public void setTaxes(List<TaxDetail> taxes) {
        this.taxes = taxes;
    }

    @Override
    public Money getTotalTax() {
        return this.totalTax == null ? null : BroadleafCurrencyUtils.getMoney((BigDecimal)this.totalTax, (BroadleafCurrency)this.getFulfillmentGroup().getOrder().getCurrency());
    }

    @Override
    public void setTotalTax(Money totalTax) {
        this.totalTax = Money.toAmount((Money)totalTax);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.amount == null ? 0 : this.amount.hashCode());
        result = 31 * result + (this.fulfillmentGroup == null ? 0 : this.fulfillmentGroup.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.reportingCode == null ? 0 : this.reportingCode.hashCode());
        result = 31 * result + (this.taxes == null ? 0 : this.taxes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FulfillmentGroupFeeImpl other = (FulfillmentGroupFeeImpl)obj;
        if (this.amount == null ? other.amount != null : !this.amount.equals(other.amount)) {
            return false;
        }
        if (this.fulfillmentGroup == null ? other.fulfillmentGroup != null : !this.fulfillmentGroup.equals(other.fulfillmentGroup)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.reportingCode == null ? other.reportingCode != null : !this.reportingCode.equals(other.reportingCode));
    }
}

