/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.workflow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.time.SystemTime;
import org.broadleafcommerce.core.checkout.service.workflow.CheckoutContext;
import org.broadleafcommerce.core.checkout.service.workflow.CheckoutSeed;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferAudit;
import org.broadleafcommerce.core.offer.domain.OfferCode;
import org.broadleafcommerce.core.offer.service.OfferAuditService;
import org.broadleafcommerce.core.offer.service.OfferService;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.workflow.BaseActivity;
import org.broadleafcommerce.core.workflow.ProcessContext;
import org.broadleafcommerce.core.workflow.state.ActivityStateManagerImpl;

public class RecordOfferUsageActivity
extends BaseActivity {
    public static final String SAVED_AUDITS = "savedAudits";
    protected static final Log LOG = LogFactory.getLog(RecordOfferUsageActivity.class);
    @Resource(name="blOfferAuditService")
    protected OfferAuditService offerAuditService;
    @Resource(name="blOfferService")
    protected OfferService offerService;

    @Override
    public ProcessContext execute(ProcessContext context) throws Exception {
        CheckoutSeed seed = ((CheckoutContext)context).getSeedData();
        Order order = seed.getOrder();
        Set<Offer> appliedOffers = this.offerService.getUniqueOffersFromOrder(order);
        Map<Offer, OfferCode> offerToCodeMapping = this.offerService.getOffersRetrievedFromCodes(order.getAddedOfferCodes(), appliedOffers);
        List<OfferAudit> audits = this.saveOfferIds(appliedOffers, offerToCodeMapping, order);
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put(SAVED_AUDITS, audits);
        ActivityStateManagerImpl.getStateManager().registerState(this, context, this.getRollbackHandler(), state);
        return context;
    }

    protected List<OfferAudit> saveOfferIds(Set<Offer> offers, Map<Offer, OfferCode> offerToCodeMapping, Order order) {
        ArrayList<OfferAudit> audits = new ArrayList<OfferAudit>(offers.size());
        for (Offer offer : offers) {
            OfferAudit audit = this.offerAuditService.create();
            audit.setCustomerId(order.getCustomer().getId());
            audit.setOfferId(offer.getId());
            audit.setOrderId(order.getId());
            try {
                OfferCode codeUsedToRetrieveOffer = offerToCodeMapping.get(offer);
                if (codeUsedToRetrieveOffer != null) {
                    audit.setOfferCodeId(codeUsedToRetrieveOffer.getId());
                }
            }
            catch (UnsupportedOperationException e) {
                LOG.warn((Object)"Checking for offer code max usage has not been enabled in your Broadleaf installation. This warning will only appear in Broadleaf versions prior to 3.1.0. In order to fix your version of Broadleaf to enable this functionality, refer to the OfferAuditWeaveImpl or directly to https://github.com/BroadleafCommerce/BroadleafCommerce/pull/195.");
            }
            audit.setRedeemedDate(SystemTime.asDate());
            audit = this.offerAuditService.save(audit);
            audits.add(audit);
        }
        return audits;
    }

    @Override
    public boolean getAutomaticallyRegisterRollbackHandler() {
        return false;
    }
}

