/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.domain;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.broadleafcommerce.common.currency.util.BroadleafCurrencyUtils;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.persistence.ArchiveStatus;
import org.broadleafcommerce.common.persistence.Status;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.AdminPresentationCollection;
import org.broadleafcommerce.common.presentation.PopulateToOneFieldsEnum;
import org.broadleafcommerce.common.presentation.client.AddMethodType;
import org.broadleafcommerce.common.presentation.client.SupportedFieldType;
import org.broadleafcommerce.common.presentation.client.VisibilityEnum;
import org.broadleafcommerce.common.presentation.override.AdminPresentationOverride;
import org.broadleafcommerce.common.presentation.override.AdminPresentationOverrides;
import org.broadleafcommerce.common.util.DateUtil;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferCode;
import org.broadleafcommerce.core.offer.domain.OfferCodeImpl;
import org.broadleafcommerce.core.offer.domain.OfferItemCriteria;
import org.broadleafcommerce.core.offer.domain.OfferItemCriteriaImpl;
import org.broadleafcommerce.core.offer.domain.OfferRule;
import org.broadleafcommerce.core.offer.domain.OfferRuleImpl;
import org.broadleafcommerce.core.offer.service.type.OfferDeliveryType;
import org.broadleafcommerce.core.offer.service.type.OfferDiscountType;
import org.broadleafcommerce.core.offer.service.type.OfferItemRestrictionRuleType;
import org.broadleafcommerce.core.offer.service.type.OfferType;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BLC_OFFER")
@Inheritance(strategy=InheritanceType.JOINED)
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
@AdminPresentationOverrides(value={@AdminPresentationOverride(name="targetItemCriteria.offer", value=@AdminPresentation(excluded=true))})
@AdminPresentationClass(populateToOneFields=PopulateToOneFieldsEnum.TRUE, friendlyName="OfferImpl_baseOffer")
@SQLDelete(sql="UPDATE BLC_OFFER SET ARCHIVED = 'Y' WHERE OFFER_ID = ?")
public class OfferImpl
implements Offer,
Status {
    public static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="OfferId")
    @GenericGenerator(name="OfferId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="OfferImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.offer.domain.OfferImpl")})
    @Column(name="OFFER_ID")
    @AdminPresentation(friendlyName="OfferImpl_Offer_Id", order=1, group="OfferImpl_Description", groupOrder=1, visibility=VisibilityEnum.HIDDEN_ALL)
    protected Long id;
    @Column(name="OFFER_NAME", nullable=false)
    @Index(name="OFFER_NAME_INDEX", columnNames={"OFFER_NAME"})
    @AdminPresentation(friendlyName="OfferImpl_Offer_Name", order=3, group="OfferImpl_Description", prominent=true, groupOrder=1)
    protected String name;
    @Column(name="OFFER_DESCRIPTION")
    @AdminPresentation(friendlyName="OfferImpl_Offer_Description", order=4, group="OfferImpl_Description", largeEntry=true, prominent=true, groupOrder=1)
    protected String description;
    @Column(name="MARKETING_MESSASGE")
    @Index(name="OFFER_MARKETING_MESSAGE_INDEX", columnNames={"MARKETING_MESSASGE"})
    @AdminPresentation(friendlyName="OfferImpl_marketingMessage", order=3, group="OfferImpl_Description", groupOrder=1)
    protected String marketingMessage;
    @Column(name="OFFER_TYPE", nullable=false)
    @Index(name="OFFER_TYPE_INDEX", columnNames={"OFFER_TYPE"})
    @AdminPresentation(friendlyName="OfferImpl_Offer_Type", order=1, group="OfferImpl_Description", prominent=true, fieldType=SupportedFieldType.BROADLEAF_ENUMERATION, broadleafEnumeration="org.broadleafcommerce.core.offer.service.type.OfferType", groupOrder=1)
    protected String type;
    @Column(name="OFFER_DISCOUNT_TYPE")
    @Index(name="OFFER_DISCOUNT_INDEX", columnNames={"OFFER_DISCOUNT_TYPE"})
    @AdminPresentation(friendlyName="OfferImpl_Offer_Discount_Type", order=5, group="OfferImpl_Description", fieldType=SupportedFieldType.BROADLEAF_ENUMERATION, broadleafEnumeration="org.broadleafcommerce.core.offer.service.type.OfferDiscountType", groupOrder=1)
    protected String discountType;
    @Column(name="OFFER_VALUE", nullable=false, precision=19, scale=5)
    @AdminPresentation(friendlyName="OfferImpl_Offer_Value", order=6, group="OfferImpl_Description", prominent=true, groupOrder=1)
    protected BigDecimal value;
    @Column(name="OFFER_PRIORITY")
    @AdminPresentation(friendlyName="OfferImpl_Offer_Priority", order=7, group="OfferImpl_Advanced", groupOrder=4)
    protected int priority;
    @Column(name="START_DATE")
    @AdminPresentation(friendlyName="OfferImpl_Offer_Start_Date", group="OfferImpl_Activity_Range", order=1, groupOrder=3)
    protected Date startDate;
    @Column(name="END_DATE")
    @AdminPresentation(friendlyName="OfferImpl_Offer_End_Date", group="OfferImpl_Activity_Range", order=2, groupOrder=3)
    protected Date endDate;
    @Column(name="STACKABLE")
    @AdminPresentation(friendlyName="OfferImpl_Offer_Stackable", group="OfferImpl_Advanced", groupOrder=4)
    protected boolean stackable;
    @Column(name="TARGET_SYSTEM")
    @AdminPresentation(friendlyName="OfferImpl_Offer_Target_System", group="OfferImpl_Advanced", groupOrder=4)
    protected String targetSystem;
    @Column(name="APPLY_TO_SALE_PRICE")
    @AdminPresentation(friendlyName="OfferImpl_Apply_To_Sale_Price", group="OfferImpl_Description", groupOrder=1, order=7)
    protected boolean applyToSalePrice;
    @Column(name="APPLIES_TO_RULES")
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    @Deprecated
    protected String appliesToOrderRules;
    @Column(name="APPLIES_WHEN_RULES")
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    @Deprecated
    protected String appliesToCustomerRules;
    @Column(name="APPLY_OFFER_TO_MARKED_ITEMS")
    @AdminPresentation(excluded=true)
    @Deprecated
    protected boolean applyDiscountToMarkedItems;
    @Column(name="COMBINABLE_WITH_OTHER_OFFERS")
    @AdminPresentation(friendlyName="OfferImpl_Offer_Combinable", group="OfferImpl_Advanced", groupOrder=4, visibility=VisibilityEnum.HIDDEN_ALL)
    protected boolean combinableWithOtherOffers;
    @Column(name="OFFER_DELIVERY_TYPE", nullable=false)
    @AdminPresentation(friendlyName="OfferImpl_Offer_Delivery_Type", group="OfferImpl_Description", fieldType=SupportedFieldType.BROADLEAF_ENUMERATION, broadleafEnumeration="org.broadleafcommerce.core.offer.service.type.OfferDeliveryType", groupOrder=1)
    @Index(name="OFFER_DELIVERY_INDEX", columnNames={"OFFER_DELIVERY_TYPE"})
    protected String deliveryType;
    @Column(name="MAX_USES")
    @AdminPresentation(friendlyName="OfferImpl_Offer_Max_Uses_Per_Order", order=7, group="OfferImpl_Advanced", groupOrder=2)
    protected int maxUsesPerOrder;
    @Column(name="MAX_USES_PER_CUSTOMER")
    @AdminPresentation(friendlyName="OfferImpl_Max_Uses_Per_Customer", order=7, group="OfferImpl_Advanced", groupOrder=1)
    protected Long maxUsesPerCustomer;
    @Column(name="USES")
    @AdminPresentation(friendlyName="OfferImpl_Offer_Current_Uses", visibility=VisibilityEnum.HIDDEN_ALL)
    @Deprecated
    protected int uses;
    @Column(name="OFFER_ITEM_QUALIFIER_RULE")
    @AdminPresentation(friendlyName="OfferImpl_Item_Qualifier_Rule", group="OfferImpl_Advanced", groupOrder=4, fieldType=SupportedFieldType.BROADLEAF_ENUMERATION, broadleafEnumeration="org.broadleafcommerce.core.offer.service.type.OfferItemRestrictionRuleType")
    protected String offerItemQualifierRuleType;
    @Column(name="OFFER_ITEM_TARGET_RULE")
    @AdminPresentation(friendlyName="OfferImpl_Item_Target_Rule", group="OfferImpl_Advanced", groupOrder=4, fieldType=SupportedFieldType.BROADLEAF_ENUMERATION, broadleafEnumeration="org.broadleafcommerce.core.offer.service.type.OfferItemRestrictionRuleType")
    protected String offerItemTargetRuleType;
    @OneToMany(fetch=FetchType.LAZY, targetEntity=OfferItemCriteriaImpl.class, cascade={CascadeType.ALL})
    @JoinTable(name="BLC_QUAL_CRIT_OFFER_XREF", joinColumns={@JoinColumn(name="OFFER_ID")}, inverseJoinColumns={@JoinColumn(name="OFFER_ITEM_CRITERIA_ID")})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    protected Set<OfferItemCriteria> qualifyingItemCriteria = new HashSet<OfferItemCriteria>();
    @OneToMany(fetch=FetchType.LAZY, targetEntity=OfferItemCriteriaImpl.class, cascade={CascadeType.ALL})
    @JoinTable(name="BLC_TAR_CRIT_OFFER_XREF", joinColumns={@JoinColumn(name="OFFER_ID")}, inverseJoinColumns={@JoinColumn(name="OFFER_ITEM_CRITERIA_ID")})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    protected Set<OfferItemCriteria> targetItemCriteria = new HashSet<OfferItemCriteria>();
    @Column(name="TOTALITARIAN_OFFER")
    @AdminPresentation(friendlyName="OfferImpl_Totalitarian_Offer", group="OfferImpl_Advanced", groupOrder=4, visibility=VisibilityEnum.HIDDEN_ALL)
    protected Boolean totalitarianOffer;
    @ManyToMany(targetEntity=OfferRuleImpl.class, cascade={CascadeType.ALL})
    @JoinTable(name="BLC_OFFER_RULE_MAP", inverseJoinColumns={@JoinColumn(name="OFFER_RULE_ID", referencedColumnName="OFFER_RULE_ID")})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @MapKeyColumn(name="MAP_KEY", nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    Map<String, OfferRule> offerMatchRules = new HashMap<String, OfferRule>();
    @OneToMany(mappedBy="offer", targetEntity=OfferCodeImpl.class, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    @BatchSize(size=50)
    @AdminPresentationCollection(addType=AddMethodType.PERSIST, friendlyName="offerCodeListTitle", order=1)
    protected List<OfferCode> offerCodes = new ArrayList<OfferCode>(100);
    @Column(name="USE_NEW_FORMAT")
    @AdminPresentation(friendlyName="OfferImpl_Treat_As_New_Format", group="OfferImpl_Advanced", groupOrder=4, visibility=VisibilityEnum.HIDDEN_ALL)
    protected Boolean treatAsNewFormat;
    @Column(name="QUALIFYING_ITEM_MIN_TOTAL", precision=19, scale=5)
    @AdminPresentation(friendlyName="Qualifying Item Subtotal", group="OfferImpl_Advanced", groupOrder=5)
    protected BigDecimal qualifyingItemSubTotal;
    @Embedded
    protected ArchiveStatus archiveStatus = new ArchiveStatus();

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public OfferType getType() {
        return OfferType.getInstance(this.type);
    }

    @Override
    public void setType(OfferType type) {
        this.type = type.getType();
    }

    @Override
    public OfferDiscountType getDiscountType() {
        return OfferDiscountType.getInstance(this.discountType);
    }

    @Override
    public void setDiscountType(OfferDiscountType discountType) {
        this.discountType = discountType.getType();
    }

    @Override
    public OfferItemRestrictionRuleType getOfferItemQualifierRuleType() {
        return OfferItemRestrictionRuleType.getInstance(this.offerItemQualifierRuleType);
    }

    @Override
    public void setOfferItemQualifierRuleType(OfferItemRestrictionRuleType restrictionRuleType) {
        this.offerItemQualifierRuleType = restrictionRuleType.getType();
    }

    @Override
    public OfferItemRestrictionRuleType getOfferItemTargetRuleType() {
        return OfferItemRestrictionRuleType.getInstance(this.offerItemTargetRuleType);
    }

    @Override
    public void setOfferItemTargetRuleType(OfferItemRestrictionRuleType restrictionRuleType) {
        this.offerItemTargetRuleType = restrictionRuleType.getType();
    }

    @Override
    public BigDecimal getValue() {
        return this.value;
    }

    @Override
    public void setValue(BigDecimal value) {
        this.value = value;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public Date getStartDate() {
        if ('Y' == this.getArchived().charValue()) {
            return null;
        }
        return this.startDate;
    }

    @Override
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @Override
    public Date getEndDate() {
        return this.endDate;
    }

    @Override
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @Override
    public boolean isStackable() {
        return this.stackable;
    }

    @Override
    public void setStackable(boolean stackable) {
        this.stackable = stackable;
    }

    @Deprecated
    @JsonIgnore
    public boolean getStackable() {
        return this.stackable;
    }

    @Override
    public String getTargetSystem() {
        return this.targetSystem;
    }

    @Override
    public void setTargetSystem(String targetSystem) {
        this.targetSystem = targetSystem;
    }

    @Override
    public boolean getApplyDiscountToSalePrice() {
        return this.applyToSalePrice;
    }

    @Override
    public void setApplyDiscountToSalePrice(boolean applyToSalePrice) {
        this.applyToSalePrice = applyToSalePrice;
    }

    @Override
    @Deprecated
    public String getAppliesToOrderRules() {
        return this.appliesToOrderRules;
    }

    @Override
    @Deprecated
    public void setAppliesToOrderRules(String appliesToOrderRules) {
        this.appliesToOrderRules = appliesToOrderRules;
    }

    @Override
    @Deprecated
    public String getAppliesToCustomerRules() {
        return this.appliesToCustomerRules;
    }

    @Override
    @Deprecated
    public void setAppliesToCustomerRules(String appliesToCustomerRules) {
        this.appliesToCustomerRules = appliesToCustomerRules;
    }

    @Override
    @Deprecated
    public boolean isApplyDiscountToMarkedItems() {
        return this.applyDiscountToMarkedItems;
    }

    @Deprecated
    @JsonIgnore
    public boolean getApplyDiscountToMarkedItems() {
        return this.applyDiscountToMarkedItems;
    }

    @Override
    @Deprecated
    public void setApplyDiscountToMarkedItems(boolean applyDiscountToMarkedItems) {
        this.applyDiscountToMarkedItems = applyDiscountToMarkedItems;
    }

    @Override
    public boolean isCombinableWithOtherOffers() {
        return this.combinableWithOtherOffers;
    }

    @Override
    public void setCombinableWithOtherOffers(boolean combinableWithOtherOffers) {
        this.combinableWithOtherOffers = combinableWithOtherOffers;
    }

    @Deprecated
    @JsonIgnore
    public boolean getCombinableWithOtherOffers() {
        return this.combinableWithOtherOffers;
    }

    @Override
    public OfferDeliveryType getDeliveryType() {
        return OfferDeliveryType.getInstance(this.deliveryType);
    }

    @Override
    public void setDeliveryType(OfferDeliveryType deliveryType) {
        this.deliveryType = deliveryType.getType();
    }

    @Override
    public Long getMaxUsesPerCustomer() {
        return this.maxUsesPerCustomer == null ? 0L : this.maxUsesPerCustomer;
    }

    @Override
    public void setMaxUsesPerCustomer(Long maxUsesPerCustomer) {
        this.maxUsesPerCustomer = maxUsesPerCustomer;
    }

    @Override
    public boolean isUnlimitedUsePerCustomer() {
        return this.getMaxUsesPerCustomer() == 0L;
    }

    @Override
    public boolean isLimitedUsePerCustomer() {
        return this.getMaxUsesPerCustomer() > 0L;
    }

    @Override
    public int getMaxUsesPerOrder() {
        return this.maxUsesPerOrder;
    }

    @Override
    public void setMaxUsesPerOrder(int maxUsesPerOrder) {
        this.maxUsesPerOrder = maxUsesPerOrder;
    }

    @Override
    public boolean isUnlimitedUsePerOrder() {
        return this.getMaxUsesPerOrder() == 0;
    }

    @Override
    public boolean isLimitedUsePerOrder() {
        return this.getMaxUsesPerOrder() > 0;
    }

    @Override
    @Deprecated
    public int getMaxUses() {
        return this.getMaxUsesPerOrder();
    }

    @Override
    public void setMaxUses(int maxUses) {
        this.setMaxUsesPerOrder(maxUses);
    }

    @Override
    @Deprecated
    public int getUses() {
        return this.uses;
    }

    @Override
    public String getMarketingMessage() {
        return this.marketingMessage;
    }

    @Override
    public void setMarketingMessage(String marketingMessage) {
        this.marketingMessage = marketingMessage;
    }

    @Override
    @Deprecated
    public void setUses(int uses) {
        this.uses = uses;
    }

    @Override
    public Set<OfferItemCriteria> getQualifyingItemCriteria() {
        return this.qualifyingItemCriteria;
    }

    @Override
    public void setQualifyingItemCriteria(Set<OfferItemCriteria> qualifyingItemCriteria) {
        this.qualifyingItemCriteria = qualifyingItemCriteria;
    }

    @Override
    public Set<OfferItemCriteria> getTargetItemCriteria() {
        return this.targetItemCriteria;
    }

    @Override
    public void setTargetItemCriteria(Set<OfferItemCriteria> targetItemCriteria) {
        this.targetItemCriteria = targetItemCriteria;
    }

    @Override
    public Boolean isTotalitarianOffer() {
        if (this.totalitarianOffer == null) {
            return false;
        }
        return (boolean)this.totalitarianOffer;
    }

    @Override
    public void setTotalitarianOffer(Boolean totalitarianOffer) {
        this.totalitarianOffer = totalitarianOffer == null ? Boolean.valueOf(false) : totalitarianOffer;
    }

    @Override
    public Map<String, OfferRule> getOfferMatchRules() {
        if (this.offerMatchRules == null) {
            this.offerMatchRules = new HashMap<String, OfferRule>();
        }
        return this.offerMatchRules;
    }

    @Override
    public void setOfferMatchRules(Map<String, OfferRule> offerMatchRules) {
        this.offerMatchRules = offerMatchRules;
    }

    @Override
    public Boolean getTreatAsNewFormat() {
        return this.treatAsNewFormat;
    }

    @Override
    public void setTreatAsNewFormat(Boolean treatAsNewFormat) {
        this.treatAsNewFormat = treatAsNewFormat;
    }

    public Character getArchived() {
        if (this.archiveStatus == null) {
            this.archiveStatus = new ArchiveStatus();
        }
        return this.archiveStatus.getArchived();
    }

    public void setArchived(Character archived) {
        if (this.archiveStatus == null) {
            this.archiveStatus = new ArchiveStatus();
        }
        this.archiveStatus.setArchived(archived);
    }

    public boolean isActive() {
        return DateUtil.isActive((Date)this.startDate, (Date)this.endDate, (boolean)true) && 'Y' != this.getArchived().charValue();
    }

    @Override
    public Money getQualifyingItemSubTotal() {
        return this.qualifyingItemSubTotal == null ? null : BroadleafCurrencyUtils.getMoney((BigDecimal)this.qualifyingItemSubTotal, null);
    }

    @Override
    public void setQualifyingItemSubTotal(Money qualifyingItemSubTotal) {
        this.qualifyingItemSubTotal = Money.toAmount((Money)qualifyingItemSubTotal);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.name).append((Object)this.startDate).append((Object)this.type).append((Object)this.value).build();
    }

    public boolean equals(Object o) {
        if (o instanceof OfferImpl) {
            OfferImpl that = (OfferImpl)o;
            return new EqualsBuilder().append((Object)this.id, (Object)that.id).append((Object)this.name, (Object)that.name).append((Object)this.startDate, (Object)that.startDate).append((Object)this.type, (Object)that.type).append((Object)this.value, (Object)that.value).build();
        }
        return false;
    }
}

