/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.workflow;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.core.workflow.ErrorHandler;
import org.broadleafcommerce.core.workflow.ProcessContext;
import org.broadleafcommerce.core.workflow.WorkflowException;
import org.springframework.stereotype.Component;

@Component(value="blDefaultErrorHandler")
public class DefaultErrorHandler
implements ErrorHandler {
    private static final Log LOG = LogFactory.getLog(DefaultErrorHandler.class);
    private String name;
    protected List<String> unloggedExceptionClasses = new ArrayList<String>();

    @Override
    public void handleError(ProcessContext context, Throwable th) throws WorkflowException {
        context.stopProcess();
        if (!this.unloggedExceptionClasses.contains(th.getClass().getName())) {
            LOG.error((Object)"An error occurred during the workflow", th);
        }
        throw new WorkflowException(th);
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    public List<String> getUnloggedExceptionClasses() {
        return this.unloggedExceptionClasses;
    }

    public void setUnloggedExceptionClasses(List<String> unloggedExceptionClasses) {
        this.unloggedExceptionClasses = unloggedExceptionClasses;
    }
}

