/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.pricing.service.workflow;

import javax.annotation.Resource;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.pricing.service.FulfillmentPricingService;
import org.broadleafcommerce.core.pricing.service.workflow.PricingContext;
import org.broadleafcommerce.core.workflow.BaseActivity;
import org.broadleafcommerce.core.workflow.ProcessContext;

public class FulfillmentGroupPricingActivity
extends BaseActivity {
    @Resource(name="blFulfillmentPricingService")
    private FulfillmentPricingService fulfillmentPricingService;

    public void setFulfillmentPricingService(FulfillmentPricingService fulfillmentPricingService) {
        this.fulfillmentPricingService = fulfillmentPricingService;
    }

    @Override
    public ProcessContext execute(ProcessContext context) throws Exception {
        Order order = ((PricingContext)context).getSeedData();
        Money totalShipping = new Money(0.0);
        for (FulfillmentGroup fulfillmentGroup : order.getFulfillmentGroups()) {
            if (fulfillmentGroup == null || (fulfillmentGroup = this.fulfillmentPricingService.calculateCostForFulfillmentGroup(fulfillmentGroup)).getShippingPrice() == null) continue;
            totalShipping = totalShipping.add(fulfillmentGroup.getShippingPrice());
        }
        order.setTotalShipping(totalShipping);
        context.setSeedData(order);
        return context;
    }
}

