/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.service.workflow;

import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.service.CatalogService;
import org.broadleafcommerce.core.order.domain.BundleOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.OrderItemService;
import org.broadleafcommerce.core.order.service.exception.InventoryUnavailableException;
import org.broadleafcommerce.core.order.service.workflow.CartOperationContext;
import org.broadleafcommerce.core.order.service.workflow.CartOperationRequest;
import org.broadleafcommerce.core.workflow.BaseActivity;
import org.broadleafcommerce.core.workflow.ProcessContext;

public class CheckAvailabilityActivity
extends BaseActivity {
    private static Log LOG = LogFactory.getLog(CheckAvailabilityActivity.class);
    @Resource(name="blCatalogService")
    protected CatalogService catalogService;
    @Resource(name="blOrderItemService")
    protected OrderItemService orderItemService;

    @Override
    public ProcessContext execute(ProcessContext context) throws Exception {
        CartOperationRequest request = ((CartOperationContext)context).getSeedData();
        Sku sku = null;
        if (request.getItemRequest().getSkuId() != null) {
            sku = this.catalogService.findSkuById(request.getItemRequest().getSkuId());
        } else {
            OrderItem orderItem = this.orderItemService.readOrderItemById(request.getItemRequest().getOrderItemId());
            if (orderItem instanceof DiscreteOrderItem) {
                sku = ((DiscreteOrderItem)orderItem).getSku();
                request.getItemRequest().setSkuId(sku.getId());
            } else if (orderItem instanceof BundleOrderItem) {
                sku = ((BundleOrderItem)orderItem).getSku();
                request.getItemRequest().setSkuId(sku.getId());
            }
        }
        if (sku == null || !sku.isActive()) {
            throw new InventoryUnavailableException("The requested SKU is no longer active");
        }
        return context;
    }
}

