/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.service;

import java.util.List;
import org.broadleafcommerce.core.offer.domain.OfferCode;
import org.broadleafcommerce.core.offer.service.exception.OfferMaxUseExceededException;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.call.GiftWrapOrderItemRequest;
import org.broadleafcommerce.core.order.service.call.OrderItemRequestDTO;
import org.broadleafcommerce.core.order.service.exception.AddToCartException;
import org.broadleafcommerce.core.order.service.exception.RemoveFromCartException;
import org.broadleafcommerce.core.order.service.exception.UpdateCartException;
import org.broadleafcommerce.core.order.service.type.OrderStatus;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.payment.domain.Referenced;
import org.broadleafcommerce.core.payment.service.type.PaymentInfoType;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.profile.core.domain.Customer;

public interface OrderService {
    public Order createNewCartForCustomer(Customer var1);

    public Order createNamedOrderForCustomer(String var1, Customer var2);

    public Order findNamedOrderForCustomer(String var1, Customer var2);

    public Order findOrderById(Long var1);

    public Order findCartForCustomer(Customer var1);

    public List<Order> findOrdersForCustomer(Customer var1);

    public List<Order> findOrdersForCustomer(Customer var1, OrderStatus var2);

    public Order findOrderByOrderNumber(String var1);

    public List<PaymentInfo> findPaymentInfosForOrder(Order var1);

    public PaymentInfo addPaymentToOrder(Order var1, PaymentInfo var2, Referenced var3);

    public Order save(Order var1, Boolean var2) throws PricingException;

    public void cancelOrder(Order var1);

    public Order addOfferCode(Order var1, OfferCode var2, boolean var3) throws PricingException, OfferMaxUseExceededException;

    public Order removeOfferCode(Order var1, OfferCode var2, boolean var3) throws PricingException;

    public Order removeAllOfferCodes(Order var1, boolean var2) throws PricingException;

    public Order getNullOrder();

    public boolean getAutomaticallyMergeLikeItems();

    public void setAutomaticallyMergeLikeItems(boolean var1);

    public Order confirmOrder(Order var1);

    public OrderItem findLastMatchingItem(Order var1, Long var2, Long var3);

    public OrderItem addGiftWrapItemToOrder(Order var1, GiftWrapOrderItemRequest var2, boolean var3) throws PricingException;

    public Order addItem(Long var1, OrderItemRequestDTO var2, boolean var3) throws AddToCartException;

    public Order updateItemQuantity(Long var1, OrderItemRequestDTO var2, boolean var3) throws UpdateCartException, RemoveFromCartException;

    public Order removeItem(Long var1, Long var2, boolean var3) throws RemoveFromCartException;

    public boolean isMoveNamedOrderItems();

    public void setMoveNamedOrderItems(boolean var1);

    public boolean isDeleteEmptyNamedOrders();

    public void setDeleteEmptyNamedOrders(boolean var1);

    public Order addItemFromNamedOrder(Order var1, OrderItem var2, boolean var3) throws RemoveFromCartException, AddToCartException;

    public Order addItemFromNamedOrder(Order var1, OrderItem var2, int var3, boolean var4) throws RemoveFromCartException, AddToCartException, UpdateCartException;

    public Order addAllItemsFromNamedOrder(Order var1, boolean var2) throws RemoveFromCartException, AddToCartException;

    public void removeAllPaymentsFromOrder(Order var1);

    public void removePaymentsFromOrder(Order var1, PaymentInfoType var2);
}

