/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.media.domain;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.client.SupportedFieldType;
import org.broadleafcommerce.core.media.domain.Media;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_MEDIA")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
public class MediaImpl
implements Media {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="MediaId")
    @GenericGenerator(name="MediaId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="table_name", value="SEQUENCE_GENERATOR"), @Parameter(name="segment_column_name", value="ID_NAME"), @Parameter(name="value_column_name", value="ID_VAL"), @Parameter(name="segment_value", value="MediaId"), @Parameter(name="increment_size", value="50"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.media.domain.MediaImpl")})
    @Column(name="MEDIA_ID")
    protected Long id;
    @Column(name="URL", nullable=false)
    @Index(name="MEDIA_URL_INDEX", columnNames={"URL"})
    @AdminPresentation(friendlyName="MediaImpl_Media_Url", order=1, prominent=true, fieldType=SupportedFieldType.ASSET_URL)
    protected String url;
    @Column(name="TITLE")
    @Index(name="MEDIA_TITLE_INDEX", columnNames={"TITLE"})
    @AdminPresentation(friendlyName="MediaImpl_Media_Title", order=2, prominent=true)
    protected String title;
    @Column(name="ALT_TEXT")
    @AdminPresentation(friendlyName="MediaImpl_Media_Alt_Text", order=3, prominent=true)
    protected String altText;
    @Column(name="TAGS")
    @AdminPresentation(friendlyName="MediaImpl_Media_Tags")
    protected String tags;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getAltText() {
        return this.altText;
    }

    @Override
    public void setAltText(String altText) {
        this.altText = altText;
    }

    @Override
    public String getTags() {
        return this.tags;
    }

    @Override
    public void setTags(String tags) {
        this.tags = tags;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        result = 31 * result + (this.altText == null ? 0 : this.altText.hashCode());
        result = 31 * result + (this.tags == null ? 0 : this.tags.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MediaImpl other = (MediaImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.title == null ? other.title != null : !this.title.equals(other.title)) {
            return false;
        }
        if (this.altText == null ? other.altText != null : !this.altText.equals(other.altText)) {
            return false;
        }
        if (this.tags == null ? other.tags != null : !this.tags.equals(other.tags)) {
            return false;
        }
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }
}

