/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.processor;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.offer.dao.OfferDao;
import org.broadleafcommerce.core.offer.domain.CandidateItemOffer;
import org.broadleafcommerce.core.offer.domain.CandidateItemOfferImpl;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferItemCriteria;
import org.broadleafcommerce.core.offer.domain.OrderItemAdjustment;
import org.broadleafcommerce.core.offer.domain.OrderItemAdjustmentImpl;
import org.broadleafcommerce.core.offer.service.OfferDataItemProvider;
import org.broadleafcommerce.core.offer.service.discount.CandidatePromotionItems;
import org.broadleafcommerce.core.offer.service.discount.PromotionDiscount;
import org.broadleafcommerce.core.offer.service.discount.PromotionQualifier;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateItemOffer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableFulfillmentGroup;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableItemFactory;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableItemFactoryImpl;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrder;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItem;
import org.broadleafcommerce.core.offer.service.processor.ItemOfferProcessorImpl;
import org.broadleafcommerce.core.offer.service.type.OfferDiscountType;
import org.broadleafcommerce.core.offer.service.type.OfferItemRestrictionRuleType;
import org.broadleafcommerce.core.order.dao.FulfillmentGroupItemDao;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.CartService;
import org.broadleafcommerce.core.order.service.OrderItemService;
import org.broadleafcommerce.core.order.service.manipulation.OrderItemSplitContainer;
import org.easymock.IAnswer;
import org.easymock.classextension.EasyMock;

public class ItemOfferProcessorTest
extends TestCase {
    private OfferDao offerDaoMock;
    private CartService cartServiceMock;
    private OrderItemService orderItemServiceMock;
    private FulfillmentGroupItemDao fgItemDaoMock;
    private ItemOfferProcessorImpl itemProcessor;
    private OfferDataItemProvider dataProvider = new OfferDataItemProvider();

    protected void setUp() throws Exception {
        this.offerDaoMock = (OfferDao)EasyMock.createMock(OfferDao.class);
        this.cartServiceMock = (CartService)EasyMock.createMock(CartService.class);
        this.orderItemServiceMock = (OrderItemService)EasyMock.createMock(OrderItemService.class);
        this.fgItemDaoMock = (FulfillmentGroupItemDao)EasyMock.createMock(FulfillmentGroupItemDao.class);
        this.itemProcessor = new ItemOfferProcessorImpl();
        this.itemProcessor.setOfferDao(this.offerDaoMock);
        this.itemProcessor.setCartService(this.cartServiceMock);
        this.itemProcessor.setFulfillmentGroupItemDao(this.fgItemDaoMock);
        this.itemProcessor.setOrderItemService(this.orderItemServiceMock);
        this.itemProcessor.setPromotableItemFactory((PromotableItemFactory)new PromotableItemFactoryImpl());
    }

    public void replay() {
        EasyMock.replay((Object[])new Object[]{this.offerDaoMock});
        EasyMock.replay((Object[])new Object[]{this.cartServiceMock});
        EasyMock.replay((Object[])new Object[]{this.orderItemServiceMock});
        EasyMock.replay((Object[])new Object[]{this.fgItemDaoMock});
    }

    public void verify() {
        EasyMock.verify((Object[])new Object[]{this.offerDaoMock});
        EasyMock.verify((Object[])new Object[]{this.cartServiceMock});
        EasyMock.verify((Object[])new Object[]{this.orderItemServiceMock});
        EasyMock.verify((Object[])new Object[]{this.fgItemDaoMock});
    }

    public void testFilterItemLevelOffer() {
        EasyMock.expect((Object)this.offerDaoMock.createCandidateItemOffer()).andReturn((Object)new CandidateItemOfferImpl()).times(3);
        this.replay();
        PromotableOrder order = this.dataProvider.createBasicOrder();
        ArrayList qualifiedOffers = new ArrayList();
        List<Offer> offers = this.dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, null, null);
        this.itemProcessor.filterItemLevelOffer(order, qualifiedOffers, offers.get(0));
        ItemOfferProcessorTest.assertTrue((qualifiedOffers.size() == 2 && ((PromotableCandidateItemOffer)qualifiedOffers.get(0)).getOffer().equals(offers.get(0)) && ((PromotableCandidateItemOffer)qualifiedOffers.get(1)).getOffer().equals(offers.get(0)) ? 1 : 0) != 0);
        qualifiedOffers = new ArrayList();
        offers = this.dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))", "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))");
        this.itemProcessor.filterItemLevelOffer(order, qualifiedOffers, offers.get(0));
        ItemOfferProcessorTest.assertTrue((qualifiedOffers.size() == 1 && ((PromotableCandidateItemOffer)qualifiedOffers.get(0)).getOffer().equals(offers.get(0)) && ((PromotableCandidateItemOffer)qualifiedOffers.get(0)).getCandidateQualifiersMap().size() == 1 ? 1 : 0) != 0);
        qualifiedOffers = new ArrayList();
        offers = this.dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test5\"), MVEL.eval(\"toUpperCase()\",\"test6\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))", "([MVEL.eval(\"toUpperCase()\",\"test5\"), MVEL.eval(\"toUpperCase()\",\"test6\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))");
        this.itemProcessor.filterItemLevelOffer(order, qualifiedOffers, offers.get(0));
        ItemOfferProcessorTest.assertTrue((qualifiedOffers.size() == 0 ? 1 : 0) != 0);
        this.verify();
    }

    public void testCouldOfferApplyToOrder() {
        this.replay();
        PromotableOrder order = this.dataProvider.createBasicOrder();
        List<Offer> offers = this.dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, null, null);
        boolean couldApply = this.itemProcessor.couldOfferApplyToOrder(offers.get(0), order, (PromotableOrderItem)order.getDiscountableDiscreteOrderItems().get(0), (PromotableFulfillmentGroup)order.getFulfillmentGroups().get(0));
        ItemOfferProcessorTest.assertTrue((boolean)couldApply);
        offers = this.dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()==0", OfferDiscountType.PERCENT_OFF, null, null);
        couldApply = this.itemProcessor.couldOfferApplyToOrder(offers.get(0), order, (PromotableOrderItem)order.getDiscountableDiscreteOrderItems().get(0), (PromotableFulfillmentGroup)order.getFulfillmentGroups().get(0));
        ItemOfferProcessorTest.assertFalse((boolean)couldApply);
        this.verify();
    }

    public void testCouldOrderItemMeetOfferRequirement() {
        this.replay();
        PromotableOrder order = this.dataProvider.createBasicOrder();
        List<Offer> offers = this.dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))", "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))");
        boolean couldApply = this.itemProcessor.couldOrderItemMeetOfferRequirement((OfferItemCriteria)offers.get(0).getQualifyingItemCriteria().iterator().next(), (PromotableOrderItem)order.getDiscountableDiscreteOrderItems().get(0));
        ItemOfferProcessorTest.assertTrue((boolean)couldApply);
        offers = this.dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test5\"), MVEL.eval(\"toUpperCase()\",\"test6\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))", "([MVEL.eval(\"toUpperCase()\",\"test5\"), MVEL.eval(\"toUpperCase()\",\"test6\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))");
        couldApply = this.itemProcessor.couldOrderItemMeetOfferRequirement((OfferItemCriteria)offers.get(0).getQualifyingItemCriteria().iterator().next(), (PromotableOrderItem)order.getDiscountableDiscreteOrderItems().get(0));
        ItemOfferProcessorTest.assertFalse((boolean)couldApply);
        this.verify();
    }

    public void testCouldOfferApplyToOrderItems() {
        this.replay();
        PromotableOrder order = this.dataProvider.createBasicOrder();
        List<Offer> offers = this.dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))", "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))");
        ArrayList<PromotableOrderItem> orderItems = new ArrayList<PromotableOrderItem>();
        for (PromotableOrderItem orderItem : order.getDiscountableDiscreteOrderItems()) {
            orderItems.add(orderItem);
        }
        CandidatePromotionItems candidates = this.itemProcessor.couldOfferApplyToOrderItems(offers.get(0), orderItems);
        ItemOfferProcessorTest.assertTrue((candidates.isMatchedQualifier() && candidates.getCandidateQualifiersMap().size() == 1 && ((List)candidates.getCandidateQualifiersMap().values().iterator().next()).size() == 2 && candidates.isMatchedTarget() && candidates.getCandidateTargets().size() == 2 ? 1 : 0) != 0);
        offers = this.dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test5\"), MVEL.eval(\"toUpperCase()\",\"test6\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))", "([MVEL.eval(\"toUpperCase()\",\"test5\"), MVEL.eval(\"toUpperCase()\",\"test6\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))");
        candidates = this.itemProcessor.couldOfferApplyToOrderItems(offers.get(0), orderItems);
        ItemOfferProcessorTest.assertFalse((candidates.isMatchedQualifier() && candidates.getCandidateQualifiersMap().size() == 1 ? 1 : 0) != 0);
        this.verify();
    }

    public void testApplyAllItemOffers() throws Exception {
        Answer answer = new Answer();
        Answer2 answer2 = new Answer2();
        EasyMock.expect((Object)this.offerDaoMock.createCandidateItemOffer()).andAnswer((IAnswer)answer).times(2);
        EasyMock.expect((Object)this.offerDaoMock.createOrderItemAdjustment()).andAnswer((IAnswer)answer2).times(4);
        EasyMock.expect((Object)this.cartServiceMock.addItemToFulfillmentGroup((OrderItem)EasyMock.isA(OrderItem.class), (FulfillmentGroup)EasyMock.isA(FulfillmentGroup.class), EasyMock.eq((boolean)false))).andAnswer(OfferDataItemProvider.getAddItemToFulfillmentGroupAnswer()).anyTimes();
        EasyMock.expect((Object)this.cartServiceMock.addOrderItemToOrder((Order)EasyMock.isA(Order.class), (OrderItem)EasyMock.isA(OrderItem.class), EasyMock.eq((boolean)false))).andAnswer(OfferDataItemProvider.getAddOrderItemToOrderAnswer()).anyTimes();
        EasyMock.expect((Object)this.cartServiceMock.removeItemFromOrder((Order)EasyMock.isA(Order.class), (OrderItem)EasyMock.isA(OrderItem.class), EasyMock.eq((boolean)false))).andAnswer(OfferDataItemProvider.getRemoveItemFromOrderAnswer()).anyTimes();
        EasyMock.expect((Object)this.orderItemServiceMock.saveOrderItem((OrderItem)EasyMock.isA(OrderItem.class))).andAnswer(OfferDataItemProvider.getSaveOrderItemAnswer()).anyTimes();
        EasyMock.expect((Object)this.fgItemDaoMock.save((FulfillmentGroupItem)EasyMock.isA(FulfillmentGroupItem.class))).andAnswer(OfferDataItemProvider.getSaveFulfillmentGroupItemAnswer()).anyTimes();
        this.replay();
        PromotableOrder order = this.dataProvider.createBasicOrder();
        Offer offer1 = this.dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))", "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))").get(0);
        offer1.setId(Long.valueOf(1L));
        ArrayList qualifiedOffers = new ArrayList();
        this.itemProcessor.filterItemLevelOffer(order, qualifiedOffers, offer1);
        boolean applied = this.itemProcessor.applyAllItemOffers(qualifiedOffers, order);
        ItemOfferProcessorTest.assertTrue((boolean)applied);
        order = this.dataProvider.createBasicOrder();
        qualifiedOffers = new ArrayList();
        offer1.setApplyDiscountToSalePrice(false);
        ((PromotableOrderItem)order.getDiscreteOrderItems().get(0)).getDelegate().setSalePrice(new Money(1.0));
        ((PromotableOrderItem)order.getDiscreteOrderItems().get(1)).getDelegate().setSalePrice(new Money(1.0));
        this.itemProcessor.filterItemLevelOffer(order, qualifiedOffers, offer1);
        applied = this.itemProcessor.applyAllItemOffers(qualifiedOffers, order);
        ItemOfferProcessorTest.assertFalse((boolean)applied);
        this.verify();
    }

    public void testApplyAdjustments() throws Exception {
        Answer answer = new Answer();
        Answer2 answer2 = new Answer2();
        EasyMock.expect((Object)this.offerDaoMock.createCandidateItemOffer()).andAnswer((IAnswer)answer).times(2);
        EasyMock.expect((Object)this.offerDaoMock.createOrderItemAdjustment()).andAnswer((IAnswer)answer2).times(7);
        this.replay();
        PromotableOrder order = this.dataProvider.createBasicOrder();
        Offer offer1 = this.dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))", "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))").get(0);
        offer1.setId(Long.valueOf(1L));
        offer1.getTargetItemCriteria().setQuantity(Integer.valueOf(2));
        offer1.setCombinableWithOtherOffers(false);
        Offer offer2 = this.dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))", "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))").get(0);
        offer2.setId(Long.valueOf(2L));
        ArrayList qualifiedOffers = new ArrayList();
        this.itemProcessor.filterItemLevelOffer(order, qualifiedOffers, offer1);
        ItemOfferProcessorTest.assertTrue((qualifiedOffers.size() == 1 && ((PromotableCandidateItemOffer)qualifiedOffers.get(0)).getOffer().equals(offer1) && ((PromotableCandidateItemOffer)qualifiedOffers.get(0)).getCandidateQualifiersMap().size() == 1 ? 1 : 0) != 0);
        this.itemProcessor.filterItemLevelOffer(order, qualifiedOffers, offer2);
        ItemOfferProcessorTest.assertTrue((qualifiedOffers.size() == 2 && ((PromotableCandidateItemOffer)qualifiedOffers.get(1)).getOffer().equals(offer2) && ((PromotableCandidateItemOffer)qualifiedOffers.get(1)).getCandidateQualifiersMap().size() == 1 ? 1 : 0) != 0);
        int appliedCount = this.itemProcessor.applyAdjustments(order, 0, (PromotableCandidateItemOffer)qualifiedOffers.get(0), 0);
        ItemOfferProcessorTest.assertTrue((appliedCount == 1 ? 1 : 0) != 0);
        appliedCount = this.itemProcessor.applyAdjustments(order, appliedCount, (PromotableCandidateItemOffer)qualifiedOffers.get(1), appliedCount);
        ItemOfferProcessorTest.assertTrue((appliedCount == 1 ? 1 : 0) != 0);
        order.removeAllAdjustments();
        offer1.setCombinableWithOtherOffers(true);
        appliedCount = this.itemProcessor.applyAdjustments(order, 0, (PromotableCandidateItemOffer)qualifiedOffers.get(0), 0);
        appliedCount = this.itemProcessor.applyAdjustments(order, appliedCount, (PromotableCandidateItemOffer)qualifiedOffers.get(1), appliedCount);
        ItemOfferProcessorTest.assertTrue((appliedCount == 2 ? 1 : 0) != 0);
        order.removeAllAdjustments();
        offer1.setCombinableWithOtherOffers(false);
        offer1.setApplyDiscountToSalePrice(false);
        ((PromotableOrderItem)order.getDiscreteOrderItems().get(1)).getDelegate().setSalePrice(new Money(10.0));
        appliedCount = this.itemProcessor.applyAdjustments(order, 0, (PromotableCandidateItemOffer)qualifiedOffers.get(0), 0);
        ItemOfferProcessorTest.assertTrue((appliedCount == 0 ? 1 : 0) != 0);
        appliedCount = this.itemProcessor.applyAdjustments(order, appliedCount, (PromotableCandidateItemOffer)qualifiedOffers.get(1), appliedCount);
        ItemOfferProcessorTest.assertTrue((appliedCount == 1 ? 1 : 0) != 0);
        order.removeAllAdjustments();
        offer1.setCombinableWithOtherOffers(true);
        ((PromotableOrderItem)order.getDiscreteOrderItems().get(1)).getDelegate().setSalePrice(null);
        offer2.setStackable(false);
        appliedCount = this.itemProcessor.applyAdjustments(order, 0, (PromotableCandidateItemOffer)qualifiedOffers.get(0), 0);
        ItemOfferProcessorTest.assertTrue((appliedCount == 1 ? 1 : 0) != 0);
        appliedCount = this.itemProcessor.applyAdjustments(order, appliedCount, (PromotableCandidateItemOffer)qualifiedOffers.get(1), appliedCount);
        ItemOfferProcessorTest.assertTrue((appliedCount == 2 ? 1 : 0) != 0);
        this.verify();
    }

    public void testApplyItemQualifiersAndTargets() throws Exception {
        Answer answer = new Answer();
        EasyMock.expect((Object)this.offerDaoMock.createCandidateItemOffer()).andAnswer((IAnswer)answer).times(3);
        this.replay();
        PromotableOrder order = this.dataProvider.createBasicOrder();
        ArrayList qualifiedOffers = new ArrayList();
        Offer offer1 = this.dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))", "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))").get(0);
        offer1.setId(Long.valueOf(1L));
        Offer offer2 = this.dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))", "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))").get(0);
        offer2.setId(Long.valueOf(2L));
        offer2.getTargetItemCriteria().setQuantity(Integer.valueOf(4));
        offer2.getQualifyingItemCriteria().clear();
        offer2.setOfferItemTargetRuleType(OfferItemRestrictionRuleType.TARGET);
        Offer offer3 = this.dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))", "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))").get(0);
        this.itemProcessor.filterItemLevelOffer(order, qualifiedOffers, offer1);
        ItemOfferProcessorTest.assertTrue((qualifiedOffers.size() == 1 && ((PromotableCandidateItemOffer)qualifiedOffers.get(0)).getOffer().equals(offer1) && ((PromotableCandidateItemOffer)qualifiedOffers.get(0)).getCandidateQualifiersMap().size() == 1 ? 1 : 0) != 0);
        this.itemProcessor.filterItemLevelOffer(order, qualifiedOffers, offer2);
        ItemOfferProcessorTest.assertTrue((qualifiedOffers.size() == 2 && ((PromotableCandidateItemOffer)qualifiedOffers.get(1)).getOffer().equals(offer2) && ((PromotableCandidateItemOffer)qualifiedOffers.get(1)).getCandidateQualifiersMap().size() == 0 ? 1 : 0) != 0);
        this.itemProcessor.filterItemLevelOffer(order, qualifiedOffers, offer3);
        ItemOfferProcessorTest.assertTrue((qualifiedOffers.size() == 3 && ((PromotableCandidateItemOffer)qualifiedOffers.get(2)).getOffer().equals(offer3) && ((PromotableCandidateItemOffer)qualifiedOffers.get(2)).getCandidateQualifiersMap().size() == 1 ? 1 : 0) != 0);
        this.itemProcessor.applyItemQualifiersAndTargets((PromotableCandidateItemOffer)qualifiedOffers.get(1), order);
        ArrayList<PromotableOrderItem> orderItems = new ArrayList<PromotableOrderItem>();
        for (PromotableOrderItem orderItem : order.getDiscountableDiscreteOrderItems()) {
            orderItems.add(orderItem);
        }
        int qualCount = 0;
        int targetCount = 0;
        for (PromotableOrderItem orderItem : orderItems) {
            for (PromotionDiscount discount : orderItem.getPromotionDiscounts()) {
                targetCount += discount.getQuantity();
            }
            for (PromotionQualifier qual : orderItem.getPromotionQualifiers()) {
                qualCount += qual.getQuantity();
            }
        }
        ItemOfferProcessorTest.assertTrue((qualCount == 0 && targetCount == 4 ? 1 : 0) != 0);
        ItemOfferProcessorTest.assertTrue((order.getAllSplitItems().size() == 3 ? 1 : 0) != 0);
        this.itemProcessor.applyItemQualifiersAndTargets((PromotableCandidateItemOffer)qualifiedOffers.get(0), order);
        qualCount = 0;
        targetCount = 0;
        for (PromotableOrderItem orderItem : orderItems) {
            for (PromotionDiscount discount : orderItem.getPromotionDiscounts()) {
                targetCount += discount.getQuantity();
            }
            for (PromotionQualifier qual : orderItem.getPromotionQualifiers()) {
                qualCount += qual.getQuantity();
            }
        }
        ItemOfferProcessorTest.assertTrue((qualCount == 1 && targetCount == 5 ? 1 : 0) != 0);
        ItemOfferProcessorTest.assertTrue((order.getSplitItems().size() == 2 && ((OrderItemSplitContainer)order.getSplitItems().get(0)).getSplitItems().size() == 2 && ((OrderItemSplitContainer)order.getSplitItems().get(1)).getSplitItems().size() == 2 ? 1 : 0) != 0);
        this.itemProcessor.applyItemQualifiersAndTargets((PromotableCandidateItemOffer)qualifiedOffers.get(2), order);
        qualCount = 0;
        targetCount = 0;
        for (PromotableOrderItem orderItem : orderItems) {
            for (PromotionDiscount discount : orderItem.getPromotionDiscounts()) {
                targetCount += discount.getQuantity();
            }
            for (PromotionQualifier qual : orderItem.getPromotionQualifiers()) {
                qualCount += qual.getQuantity();
            }
        }
        int promoCount = 0;
        List allSplitItems = order.getAllSplitItems();
        for (PromotableOrderItem item : allSplitItems) {
            promoCount += item.getPromotionDiscounts().size();
        }
        ItemOfferProcessorTest.assertTrue((qualCount == 1 && targetCount == 5 ? 1 : 0) != 0);
        ItemOfferProcessorTest.assertTrue((order.getSplitItems().size() == 2 && ((OrderItemSplitContainer)order.getSplitItems().get(0)).getSplitItems().size() == 2 && ((OrderItemSplitContainer)order.getSplitItems().get(1)).getSplitItems().size() == 2 ? 1 : 0) != 0);
        ItemOfferProcessorTest.assertTrue((promoCount == 4 ? 1 : 0) != 0);
        this.verify();
    }

    public class Answer2
    implements IAnswer<OrderItemAdjustment> {
        public OrderItemAdjustment answer() throws Throwable {
            return new OrderItemAdjustmentImpl();
        }
    }

    public class Answer
    implements IAnswer<CandidateItemOffer> {
        public CandidateItemOffer answer() throws Throwable {
            return new CandidateItemOfferImpl();
        }
    }
}

