/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.offer.dao.CustomerOfferDao;
import org.broadleafcommerce.core.offer.dao.OfferCodeDao;
import org.broadleafcommerce.core.offer.dao.OfferDao;
import org.broadleafcommerce.core.offer.domain.CandidateItemOffer;
import org.broadleafcommerce.core.offer.domain.CandidateItemOfferImpl;
import org.broadleafcommerce.core.offer.domain.CandidateOrderOffer;
import org.broadleafcommerce.core.offer.domain.CandidateOrderOfferImpl;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferRuleImpl;
import org.broadleafcommerce.core.offer.domain.OrderAdjustment;
import org.broadleafcommerce.core.offer.domain.OrderAdjustmentImpl;
import org.broadleafcommerce.core.offer.domain.OrderItemAdjustment;
import org.broadleafcommerce.core.offer.domain.OrderItemAdjustmentImpl;
import org.broadleafcommerce.core.offer.service.OfferDataItemProvider;
import org.broadleafcommerce.core.offer.service.OfferServiceImpl;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableItemFactory;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableItemFactoryImpl;
import org.broadleafcommerce.core.offer.service.processor.FulfillmentGroupOfferProcessor;
import org.broadleafcommerce.core.offer.service.processor.FulfillmentGroupOfferProcessorImpl;
import org.broadleafcommerce.core.offer.service.processor.ItemOfferProcessor;
import org.broadleafcommerce.core.offer.service.processor.ItemOfferProcessorImpl;
import org.broadleafcommerce.core.offer.service.processor.OrderOfferProcessor;
import org.broadleafcommerce.core.offer.service.processor.OrderOfferProcessorImpl;
import org.broadleafcommerce.core.offer.service.type.OfferDiscountType;
import org.broadleafcommerce.core.offer.service.type.OfferRuleType;
import org.broadleafcommerce.core.order.dao.FulfillmentGroupItemDao;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.CartService;
import org.broadleafcommerce.core.order.service.OrderItemService;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.easymock.IAnswer;
import org.easymock.classextension.EasyMock;

public class OfferServiceTest
extends TestCase {
    private OfferServiceImpl offerService;
    private CustomerOfferDao customerOfferDaoMock;
    private OfferCodeDao offerCodeDaoMock;
    private OfferDao offerDaoMock;
    private CartService cartServiceMock;
    private OrderItemService orderItemServiceMock;
    private FulfillmentGroupItemDao fgItemDaoMock;
    private OfferDataItemProvider dataProvider = new OfferDataItemProvider();

    protected void setUp() throws Exception {
        this.offerService = new OfferServiceImpl();
        this.customerOfferDaoMock = (CustomerOfferDao)EasyMock.createMock(CustomerOfferDao.class);
        this.offerCodeDaoMock = (OfferCodeDao)EasyMock.createMock(OfferCodeDao.class);
        this.offerDaoMock = (OfferDao)EasyMock.createMock(OfferDao.class);
        this.offerService.setCustomerOfferDao(this.customerOfferDaoMock);
        this.offerService.setOfferCodeDao(this.offerCodeDaoMock);
        this.offerService.setOfferDao(this.offerDaoMock);
        this.cartServiceMock = (CartService)EasyMock.createMock(CartService.class);
        this.orderItemServiceMock = (OrderItemService)EasyMock.createMock(OrderItemService.class);
        this.fgItemDaoMock = (FulfillmentGroupItemDao)EasyMock.createMock(FulfillmentGroupItemDao.class);
        OrderOfferProcessorImpl orderProcessor = new OrderOfferProcessorImpl();
        orderProcessor.setOfferDao(this.offerDaoMock);
        orderProcessor.setCartService(this.cartServiceMock);
        orderProcessor.setFulfillmentGroupItemDao(this.fgItemDaoMock);
        orderProcessor.setOrderItemService(this.orderItemServiceMock);
        orderProcessor.setPromotableItemFactory((PromotableItemFactory)new PromotableItemFactoryImpl());
        this.offerService.setOrderOfferProcessor((OrderOfferProcessor)orderProcessor);
        ItemOfferProcessorImpl itemProcessor = new ItemOfferProcessorImpl();
        itemProcessor.setOfferDao(this.offerDaoMock);
        itemProcessor.setCartService(this.cartServiceMock);
        itemProcessor.setFulfillmentGroupItemDao(this.fgItemDaoMock);
        itemProcessor.setOrderItemService(this.orderItemServiceMock);
        itemProcessor.setPromotableItemFactory((PromotableItemFactory)new PromotableItemFactoryImpl());
        this.offerService.setItemOfferProcessor((ItemOfferProcessor)itemProcessor);
        FulfillmentGroupOfferProcessorImpl fgProcessor = new FulfillmentGroupOfferProcessorImpl();
        fgProcessor.setOfferDao(this.offerDaoMock);
        fgProcessor.setCartService(this.cartServiceMock);
        fgProcessor.setFulfillmentGroupItemDao(this.fgItemDaoMock);
        fgProcessor.setOrderItemService(this.orderItemServiceMock);
        fgProcessor.setPromotableItemFactory((PromotableItemFactory)new PromotableItemFactoryImpl());
        this.offerService.setFulfillmentGroupOfferProcessor((FulfillmentGroupOfferProcessor)fgProcessor);
        this.offerService.setPromotableItemFactory((PromotableItemFactory)new PromotableItemFactoryImpl());
    }

    public void replay() {
        EasyMock.replay((Object[])new Object[]{this.customerOfferDaoMock});
        EasyMock.replay((Object[])new Object[]{this.offerCodeDaoMock});
        EasyMock.replay((Object[])new Object[]{this.offerDaoMock});
        EasyMock.replay((Object[])new Object[]{this.cartServiceMock});
        EasyMock.replay((Object[])new Object[]{this.orderItemServiceMock});
        EasyMock.replay((Object[])new Object[]{this.fgItemDaoMock});
    }

    public void verify() {
        EasyMock.verify((Object[])new Object[]{this.customerOfferDaoMock});
        EasyMock.verify((Object[])new Object[]{this.offerCodeDaoMock});
        EasyMock.verify((Object[])new Object[]{this.offerDaoMock});
        EasyMock.verify((Object[])new Object[]{this.cartServiceMock});
        EasyMock.verify((Object[])new Object[]{this.orderItemServiceMock});
        EasyMock.verify((Object[])new Object[]{this.fgItemDaoMock});
    }

    public void testApplyOffersToOrder_Order() throws Exception {
        CandidateOrderOfferAnswer candidateOrderOfferAnswer = new CandidateOrderOfferAnswer();
        OrderAdjustmentAnswer orderAdjustmentAnswer = new OrderAdjustmentAnswer();
        EasyMock.expect((Object)this.offerDaoMock.createCandidateOrderOffer()).andAnswer((IAnswer)candidateOrderOfferAnswer).atLeastOnce();
        EasyMock.expect((Object)this.offerDaoMock.createOrderAdjustment()).andAnswer((IAnswer)orderAdjustmentAnswer).atLeastOnce();
        CandidateItemOfferAnswer candidateItemOfferAnswer = new CandidateItemOfferAnswer();
        OrderItemAdjustmentAnswer orderItemAdjustmentAnswer = new OrderItemAdjustmentAnswer();
        EasyMock.expect((Object)this.offerDaoMock.createCandidateItemOffer()).andAnswer((IAnswer)candidateItemOfferAnswer).atLeastOnce();
        EasyMock.expect((Object)this.offerDaoMock.createOrderItemAdjustment()).andAnswer((IAnswer)orderItemAdjustmentAnswer).atLeastOnce();
        EasyMock.expect((Object)this.cartServiceMock.addItemToFulfillmentGroup((OrderItem)EasyMock.isA(OrderItem.class), (FulfillmentGroup)EasyMock.isA(FulfillmentGroup.class), EasyMock.eq((boolean)false))).andAnswer(OfferDataItemProvider.getAddItemToFulfillmentGroupAnswer()).anyTimes();
        EasyMock.expect((Object)this.cartServiceMock.addOrderItemToOrder((Order)EasyMock.isA(Order.class), (OrderItem)EasyMock.isA(OrderItem.class), EasyMock.eq((boolean)false))).andAnswer(OfferDataItemProvider.getAddOrderItemToOrderAnswer()).anyTimes();
        EasyMock.expect((Object)this.cartServiceMock.removeItemFromOrder((Order)EasyMock.isA(Order.class), (OrderItem)EasyMock.isA(OrderItem.class), EasyMock.eq((boolean)false))).andAnswer(OfferDataItemProvider.getRemoveItemFromOrderAnswer()).anyTimes();
        EasyMock.expect((Object)this.orderItemServiceMock.saveOrderItem((OrderItem)EasyMock.isA(OrderItem.class))).andAnswer(OfferDataItemProvider.getSaveOrderItemAnswer()).anyTimes();
        EasyMock.expect((Object)this.fgItemDaoMock.save((FulfillmentGroupItem)EasyMock.isA(FulfillmentGroupItem.class))).andAnswer(OfferDataItemProvider.getSaveFulfillmentGroupItemAnswer()).anyTimes();
        this.replay();
        Order order = this.dataProvider.createBasicOrder().getDelegate();
        List<Offer> offers = this.dataProvider.createOrderBasedOffer("order.subTotal.getAmount()>126", OfferDiscountType.PERCENT_OFF);
        this.offerService.applyOffersToOrder(offers, order);
        int adjustmentCount = order.getOrderAdjustments().size();
        OfferServiceTest.assertTrue((adjustmentCount == 1 ? 1 : 0) != 0);
        OfferServiceTest.assertTrue((boolean)order.getSubTotal().subtract(order.getOrderAdjustmentsValue()).equals((Object)new Money(116.95)));
        order = this.dataProvider.createBasicOrder().getDelegate();
        offers = this.dataProvider.createOrderBasedOffer("order.subTotal.getAmount()>126", OfferDiscountType.PERCENT_OFF);
        List<Offer> offers2 = this.dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))", "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))");
        offers.addAll(offers2);
        this.offerService.applyOffersToOrder(offers, order);
        adjustmentCount = 0;
        for (OrderItem item : order.getOrderItems()) {
            if (item.getOrderItemAdjustments() == null) continue;
            adjustmentCount += item.getOrderItemAdjustments().size();
        }
        OfferServiceTest.assertTrue((adjustmentCount == 2 ? 1 : 0) != 0);
        adjustmentCount = order.getOrderAdjustments().size();
        OfferServiceTest.assertTrue((adjustmentCount == 0 ? 1 : 0) != 0);
        OfferServiceTest.assertTrue((boolean)order.getSubTotal().equals((Object)new Money(124.95)));
        order = this.dataProvider.createBasicOrder().getDelegate();
        OfferRuleImpl orderRule = new OfferRuleImpl();
        orderRule.setMatchRule("order.subTotal.getAmount()>124");
        offers.get(0).getOfferMatchRules().put(OfferRuleType.ORDER.getType(), orderRule);
        this.offerService.applyOffersToOrder(offers, order);
        adjustmentCount = 0;
        for (OrderItem item : order.getOrderItems()) {
            if (item.getOrderItemAdjustments() == null) continue;
            adjustmentCount += item.getOrderItemAdjustments().size();
        }
        OfferServiceTest.assertTrue((adjustmentCount == 2 ? 1 : 0) != 0);
        adjustmentCount = order.getOrderAdjustments().size();
        OfferServiceTest.assertTrue((adjustmentCount == 1 ? 1 : 0) != 0);
        OfferServiceTest.assertTrue((boolean)order.getSubTotal().subtract(order.getOrderAdjustmentsValue()).equals((Object)new Money(112.45)));
        OfferServiceTest.assertTrue((boolean)order.getSubTotal().equals((Object)new Money(124.95)));
        order = this.dataProvider.createBasicOrder().getDelegate();
        List<Offer> offers3 = this.dataProvider.createOrderBasedOffer("order.subTotal.getAmount()>20", OfferDiscountType.AMOUNT_OFF);
        offers.addAll(offers3);
        this.offerService.applyOffersToOrder(offers, order);
        adjustmentCount = order.getOrderAdjustments().size();
        OfferServiceTest.assertTrue((adjustmentCount == 2 ? 1 : 0) != 0);
        order = this.dataProvider.createBasicOrder().getDelegate();
        offers.get(0).setCombinableWithOtherOffers(false);
        this.offerService.applyOffersToOrder(offers, order);
        adjustmentCount = 0;
        for (OrderItem item : order.getOrderItems()) {
            if (item.getOrderItemAdjustments() == null) continue;
            adjustmentCount += item.getOrderItemAdjustments().size();
        }
        OfferServiceTest.assertTrue((adjustmentCount == 2 ? 1 : 0) != 0);
        adjustmentCount = order.getOrderAdjustments().size();
        OfferServiceTest.assertTrue((adjustmentCount == 1 ? 1 : 0) != 0);
        OfferServiceTest.assertTrue((boolean)order.getSubTotal().subtract(order.getOrderAdjustmentsValue()).equals((Object)new Money(112.45)));
        OfferServiceTest.assertTrue((boolean)order.getSubTotal().equals((Object)new Money(124.95)));
        order = this.dataProvider.createBasicOrder().getDelegate();
        offers.get(0).setTotalitarianOffer(Boolean.valueOf(true));
        this.offerService.applyOffersToOrder(offers, order);
        adjustmentCount = 0;
        for (OrderItem item : order.getOrderItems()) {
            if (item.getOrderItemAdjustments() == null) continue;
            adjustmentCount += item.getOrderItemAdjustments().size();
        }
        OfferServiceTest.assertTrue((adjustmentCount == 0 ? 1 : 0) != 0);
        adjustmentCount = order.getOrderAdjustments().size();
        OfferServiceTest.assertTrue((adjustmentCount == 1 ? 1 : 0) != 0);
        OfferServiceTest.assertTrue((boolean)order.getSubTotal().subtract(order.getOrderAdjustmentsValue()).equals((Object)new Money(116.95)));
        OfferServiceTest.assertTrue((boolean)order.getSubTotal().equals((Object)new Money(129.95)));
        order = this.dataProvider.createBasicOrder().getDelegate();
        offers.get(0).setValue(new BigDecimal(".05"));
        offers.get(2).setValue(new BigDecimal(".01"));
        offers.get(2).setDiscountType(OfferDiscountType.PERCENT_OFF);
        this.offerService.applyOffersToOrder(offers, order);
        adjustmentCount = 0;
        for (OrderItem item : order.getOrderItems()) {
            if (item.getOrderItemAdjustments() == null) continue;
            adjustmentCount += item.getOrderItemAdjustments().size();
        }
        OfferServiceTest.assertTrue((adjustmentCount == 2 ? 1 : 0) != 0);
        adjustmentCount = order.getOrderAdjustments().size();
        OfferServiceTest.assertTrue((adjustmentCount == 1 ? 1 : 0) != 0);
        OfferServiceTest.assertTrue((boolean)order.getSubTotal().subtract(order.getOrderAdjustmentsValue()).equals((Object)new Money(124.94)));
        OfferServiceTest.assertTrue((boolean)order.getSubTotal().equals((Object)new Money(124.95)));
        this.verify();
    }

    public void testApplyOffersToOrder_Items() throws Exception {
        CandidateItemOfferAnswer answer = new CandidateItemOfferAnswer();
        OrderItemAdjustmentAnswer answer2 = new OrderItemAdjustmentAnswer();
        EasyMock.expect((Object)this.offerDaoMock.createCandidateItemOffer()).andAnswer((IAnswer)answer).times(2);
        EasyMock.expect((Object)this.offerDaoMock.createOrderItemAdjustment()).andAnswer((IAnswer)answer2).times(2);
        EasyMock.expect((Object)this.cartServiceMock.addItemToFulfillmentGroup((OrderItem)EasyMock.isA(OrderItem.class), (FulfillmentGroup)EasyMock.isA(FulfillmentGroup.class), EasyMock.eq((boolean)false))).andAnswer(OfferDataItemProvider.getAddItemToFulfillmentGroupAnswer()).anyTimes();
        EasyMock.expect((Object)this.cartServiceMock.addOrderItemToOrder((Order)EasyMock.isA(Order.class), (OrderItem)EasyMock.isA(OrderItem.class), EasyMock.eq((boolean)false))).andAnswer(OfferDataItemProvider.getAddOrderItemToOrderAnswer()).anyTimes();
        EasyMock.expect((Object)this.cartServiceMock.removeItemFromOrder((Order)EasyMock.isA(Order.class), (OrderItem)EasyMock.isA(OrderItem.class), EasyMock.eq((boolean)false))).andAnswer(OfferDataItemProvider.getRemoveItemFromOrderAnswer()).anyTimes();
        EasyMock.expect((Object)this.orderItemServiceMock.saveOrderItem((OrderItem)EasyMock.isA(OrderItem.class))).andAnswer(OfferDataItemProvider.getSaveOrderItemAnswer()).anyTimes();
        EasyMock.expect((Object)this.fgItemDaoMock.save((FulfillmentGroupItem)EasyMock.isA(FulfillmentGroupItem.class))).andAnswer(OfferDataItemProvider.getSaveFulfillmentGroupItemAnswer()).anyTimes();
        this.replay();
        Order order = this.dataProvider.createBasicOrder().getDelegate();
        List<Offer> offers = this.dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))", "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))");
        this.offerService.applyOffersToOrder(offers, order);
        int adjustmentCount = 0;
        for (OrderItem item : order.getOrderItems()) {
            if (item.getOrderItemAdjustments() == null) continue;
            adjustmentCount += item.getOrderItemAdjustments().size();
        }
        OfferServiceTest.assertTrue((adjustmentCount == 2 ? 1 : 0) != 0);
        order = this.dataProvider.createBasicOrder().getDelegate();
        offers = this.dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))", "([MVEL.eval(\"toUpperCase()\",\"test5\"), MVEL.eval(\"toUpperCase()\",\"test6\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))");
        this.offerService.applyOffersToOrder(offers, order);
        adjustmentCount = 0;
        for (OrderItem item : order.getOrderItems()) {
            if (item.getOrderItemAdjustments() == null) continue;
            adjustmentCount += item.getOrderItemAdjustments().size();
        }
        OfferServiceTest.assertTrue((adjustmentCount == 0 ? 1 : 0) != 0);
        this.verify();
    }

    public void testBuildOfferListForOrder() throws Exception {
        EasyMock.expect((Object)this.customerOfferDaoMock.readCustomerOffersByCustomer((Customer)EasyMock.isA(Customer.class))).andReturn(new ArrayList());
        EasyMock.expect((Object)this.offerDaoMock.readOffersByAutomaticDeliveryType()).andReturn(this.dataProvider.createCustomerBasedOffer(null, this.dataProvider.yesterday(), this.dataProvider.tomorrow(), OfferDiscountType.PERCENT_OFF));
        this.replay();
        Order order = this.dataProvider.createBasicOrder().getDelegate();
        List offers = this.offerService.buildOfferListForOrder(order);
        OfferServiceTest.assertTrue((offers.size() == 1 ? 1 : 0) != 0);
        this.verify();
    }

    public class OrderAdjustmentAnswer
    implements IAnswer<OrderAdjustment> {
        public OrderAdjustment answer() throws Throwable {
            return new OrderAdjustmentImpl();
        }
    }

    public class CandidateOrderOfferAnswer
    implements IAnswer<CandidateOrderOffer> {
        public CandidateOrderOffer answer() throws Throwable {
            return new CandidateOrderOfferImpl();
        }
    }

    public class OrderItemAdjustmentAnswer
    implements IAnswer<OrderItemAdjustment> {
        public OrderItemAdjustment answer() throws Throwable {
            return new OrderItemAdjustmentImpl();
        }
    }

    public class CandidateItemOfferAnswer
    implements IAnswer<CandidateItemOffer> {
        public CandidateItemOffer answer() throws Throwable {
            return new CandidateItemOfferImpl();
        }
    }
}

