/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.order.security;

import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.util.BLCSystemProperty;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.OrderLockManager;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.web.order.CartState;
import org.broadleafcommerce.core.web.order.security.CartStateRequestProcessor;
import org.broadleafcommerce.core.web.order.security.exception.OrderLockAcquisitionFailureException;
import org.springframework.core.Ordered;
import org.springframework.security.web.util.AntPathRequestMatcher;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.filter.OncePerRequestFilter;

@Component(value="blCartStateFilter")
public class CartStateFilter
extends OncePerRequestFilter
implements Ordered {
    protected static final Log LOG = LogFactory.getLog(CartStateFilter.class);
    @Resource(name="blCartStateRequestProcessor")
    protected CartStateRequestProcessor cartStateProcessor;
    @Resource(name="blOrderLockManager")
    protected OrderLockManager orderLockManager;
    @Resource(name="blOrderService")
    protected OrderService orderService;
    protected List<String> excludedOrderLockRequestPatterns;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        Order order;
        block12: {
            this.cartStateProcessor.process((WebRequest)new ServletWebRequest(request, response));
            if (!this.requestRequiresLock((ServletRequest)request)) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            order = CartState.getCart();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Thread[" + Thread.currentThread().getId() + "] attempting to lock order[" + order.getId() + "]"));
            }
            Object lockObject = null;
            try {
                if (lockObject == null) {
                    if (this.getErrorInsteadOfQueue()) {
                        lockObject = this.orderLockManager.acquireLockIfAvailable(order);
                        if (lockObject == null) {
                            throw new OrderLockAcquisitionFailureException("Thread[" + Thread.currentThread().getId() + "] could not acquire lock for order[" + order.getId() + "]");
                        }
                    } else {
                        lockObject = this.orderLockManager.acquireLock(order);
                    }
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Thread[" + Thread.currentThread().getId() + "] grabbed lock for order[" + order.getId() + "]"));
                }
                CartState.setCart(this.orderService.reloadOrder(order));
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                if (lockObject == null) break block12;
            }
            catch (Throwable throwable) {
                if (lockObject != null) {
                    this.orderLockManager.releaseLock(lockObject);
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Thread[" + Thread.currentThread().getId() + "] released lock for order[" + order.getId() + "]"));
                }
                throw throwable;
            }
            this.orderLockManager.releaseLock(lockObject);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Thread[" + Thread.currentThread().getId() + "] released lock for order[" + order.getId() + "]"));
        }
    }

    protected boolean requestRequiresLock(ServletRequest req) {
        if (!(req instanceof HttpServletRequest)) {
            return false;
        }
        if (!this.orderLockManager.isActive()) {
            return false;
        }
        HttpServletRequest request = (HttpServletRequest)req;
        if (!request.getMethod().equalsIgnoreCase("post")) {
            return false;
        }
        if (this.excludedOrderLockRequestPatterns != null && this.excludedOrderLockRequestPatterns.size() > 0) {
            for (String pattern : this.excludedOrderLockRequestPatterns) {
                AntPathRequestMatcher matcher = new AntPathRequestMatcher(pattern);
                if (!matcher.matches(request)) continue;
                return false;
            }
        }
        return true;
    }

    public int getOrder() {
        return 1502;
    }

    public List<String> getExcludedOrderLockRequestPatterns() {
        return this.excludedOrderLockRequestPatterns;
    }

    public void setExcludedOrderLockRequestPatterns(List<String> excludedOrderLockRequestPatterns) {
        this.excludedOrderLockRequestPatterns = excludedOrderLockRequestPatterns;
    }

    protected boolean getErrorInsteadOfQueue() {
        return BLCSystemProperty.resolveBooleanSystemProperty((String)"order.lock.errorInsteadOfQueue");
    }

    protected boolean shouldNotFilterErrorDispatch() {
        return false;
    }
}

