/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.breadcrumbs;

import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.broadleafcommerce.common.breadcrumbs.dto.BreadcrumbDTO;
import org.broadleafcommerce.common.breadcrumbs.dto.BreadcrumbDTOType;
import org.broadleafcommerce.common.breadcrumbs.service.BreadcrumbServiceExtensionManager;
import org.broadleafcommerce.common.extension.ExtensionHandler;
import org.broadleafcommerce.common.extension.ExtensionResultHolder;
import org.broadleafcommerce.common.extension.ExtensionResultStatusType;
import org.broadleafcommerce.core.web.breadcrumbs.AbstractBreadcrumbServiceExtensionHandler;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="blHomePageBreadcrumbServiceExtensionHandler")
public class HomePageBreadcrumbServiceExtensionHandler
extends AbstractBreadcrumbServiceExtensionHandler {
    @Value(value="${breadcrumb.homepageText:Home}")
    protected String homePageText;
    @Resource(name="blBreadcrumbServiceExtensionManager")
    protected BreadcrumbServiceExtensionManager extensionManager;

    @PostConstruct
    public void init() {
        if (this.isEnabled()) {
            this.extensionManager.registerHandler((ExtensionHandler)this);
        }
    }

    @Override
    public ExtensionResultStatusType modifyBreadcrumbList(String url, Map<String, String[]> params, ExtensionResultHolder<List<BreadcrumbDTO>> holder) {
        BreadcrumbDTO homePageDto = new BreadcrumbDTO();
        homePageDto.setText(this.homePageText);
        homePageDto.setLink("/");
        homePageDto.setType(BreadcrumbDTOType.HOME);
        ((List)holder.getResult()).add(0, homePageDto);
        return ExtensionResultStatusType.HANDLED_CONTINUE;
    }

    @Override
    public int getDefaultPriority() {
        return -1000;
    }
}

