/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.breadcrumbs;

import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.utils.URIBuilder;
import org.broadleafcommerce.common.breadcrumbs.dto.BreadcrumbDTO;
import org.broadleafcommerce.common.breadcrumbs.service.BreadcrumbServiceExtensionHandler;
import org.broadleafcommerce.common.extension.ExtensionHandler;
import org.broadleafcommerce.common.extension.ExtensionResultHolder;
import org.broadleafcommerce.common.extension.ExtensionResultStatusType;

public abstract class AbstractBreadcrumbServiceExtensionHandler
implements ExtensionHandler,
BreadcrumbServiceExtensionHandler {
    private static final Log LOG = LogFactory.getLog(AbstractBreadcrumbServiceExtensionHandler.class);
    protected Integer priority;
    protected boolean enabled = true;

    public ExtensionResultStatusType modifyBreadcrumbList(String url, Map<String, String[]> params, ExtensionResultHolder<List<BreadcrumbDTO>> holder) {
        return ExtensionResultStatusType.HANDLED_CONTINUE;
    }

    public int getPriority() {
        if (this.priority == null) {
            return this.getDefaultPriority();
        }
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String buildLink(String url, Map<String, String[]> params) {
        try {
            URIBuilder builder = new URIBuilder(url);
            if (params != null) {
                for (String key : params.keySet()) {
                    String[] paramValues;
                    for (String value : paramValues = params.get(key)) {
                        builder.addParameter(key, value);
                    }
                }
            }
            return builder.build().toString();
        }
        catch (URISyntaxException e) {
            LOG.error((Object)"Error creating link for breadcrumb ", (Throwable)e);
            return url;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public abstract int getDefaultPriority();
}

