/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.processor;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.common.web.dialect.AbstractModelVariableModifierProcessor;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.PromotableProduct;
import org.broadleafcommerce.core.catalog.domain.RelatedProductDTO;
import org.broadleafcommerce.core.catalog.domain.RelatedProductTypeEnum;
import org.broadleafcommerce.core.catalog.service.RelatedProductsService;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.dom.Element;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.StandardExpressions;

public class RelatedProductProcessor
extends AbstractModelVariableModifierProcessor {
    @Resource(name="blRelatedProductsService")
    protected RelatedProductsService relatedProductsService;

    public RelatedProductProcessor() {
        super("related_products");
    }

    public int getPrecedence() {
        return 10000;
    }

    protected void modifyModelAttributes(Arguments arguments, Element element) {
        List relatedProducts = this.relatedProductsService.findRelatedProducts(this.buildDTO(arguments, element));
        this.addToModel(arguments, this.getRelatedProductsResultVar(element), relatedProducts);
        this.addToModel(arguments, this.getProductsResultVar(element), this.convertRelatedProductsToProducts(relatedProducts));
        this.addCollectionToExistingSet(arguments, "blcAllProducts", this.buildProductList(relatedProducts));
    }

    protected List<Product> buildProductList(List<? extends PromotableProduct> relatedProducts) {
        ArrayList<Product> productList = new ArrayList<Product>();
        if (relatedProducts != null) {
            for (PromotableProduct promotableProduct : relatedProducts) {
                productList.add(promotableProduct.getRelatedProduct());
            }
        }
        return productList;
    }

    protected List<Product> convertRelatedProductsToProducts(List<? extends PromotableProduct> relatedProducts) {
        ArrayList<Product> products = new ArrayList<Product>();
        if (relatedProducts != null) {
            for (PromotableProduct promotableProduct : relatedProducts) {
                products.add(promotableProduct.getRelatedProduct());
            }
        }
        return products;
    }

    private String getRelatedProductsResultVar(Element element) {
        String resultVar = element.getAttributeValue("relatedProductsResultVar");
        if (resultVar == null) {
            resultVar = "relatedProducts";
        }
        return resultVar;
    }

    private String getProductsResultVar(Element element) {
        String resultVar = element.getAttributeValue("productsResultVar");
        if (resultVar == null) {
            resultVar = "products";
        }
        return resultVar;
    }

    private RelatedProductDTO buildDTO(Arguments args, Element element) {
        Expression expression;
        RelatedProductDTO relatedProductDTO = new RelatedProductDTO();
        String productIdStr = element.getAttributeValue("productId");
        String categoryIdStr = element.getAttributeValue("categoryId");
        String quantityStr = element.getAttributeValue("quantity");
        String typeStr = element.getAttributeValue("type");
        if (productIdStr != null) {
            expression = (Expression)StandardExpressions.getExpressionParser((Configuration)args.getConfiguration()).parseExpression(args.getConfiguration(), (IProcessingContext)args, productIdStr);
            Object productId = expression.execute(args.getConfiguration(), (IProcessingContext)args);
            if (productId instanceof BigDecimal) {
                productId = new Long(((BigDecimal)productId).toPlainString());
            }
            relatedProductDTO.setProductId((Long)productId);
        }
        if (categoryIdStr != null) {
            expression = (Expression)StandardExpressions.getExpressionParser((Configuration)args.getConfiguration()).parseExpression(args.getConfiguration(), (IProcessingContext)args, categoryIdStr);
            Object categoryId = expression.execute(args.getConfiguration(), (IProcessingContext)args);
            if (categoryId instanceof BigDecimal) {
                categoryId = new Long(((BigDecimal)categoryId).toPlainString());
            }
            relatedProductDTO.setCategoryId((Long)categoryId);
        }
        if (quantityStr != null) {
            expression = (Expression)StandardExpressions.getExpressionParser((Configuration)args.getConfiguration()).parseExpression(args.getConfiguration(), (IProcessingContext)args, quantityStr);
            int quantity = ((BigDecimal)expression.execute(args.getConfiguration(), (IProcessingContext)args)).intValue();
            relatedProductDTO.setQuantity(Integer.valueOf(quantity));
        }
        if (typeStr != null && RelatedProductTypeEnum.getInstance((String)typeStr) != null) {
            relatedProductDTO.setType(RelatedProductTypeEnum.getInstance((String)typeStr));
        }
        if ("false".equalsIgnoreCase(element.getAttributeValue("cumulativeResults"))) {
            relatedProductDTO.setCumulativeResults(false);
        }
        return relatedProductDTO;
    }
}

