/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.controller.account;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.broadleafcommerce.common.exception.ServiceException;
import org.broadleafcommerce.core.order.domain.NullOrderImpl;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.core.web.controller.account.BroadleafRegisterController;
import org.broadleafcommerce.core.web.order.CartState;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.web.core.form.RegisterCustomerForm;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.UserProfile;
import org.springframework.social.connect.web.ProviderSignInUtils;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.ServletWebRequest;

public class BroadleafSocialRegisterController
extends BroadleafRegisterController {
    @Override
    public String register(RegisterCustomerForm registerCustomerForm, HttpServletRequest request, HttpServletResponse response, Model model) {
        Connection connection = ProviderSignInUtils.getConnection((RequestAttributes)new ServletWebRequest(request));
        if (connection != null) {
            UserProfile userProfile = connection.fetchUserProfile();
            Customer customer = registerCustomerForm.getCustomer();
            customer.setFirstName(userProfile.getFirstName());
            customer.setLastName(userProfile.getLastName());
            customer.setEmailAddress(userProfile.getEmail());
            if (this.isUseEmailForLogin()) {
                customer.setUsername(userProfile.getEmail());
            } else {
                customer.setUsername(userProfile.getUsername());
            }
        }
        return super.register(registerCustomerForm, request, response, model);
    }

    @Override
    public String processRegister(RegisterCustomerForm registerCustomerForm, BindingResult errors, HttpServletRequest request, HttpServletResponse response, Model model) throws ServiceException, PricingException {
        if (this.isUseEmailForLogin()) {
            Customer customer = registerCustomerForm.getCustomer();
            customer.setUsername(customer.getEmailAddress());
        }
        this.registerCustomerValidator.validate((Object)registerCustomerForm, (Errors)errors, this.isUseEmailForLogin());
        if (!errors.hasErrors()) {
            String redirectUrl;
            Customer newCustomer = this.customerService.registerCustomer(registerCustomerForm.getCustomer(), registerCustomerForm.getPassword(), registerCustomerForm.getPasswordConfirm());
            assert (newCustomer != null);
            ProviderSignInUtils.handlePostSignUp((String)newCustomer.getUsername(), (RequestAttributes)new ServletWebRequest(request));
            this.loginService.loginCustomer(registerCustomerForm.getCustomer());
            Order cart = CartState.getCart();
            if (cart != null && !(cart instanceof NullOrderImpl) && cart.getEmailAddress() == null) {
                cart.setEmailAddress(newCustomer.getEmailAddress());
                this.orderService.save(cart, Boolean.valueOf(false));
            }
            if (StringUtils.isNotBlank((String)(redirectUrl = registerCustomerForm.getRedirectUrl())) && redirectUrl.contains(":")) {
                redirectUrl = null;
            }
            return StringUtils.isBlank((String)redirectUrl) ? this.getRegisterSuccessView() : "redirect:" + redirectUrl;
        }
        return this.getRegisterView();
    }
}

