/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api.wrapper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.money.util.CurrencyAdapter;
import org.broadleafcommerce.common.payment.PaymentTransactionType;
import org.broadleafcommerce.common.util.xml.BigDecimalRoundingAdapter;
import org.broadleafcommerce.core.payment.domain.PaymentTransaction;
import org.broadleafcommerce.core.payment.service.OrderPaymentService;
import org.broadleafcommerce.core.web.api.wrapper.APIUnwrapper;
import org.broadleafcommerce.core.web.api.wrapper.APIWrapper;
import org.broadleafcommerce.core.web.api.wrapper.BaseWrapper;
import org.broadleafcommerce.core.web.api.wrapper.MapElementWrapper;
import org.springframework.context.ApplicationContext;

@XmlRootElement(name="transaction")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PaymentTransactionWrapper
extends BaseWrapper
implements APIWrapper<PaymentTransaction>,
APIUnwrapper<PaymentTransaction> {
    @XmlElement
    protected Long id;
    @XmlElement
    protected Long orderPaymentId;
    @XmlElement
    protected Long parentTransactionId;
    @XmlElement
    protected String type;
    @XmlElement
    protected String customerIpAddress;
    @XmlElement
    protected String rawResponse;
    @XmlElement
    protected Boolean success;
    @XmlElement
    @XmlJavaTypeAdapter(value=BigDecimalRoundingAdapter.class)
    protected BigDecimal amount;
    @XmlElement
    @XmlJavaTypeAdapter(value=CurrencyAdapter.class)
    protected Currency currency;
    @XmlElement(name="element")
    @XmlElementWrapper(name="additionalFields")
    protected List<MapElementWrapper> additionalFields;

    @Override
    public void wrapDetails(PaymentTransaction model, HttpServletRequest request) {
        this.id = model.getId();
        if (model.getOrderPayment() != null) {
            this.orderPaymentId = model.getOrderPayment().getId();
        }
        if (model.getParentTransaction() != null) {
            this.parentTransactionId = model.getParentTransaction().getId();
        }
        if (model.getType() != null) {
            this.type = model.getType().getType();
        }
        this.customerIpAddress = model.getCustomerIpAddress();
        this.rawResponse = model.getRawResponse();
        this.success = model.getSuccess();
        if (model.getAmount() != null) {
            this.amount = model.getAmount().getAmount();
            this.currency = model.getAmount().getCurrency();
        }
        if (model.getAdditionalFields() != null && !model.getAdditionalFields().isEmpty()) {
            ArrayList<MapElementWrapper> mapElementWrappers = new ArrayList<MapElementWrapper>();
            for (String key : model.getAdditionalFields().keySet()) {
                MapElementWrapper mapElementWrapper = new MapElementWrapper();
                mapElementWrapper.setKey(key);
                mapElementWrapper.setValue((String)model.getAdditionalFields().get(key));
                mapElementWrappers.add(mapElementWrapper);
            }
            this.additionalFields = mapElementWrappers;
        }
    }

    @Override
    public void wrapSummary(PaymentTransaction model, HttpServletRequest request) {
        this.wrapDetails(model, request);
    }

    @Override
    public PaymentTransaction unwrap(HttpServletRequest request, ApplicationContext context) {
        OrderPaymentService orderPaymentService = (OrderPaymentService)context.getBean("blOrderPaymentService");
        PaymentTransaction transaction = orderPaymentService.createTransaction();
        if (this.parentTransactionId != null) {
            PaymentTransaction parentTransaction = orderPaymentService.readTransactionById(this.parentTransactionId);
            transaction.setParentTransaction(parentTransaction);
        }
        transaction.setType(PaymentTransactionType.getInstance((String)this.type));
        if (this.additionalFields != null && !this.additionalFields.isEmpty()) {
            HashMap<String, String> fields = new HashMap<String, String>();
            for (MapElementWrapper mapElementWrapper : this.additionalFields) {
                fields.put(mapElementWrapper.getKey(), mapElementWrapper.getValue());
            }
            transaction.setAdditionalFields(fields);
        }
        if (this.amount != null) {
            if (this.currency != null) {
                transaction.setAmount(new Money(this.amount, this.currency));
            } else {
                transaction.setAmount(new Money(this.amount));
            }
        }
        transaction.setCustomerIpAddress(this.customerIpAddress);
        transaction.setRawResponse(this.rawResponse);
        transaction.setSuccess(this.success);
        return transaction;
    }
}

