/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api.wrapper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.broadleafcommerce.common.exception.ServiceException;
import org.broadleafcommerce.common.util.xml.ISO8601DateAdapter;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.CategoryAttribute;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.service.CatalogService;
import org.broadleafcommerce.core.search.domain.ProductSearchCriteria;
import org.broadleafcommerce.core.search.domain.ProductSearchResult;
import org.broadleafcommerce.core.search.service.SearchService;
import org.broadleafcommerce.core.web.api.BroadleafWebServicesException;
import org.broadleafcommerce.core.web.api.wrapper.APIWrapper;
import org.broadleafcommerce.core.web.api.wrapper.BaseWrapper;
import org.broadleafcommerce.core.web.api.wrapper.CategoryAttributeWrapper;
import org.broadleafcommerce.core.web.api.wrapper.ProductWrapper;

@XmlRootElement(name="category")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CategoryWrapper
extends BaseWrapper
implements APIWrapper<Category> {
    @XmlElement
    protected Long id;
    @XmlElement
    protected String name;
    @XmlElement
    protected String description;
    @XmlElement
    protected Boolean active;
    @XmlElement
    protected String url;
    @XmlElement
    protected String urlKey;
    @XmlElement
    @XmlJavaTypeAdapter(value=ISO8601DateAdapter.class)
    protected Date activeStartDate;
    @XmlElement
    @XmlJavaTypeAdapter(value=ISO8601DateAdapter.class)
    protected Date activeEndDate;
    @XmlElement(name="category")
    @XmlElementWrapper(name="subcategories")
    protected List<CategoryWrapper> subcategories;
    @XmlElement(name="product")
    @XmlElementWrapper(name="products")
    protected List<ProductWrapper> products;
    @XmlElement(name="categoryAttribute")
    @XmlElementWrapper(name="categoryAttributes")
    protected List<CategoryAttributeWrapper> categoryAttributes;

    @Override
    public void wrapDetails(Category category, HttpServletRequest request) {
        this.id = category.getId();
        this.name = category.getName();
        this.description = category.getDescription();
        this.active = category.isActive();
        this.activeStartDate = category.getActiveStartDate();
        this.activeEndDate = category.getActiveEndDate();
        this.url = category.getUrl();
        this.urlKey = category.getUrlKey();
        if (category.getCategoryAttributes() != null && !category.getCategoryAttributes().isEmpty()) {
            this.categoryAttributes = new ArrayList<CategoryAttributeWrapper>();
            for (CategoryAttribute attribute : category.getCategoryAttributes()) {
                CategoryAttributeWrapper wrapper = (CategoryAttributeWrapper)this.context.getBean(CategoryAttributeWrapper.class.getName());
                wrapper.wrapSummary(attribute, request);
                this.categoryAttributes.add(wrapper);
            }
        }
        Integer productLimit = (Integer)request.getAttribute("productLimit");
        Integer productOffset = (Integer)request.getAttribute("productOffset");
        Integer subcategoryLimit = (Integer)request.getAttribute("subcategoryLimit");
        Integer subcategoryOffset = (Integer)request.getAttribute("subcategoryOffset");
        if (productLimit != null && productOffset == null) {
            productOffset = 1;
        }
        if (subcategoryLimit != null && subcategoryOffset == null) {
            subcategoryOffset = 1;
        }
        if (productLimit != null && productOffset != null) {
            SearchService searchService = this.getSearchService();
            ProductSearchCriteria searchCriteria = new ProductSearchCriteria();
            searchCriteria.setPage(productOffset);
            searchCriteria.setPageSize(productLimit);
            searchCriteria.setFilterCriteria(new HashMap());
            try {
                ProductSearchResult result = searchService.findExplicitProductsByCategory(category, searchCriteria);
                List productList = result.getProducts();
                if (productList != null && !productList.isEmpty()) {
                    if (this.products == null) {
                        this.products = new ArrayList<ProductWrapper>();
                    }
                    for (Product p : productList) {
                        ProductWrapper productSummaryWrapper = (ProductWrapper)this.context.getBean(ProductWrapper.class.getName());
                        productSummaryWrapper.wrapSummary(p, request);
                        this.products.add(productSummaryWrapper);
                    }
                }
            }
            catch (ServiceException e) {
                throw BroadleafWebServicesException.build(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), null, null, e);
            }
        }
        if (subcategoryLimit != null && subcategoryOffset != null) {
            this.subcategories = this.buildSubcategoryTree(this.subcategories, category, request);
        }
    }

    @Override
    public void wrapSummary(Category category, HttpServletRequest request) {
        this.id = category.getId();
        this.name = category.getName();
        this.description = category.getDescription();
        this.active = category.isActive();
    }

    protected List<CategoryWrapper> buildSubcategoryTree(List<CategoryWrapper> wrappers, Category root, HttpServletRequest request) {
        CatalogService catalogService = (CatalogService)this.context.getBean("blCatalogService");
        Integer subcategoryLimit = (Integer)request.getAttribute("subcategoryLimit");
        Integer subcategoryOffset = (Integer)request.getAttribute("subcategoryOffset");
        List subcategories = catalogService.findActiveSubCategoriesByCategory(root, subcategoryLimit.intValue(), subcategoryOffset.intValue());
        if (subcategories != null && !subcategories.isEmpty() && wrappers == null) {
            wrappers = new ArrayList<CategoryWrapper>();
        }
        for (Category c : subcategories) {
            CategoryWrapper subcategoryWrapper = (CategoryWrapper)this.context.getBean(CategoryWrapper.class.getName());
            subcategoryWrapper.wrapSummary(c, request);
            wrappers.add(subcategoryWrapper);
        }
        return wrappers;
    }

    protected SearchService getSearchService() {
        return (SearchService)this.context.getBean("blSearchService");
    }
}

