/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.controller.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.search.domain.SearchIntercept;
import org.broadleafcommerce.core.search.domain.SearchQuery;
import org.broadleafcommerce.core.search.service.SearchService;
import org.broadleafcommerce.core.web.search.SearchFilterUtil;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/search"})
public class SearchController {
    @Resource(name="blSearchService")
    private SearchService searchService;

    @RequestMapping(method={RequestMethod.GET})
    public String blank(ModelMap model, HttpServletRequest request) {
        return "search";
    }

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST})
    public String search(ModelMap model, HttpServletRequest request, @RequestParam(required=true) String queryString, @RequestParam(required=false) String originalQueryString, @RequestParam(required=false) Boolean ajax) {
        SearchQuery input = new SearchQuery();
        input.setQueryString(queryString);
        SearchIntercept intercept = this.searchService.getInterceptForTerm(queryString);
        if (intercept != null) {
            return "redirect:" + intercept.getRedirect();
        }
        List products = null;
        products = this.searchService.performSearch(input.getQueryString());
        SearchFilterUtil.filterProducts(products, request.getParameterMap(), new String[]{"manufacturer", "defaultCategory.id", "skus[0].salePrice"});
        model.addAttribute("queryString", (Object)input.getQueryString());
        model.addAttribute("products", (Object)products);
        ArrayList<Category> categories = new ArrayList<Category>();
        HashMap categoryGroups = new HashMap();
        for (Product prod : products) {
            Category cat = prod.getDefaultCategory();
            if (!categoryGroups.containsKey(cat.getId())) {
                categories.add(cat);
                categoryGroups.put(cat.getId(), new ArrayList());
            }
            ((List)categoryGroups.get(cat.getId())).add(prod);
        }
        model.addAttribute("categories", categories);
        model.addAttribute("categoryGroups", categoryGroups);
        if (ajax == null || !ajax.booleanValue() || originalQueryString != null && !originalQueryString.equals(queryString)) {
            return "search";
        }
        return "searchAjax";
    }

    public SearchService getSearchService() {
        return this.searchService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }
}

