/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.catalog.taglib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.web.catalog.taglib.CategoryLinkTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryBreadCrumbTag
extends CategoryLinkTag {
    private static final Log LOG = LogFactory.getLog(CategoryBreadCrumbTag.class);
    private static final long serialVersionUID = 1L;
    private Long categoryId;
    private List<Category> categoryList = new ArrayList<Category>();

    @Override
    public void doTag() throws JspException, IOException {
        if (this.categoryId == null && this.categoryList == null) {
            throw new RuntimeException("Either categoryId or categoryList is required for this tag");
        }
        if (this.categoryId != null) {
            Category category = this.getCatalogService().findCategoryById(this.categoryId);
            if (category == null && LOG.isDebugEnabled()) {
                LOG.debug((Object)("The category returned was null for categoryId: " + this.categoryId));
            }
            while (category != null) {
                this.categoryList.add(category);
                category = category.getDefaultParentCategory();
            }
            Collections.reverse(this.categoryList);
        }
        JspWriter out = this.getJspContext().getOut();
        int count = 0;
        for (Category cat : this.categoryList) {
            out.println(this.getUrl(cat));
            if (count < this.categoryList.size() - 1) {
                out.println(" > ");
            }
            ++count;
        }
    }

    public void setCategoryList(List<Category> categoryList) {
        this.categoryList = categoryList;
    }

    public void setCategoryId(long categoryId) {
        this.categoryId = categoryId;
    }
}

