/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.time;

import java.util.GregorianCalendar;
import junit.framework.TestCase;
import org.broadleafcommerce.common.time.SystemTime;
import org.broadleafcommerce.common.time.TimeSource;
import org.easymock.EasyMock;

public class SystemTimeTest
extends TestCase {
    private TimeSource mockTimeSource;

    protected void setUp() throws Exception {
        super.setUp();
        this.mockTimeSource = (TimeSource)EasyMock.createMock(TimeSource.class);
    }

    protected void tearDown() throws Exception {
        SystemTime.reset();
        super.tearDown();
    }

    public void testSetGlobalTimeSource() {
        EasyMock.expect((Object)this.mockTimeSource.timeInMillis()).andReturn((Object)100L).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.mockTimeSource});
        SystemTime.setGlobalTimeSource((TimeSource)this.mockTimeSource);
        SystemTimeTest.assertEquals((long)100L, (long)SystemTime.asMillis());
        EasyMock.verify((Object[])new Object[0]);
    }

    public void testResetGlobalTimeSource() {
        EasyMock.expect((Object)this.mockTimeSource.timeInMillis()).andReturn((Object)200L).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockTimeSource});
        SystemTime.setGlobalTimeSource((TimeSource)this.mockTimeSource);
        SystemTime.resetGlobalTimeSource();
        SystemTimeTest.assertTrue((200L != SystemTime.asMillis() ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[0]);
    }

    public void testSetLocalTimeSource() {
        EasyMock.expect((Object)this.mockTimeSource.timeInMillis()).andReturn((Object)300L).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.mockTimeSource});
        SystemTime.setLocalTimeSource((TimeSource)this.mockTimeSource);
        SystemTimeTest.assertEquals((long)300L, (long)SystemTime.asMillis());
        EasyMock.verify((Object[])new Object[0]);
    }

    public void testResetLocalTimeSource() {
        EasyMock.expect((Object)this.mockTimeSource.timeInMillis()).andReturn((Object)400L).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockTimeSource});
        SystemTime.setLocalTimeSource((TimeSource)this.mockTimeSource);
        SystemTime.resetLocalTimeSource();
        SystemTimeTest.assertTrue((400L != SystemTime.asMillis() ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[0]);
    }

    public void testLocalOverridesGlobal() {
        TimeSource mockLocalTimeSource = (TimeSource)EasyMock.createMock(TimeSource.class);
        EasyMock.expect((Object)this.mockTimeSource.timeInMillis()).andReturn((Object)500L).anyTimes();
        EasyMock.expect((Object)mockLocalTimeSource.timeInMillis()).andReturn((Object)600L).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.mockTimeSource, mockLocalTimeSource});
        SystemTime.setGlobalTimeSource((TimeSource)this.mockTimeSource);
        SystemTime.setLocalTimeSource((TimeSource)mockLocalTimeSource);
        SystemTimeTest.assertEquals((long)600L, (long)SystemTime.asMillis());
        SystemTime.resetLocalTimeSource();
        SystemTimeTest.assertEquals((long)500L, (long)SystemTime.asMillis());
        EasyMock.verify((Object[])new Object[0]);
    }

    public void testReset() {
        TimeSource mockLocalTimeSource = (TimeSource)EasyMock.createMock(TimeSource.class);
        EasyMock.expect((Object)this.mockTimeSource.timeInMillis()).andReturn((Object)700L).anyTimes();
        EasyMock.expect((Object)mockLocalTimeSource.timeInMillis()).andReturn((Object)800L).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockTimeSource, mockLocalTimeSource});
        SystemTime.setGlobalTimeSource((TimeSource)this.mockTimeSource);
        SystemTime.setLocalTimeSource((TimeSource)mockLocalTimeSource);
        SystemTime.reset();
        SystemTimeTest.assertTrue((SystemTime.asMillis() > 800L ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[0]);
    }

    public void testAsMillis() {
        EasyMock.expect((Object)this.mockTimeSource.timeInMillis()).andReturn((Object)1000L).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.mockTimeSource});
        SystemTime.setGlobalTimeSource((TimeSource)this.mockTimeSource);
        SystemTimeTest.assertEquals((long)1000L, (long)SystemTime.asMillis());
        EasyMock.verify((Object[])new Object[0]);
    }

    public void testAsDate() {
        EasyMock.expect((Object)this.mockTimeSource.timeInMillis()).andReturn((Object)1100L).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.mockTimeSource});
        SystemTime.setGlobalTimeSource((TimeSource)this.mockTimeSource);
        SystemTimeTest.assertEquals((long)1100L, (long)SystemTime.asDate().getTime());
        EasyMock.verify((Object[])new Object[0]);
    }

    public void testAsCalendar() {
        EasyMock.expect((Object)this.mockTimeSource.timeInMillis()).andReturn((Object)1200L).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.mockTimeSource});
        SystemTime.setGlobalTimeSource((TimeSource)this.mockTimeSource);
        SystemTimeTest.assertEquals((long)1200L, (long)SystemTime.asCalendar().getTimeInMillis());
        EasyMock.verify((Object[])new Object[0]);
    }

    public void testAsMillisBoolean() {
        GregorianCalendar cal = new GregorianCalendar(2010, 1, 2, 3, 4, 5);
        long timeInMillis = cal.getTimeInMillis() + 3L;
        EasyMock.expect((Object)this.mockTimeSource.timeInMillis()).andReturn((Object)timeInMillis).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.mockTimeSource});
        SystemTime.setGlobalTimeSource((TimeSource)this.mockTimeSource);
        GregorianCalendar calMidnight = new GregorianCalendar(2010, 1, 2, 0, 0, 0);
        calMidnight.set(14, 0);
        SystemTimeTest.assertEquals((long)calMidnight.getTimeInMillis(), (long)SystemTime.asMillis((boolean)false));
        SystemTimeTest.assertEquals((long)timeInMillis, (long)SystemTime.asMillis((boolean)true));
        EasyMock.verify((Object[])new Object[0]);
    }

    public void testAsCalendarBoolean() {
        GregorianCalendar cal = new GregorianCalendar(2010, 1, 2, 3, 4, 5);
        cal.set(14, 3);
        EasyMock.expect((Object)this.mockTimeSource.timeInMillis()).andReturn((Object)cal.getTimeInMillis()).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.mockTimeSource});
        SystemTime.setGlobalTimeSource((TimeSource)this.mockTimeSource);
        GregorianCalendar calMidnight = new GregorianCalendar(2010, 1, 2, 0, 0, 0);
        calMidnight.set(14, 0);
        SystemTimeTest.assertEquals((Object)calMidnight, (Object)SystemTime.asCalendar((boolean)false));
        SystemTimeTest.assertEquals((Object)cal, (Object)SystemTime.asCalendar((boolean)true));
        EasyMock.verify((Object[])new Object[0]);
    }

    public void testAsDateBoolean() {
        GregorianCalendar cal = new GregorianCalendar(2010, 1, 2, 3, 4, 5);
        cal.set(14, 3);
        EasyMock.expect((Object)this.mockTimeSource.timeInMillis()).andReturn((Object)cal.getTimeInMillis()).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.mockTimeSource});
        SystemTime.setGlobalTimeSource((TimeSource)this.mockTimeSource);
        GregorianCalendar calMidnight = new GregorianCalendar(2010, 1, 2, 0, 0, 0);
        calMidnight.set(14, 0);
        SystemTimeTest.assertEquals((long)calMidnight.getTimeInMillis(), (long)SystemTime.asDate((boolean)false).getTime());
        SystemTimeTest.assertEquals((long)cal.getTimeInMillis(), (long)SystemTime.asDate((boolean)true).getTime());
        EasyMock.verify((Object[])new Object[0]);
    }
}

