/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.authorizenet.service.payment.type;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.broadleafcommerce.common.BroadleafEnumerationType;

public class AuthorizeNetTransactionType
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, AuthorizeNetTransactionType> TYPES = new HashMap<String, AuthorizeNetTransactionType>();
    public static final AuthorizeNetTransactionType AUTHORIZE = new AuthorizeNetTransactionType("AUTHORIZE", "Authorize");
    public static final AuthorizeNetTransactionType CAPTURE = new AuthorizeNetTransactionType("CAPTURE", "Capture");
    public static final AuthorizeNetTransactionType AUTHORIZEANDCAPTURE = new AuthorizeNetTransactionType("AUTHORIZEANDCAPTURE", "Authorize and Capture");
    public static final AuthorizeNetTransactionType CREDIT = new AuthorizeNetTransactionType("CREDIT", "Credit");
    public static final AuthorizeNetTransactionType VOIDTRANSACTION = new AuthorizeNetTransactionType("VOIDTRANSACTION", "Void Transaction");
    public static final AuthorizeNetTransactionType REVERSEAUTHORIZE = new AuthorizeNetTransactionType("REVERSEAUTHORIZE", "Reverse Authorize");
    public static final AuthorizeNetTransactionType CREATE_SUBSCRIPTION = new AuthorizeNetTransactionType("CREATE_SUBSCRIPTION", "Create Subscription");
    public static final AuthorizeNetTransactionType UPDATE_SUBSCRIPTION = new AuthorizeNetTransactionType("UPDATE_SUBSCRIPTION", "Update Subscription");
    public static final AuthorizeNetTransactionType CANCEL_SUBSCRIPTION = new AuthorizeNetTransactionType("CANCEL_SUBSCRIPTION", "Cancel Subscription");
    private String type;
    private String friendlyType;

    public static AuthorizeNetTransactionType getInstance(String type) {
        return TYPES.get(type);
    }

    public AuthorizeNetTransactionType() {
    }

    public AuthorizeNetTransactionType(String type, String friendlyType) {
        this.friendlyType = friendlyType;
        this.setType(type);
    }

    public String getType() {
        return this.type;
    }

    public String getFriendlyType() {
        return this.friendlyType;
    }

    private void setType(String type) {
        this.type = type;
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuthorizeNetTransactionType other = (AuthorizeNetTransactionType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

