/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.payment.service.gateway;

import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import net.authorize.AuthNetField;
import net.authorize.Environment;
import net.authorize.Merchant;
import net.authorize.api.contract.v1.CreateCustomerPaymentProfileRequest;
import net.authorize.api.contract.v1.CreateCustomerPaymentProfileResponse;
import net.authorize.api.contract.v1.CreateCustomerProfileRequest;
import net.authorize.api.contract.v1.CreateCustomerProfileResponse;
import net.authorize.api.contract.v1.CustomerAddressType;
import net.authorize.api.contract.v1.CustomerPaymentProfileType;
import net.authorize.api.contract.v1.CustomerProfileType;
import net.authorize.api.contract.v1.CustomerTypeEnum;
import net.authorize.api.contract.v1.MerchantAuthenticationType;
import net.authorize.api.contract.v1.MessageTypeEnum;
import net.authorize.api.contract.v1.OpaqueDataType;
import net.authorize.api.contract.v1.TransactionRequestType;
import net.authorize.api.contract.v1.ValidationModeEnum;
import net.authorize.api.controller.CreateCustomerPaymentProfileController;
import net.authorize.api.controller.CreateCustomerProfileController;
import net.authorize.api.controller.base.ApiOperationBase;
import net.authorize.cim.Result;
import net.authorize.cim.Transaction;
import net.authorize.cim.TransactionType;
import net.authorize.util.BasicXmlDocument;
import net.authorize.util.HttpClient;
import net.authorize.xml.Message;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.broadleafcommerce.common.payment.PaymentType;
import org.broadleafcommerce.common.payment.dto.AddressDTO;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.common.payment.dto.PaymentResponseDTO;
import org.broadleafcommerce.common.payment.service.AbstractPaymentGatewayCustomerService;
import org.broadleafcommerce.common.payment.service.PaymentGatewayCustomerService;
import org.broadleafcommerce.common.vendor.service.exception.PaymentException;
import org.broadleafcommerce.payment.service.gateway.AuthorizeNetConfiguration;
import org.broadleafcommerce.vendor.authorizenet.service.payment.AuthorizeNetGatewayType;
import org.broadleafcommerce.vendor.authorizenet.service.payment.type.MessageConstants;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.w3c.dom.Element;

@Service(value="blAuthorizeNetCustomerService")
public class AuthorizeNetCustomerService
extends AbstractPaymentGatewayCustomerService
implements PaymentGatewayCustomerService {
    @Resource(name="blAuthorizeNetConfiguration")
    protected AuthorizeNetConfiguration configuration;

    public PaymentResponseDTO createGatewayCustomer(PaymentRequestDTO requestDTO) throws PaymentException {
        Environment e = Environment.createEnvironment((String)this.configuration.getServerUrl(), (String)this.configuration.getXMLBaseUrl());
        Merchant merchant = Merchant.createMerchant((Environment)e, (String)this.configuration.getLoginId(), (String)this.configuration.getTransactionKey());
        Assert.isTrue((boolean)requestDTO.getAdditionalFields().containsKey(AuthNetField.X_TRANS_ID.getFieldName()), (String)"Must pass 'x_trans_id' value on the additionalFields of the Payment Request DTO");
        String previousTransId = (String)requestDTO.getAdditionalFields().get(AuthNetField.X_TRANS_ID.getFieldName());
        PaymentType requestPaymentType = requestDTO.getPaymentType() == null ? PaymentType.CREDIT_CARD : requestDTO.getPaymentType();
        PaymentResponseDTO paymentResponse = new PaymentResponseDTO(requestPaymentType, AuthorizeNetGatewayType.AUTHORIZENET);
        if (requestDTO.getAdditionalFields().get("OPAQUE_DATA_DESCRIPTOR") != null) {
            TransactionRequestType transaction = new TransactionRequestType();
            ApiOperationBase.setEnvironment((Environment)Environment.SANDBOX);
            MerchantAuthenticationType merchantAuthenticationType = new MerchantAuthenticationType();
            merchantAuthenticationType.setName(this.configuration.getLoginId());
            merchantAuthenticationType.setTransactionKey(this.configuration.getTransactionKey());
            ApiOperationBase.setMerchantAuthentication((MerchantAuthenticationType)merchantAuthenticationType);
            net.authorize.api.contract.v1.PaymentType paymentType = new net.authorize.api.contract.v1.PaymentType();
            OpaqueDataType data = new OpaqueDataType();
            data.setDataDescriptor((String)requestDTO.getAdditionalFields().get("OPAQUE_DATA_DESCRIPTOR"));
            data.setDataValue((String)requestDTO.getAdditionalFields().get("OPAQUE_DATA_VALUE"));
            paymentType.setOpaqueData(data);
            AddressDTO billing = requestDTO.getBillTo();
            CustomerAddressType customerAddress = new CustomerAddressType();
            customerAddress.setFirstName(billing.getAddressFirstName());
            customerAddress.setLastName(billing.getAddressLastName());
            customerAddress.setAddress(billing.getAddressLine1());
            customerAddress.setCity(billing.getAddressCityLocality());
            customerAddress.setState(billing.getAddressStateRegion());
            customerAddress.setZip(billing.getAddressPostalCode());
            customerAddress.setCountry(billing.getAddressCountryCode());
            customerAddress.setPhoneNumber(billing.getAddressPhone());
            if (!requestDTO.getBillTo().getAddressEmail().isEmpty()) {
                customerAddress.setEmail(requestDTO.getBillTo().getAddressEmail());
            } else {
                customerAddress.setEmail(requestDTO.getCustomer().getEmail());
            }
            CustomerPaymentProfileType customerPaymentProfileType = new CustomerPaymentProfileType();
            customerPaymentProfileType.setCustomerType(CustomerTypeEnum.INDIVIDUAL);
            customerPaymentProfileType.setPayment(paymentType);
            customerPaymentProfileType.setBillTo(customerAddress);
            CustomerProfileType customerProfileType = new CustomerProfileType();
            customerProfileType.setMerchantCustomerId("M_" + requestDTO.getCustomer().getCustomerId());
            customerProfileType.setDescription("Profile description for " + requestDTO.getBillTo().getAddressEmail());
            if (!requestDTO.getBillTo().getAddressEmail().isEmpty()) {
                customerProfileType.setEmail(requestDTO.getBillTo().getAddressEmail());
            } else {
                customerProfileType.setEmail(requestDTO.getCustomer().getEmail());
            }
            customerProfileType.getPaymentProfiles().add(customerPaymentProfileType);
            CreateCustomerProfileRequest apiCreateCustomerProfileRequest = new CreateCustomerProfileRequest();
            apiCreateCustomerProfileRequest.setProfile(customerProfileType);
            if (this.configuration.getXTestRequest().isEmpty()) {
                apiCreateCustomerProfileRequest.setValidationMode(ValidationModeEnum.LIVE_MODE);
            } else {
                apiCreateCustomerProfileRequest.setValidationMode(ValidationModeEnum.TEST_MODE);
            }
            CreateCustomerProfileController controller = new CreateCustomerProfileController(apiCreateCustomerProfileRequest);
            controller.execute();
            CreateCustomerProfileResponse response = (CreateCustomerProfileResponse)controller.getApiResponse();
            CreateCustomerPaymentProfileRequest apiCreateCustomerPaymentProfileRequest = new CreateCustomerPaymentProfileRequest();
            apiCreateCustomerPaymentProfileRequest.setMerchantAuthentication(merchantAuthenticationType);
            apiCreateCustomerPaymentProfileRequest.setCustomerProfileId(response.getCustomerProfileId());
            net.authorize.api.contract.v1.PaymentType customerPaymentType = new net.authorize.api.contract.v1.PaymentType();
            OpaqueDataType opaqueData = new OpaqueDataType();
            opaqueData.setDataDescriptor((String)requestDTO.getAdditionalFields().get("OPAQUE_DATA_DESCRIPTOR"));
            opaqueData.setDataValue((String)requestDTO.getAdditionalFields().get("OPAQUE_DATA_VALUE"));
            customerPaymentType.setOpaqueData(opaqueData);
            CustomerPaymentProfileType profile = new CustomerPaymentProfileType();
            profile.setBillTo(customerAddress);
            profile.setPayment(customerPaymentType);
            apiCreateCustomerPaymentProfileRequest.setPaymentProfile(profile);
            CreateCustomerPaymentProfileController cCPPcontroller = new CreateCustomerPaymentProfileController(apiCreateCustomerPaymentProfileRequest);
            cCPPcontroller.execute();
            CreateCustomerPaymentProfileResponse cCPPresponse = new CreateCustomerPaymentProfileResponse();
            cCPPresponse = (CreateCustomerPaymentProfileResponse)cCPPcontroller.getApiResponse();
            paymentResponse.successful(response.getMessages().getResultCode().equals((Object)MessageTypeEnum.OK) && cCPPresponse.getMessages().getResultCode().equals((Object)MessageTypeEnum.OK));
            paymentResponse.responseMap(MessageConstants.CUSTOMER_PROFILE_ID, response.getCustomerProfileId());
            paymentResponse.responseMap(MessageConstants.PAYMENT_PROFILE_ID, cCPPresponse.getCustomerPaymentProfileId());
            for (String fieldKey : requestDTO.getAdditionalFields().keySet()) {
                paymentResponse.responseMap(fieldKey, (String)requestDTO.getAdditionalFields().get(fieldKey));
            }
        } else {
            BasicXmlDocument gatewayResponse = this.createCustomerFromTransaction(previousTransId, merchant, e);
            Transaction fakeTransaction = Transaction.createTransaction((Merchant)merchant, (TransactionType)TransactionType.CREATE_CUSTOMER_PAYMENT_PROFILE);
            Transaction responseTransaction = Transaction.createTransaction((Transaction)fakeTransaction, (BasicXmlDocument)gatewayResponse);
            Result result = Result.createResult((Object)responseTransaction, (BasicXmlDocument)gatewayResponse);
            paymentResponse.rawResponse(((Transaction)result.getTarget()).getCurrentResponse().dump());
            paymentResponse.successful(result.isOk());
            if (result.isOk()) {
                paymentResponse.responseMap(MessageConstants.CUSTOMER_PROFILE_ID, result.getCustomerProfileId());
                paymentResponse.responseMap(MessageConstants.PAYMENT_PROFILE_ID, (String)result.getCustomerPaymentProfileIdList().get(0));
            } else {
                ArrayList messages = result.getMessages();
                if (CollectionUtils.isNotEmpty((Collection)messages)) {
                    paymentResponse.responseMap("Error", ((Message)messages.get(0)).getCode());
                } else {
                    paymentResponse.responseMap("Error", result.getResultCode());
                }
            }
        }
        return paymentResponse;
    }

    protected Merchant getAuthorizenetMerchant(PaymentRequestDTO paymentRequestDTO) {
        Environment env = Environment.createEnvironment((String)this.configuration.getServerUrl(), (String)this.configuration.getXMLBaseUrl());
        Merchant merchant = Merchant.createMerchant((Environment)env, (String)this.configuration.getLoginId(), (String)this.configuration.getTransactionKey());
        return merchant;
    }

    protected MerchantAuthenticationType getMerchantAuthentication(PaymentRequestDTO paymentRequestDTO) {
        MerchantAuthenticationType merchantAuthenticationType = new MerchantAuthenticationType();
        merchantAuthenticationType.setName(this.configuration.getLoginId());
        merchantAuthenticationType.setTransactionKey(this.configuration.getTransactionKey());
        return merchantAuthenticationType;
    }

    public PaymentResponseDTO updateGatewayCustomer(PaymentRequestDTO requestDTO) throws PaymentException {
        return null;
    }

    public PaymentResponseDTO deleteGatewayCustomer(PaymentRequestDTO requestDTO) throws PaymentException {
        return null;
    }

    protected PaymentResponseDTO commonCustomerRequest(PaymentRequestDTO requestDTO) throws PaymentException {
        return null;
    }

    protected BasicXmlDocument createCustomerFromTransaction(String transactionId, Merchant merchant, Environment env) {
        BasicXmlDocument request = new BasicXmlDocument();
        request.parseString("<createCustomerProfileFromTransactionRequest xmlns = \"" + Transaction.XML_NAMESPACE + "\" />");
        Element auth_el = request.createElement(AuthNetField.ELEMENT_MERCHANT_AUTHENTICATION.getFieldName());
        Element name_el = request.createElement(AuthNetField.ELEMENT_NAME.getFieldName());
        name_el.appendChild(request.getDocument().createTextNode(merchant.getLogin()));
        Element trans_key = request.createElement(AuthNetField.ELEMENT_TRANSACTION_KEY.getFieldName());
        trans_key.appendChild(request.getDocument().createTextNode(merchant.getTransactionKey()));
        auth_el.appendChild(name_el);
        auth_el.appendChild(trans_key);
        request.getDocumentElement().appendChild(auth_el);
        Element transIdElement = request.createElement(AuthNetField.ELEMENT_TRANS_ID.getFieldName());
        transIdElement.appendChild(request.getDocument().createTextNode(transactionId));
        request.getDocumentElement().appendChild(transIdElement);
        BasicXmlDocument response = new BasicXmlDocument();
        try {
            int mark;
            String rawResponseString;
            DefaultHttpClient httpClient = new DefaultHttpClient();
            HttpClient.setProxyIfRequested((DefaultHttpClient)httpClient);
            URI postUrl = new URI(env.getXmlBaseUrl() + "/xml/v1/request.api");
            HttpPost httpPost = new HttpPost(postUrl);
            httpPost.setHeader("Content-Type", "text/xml; charset=utf-8");
            httpPost.setEntity((HttpEntity)new StringEntity(request.dump()));
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            if (httpResponse != null && httpResponse.getStatusLine().getStatusCode() == 200) {
                HttpEntity entity = httpResponse.getEntity();
                InputStream instream = entity.getContent();
                rawResponseString = HttpClient.convertStreamToString((InputStream)instream);
            } else {
                StringBuilder responseBuilder = new StringBuilder();
                responseBuilder.append("<?xml version=\"1.0\" ?>");
                responseBuilder.append("<messages><resultCode>Error</resultCode>");
                responseBuilder.append("<message><code>E00001</code>");
                responseBuilder.append("<text>");
                responseBuilder.append(httpResponse != null ? httpResponse.getStatusLine().getReasonPhrase() : "");
                responseBuilder.append("</text></message></messages>");
                rawResponseString = responseBuilder.toString();
            }
            httpClient.getConnectionManager().shutdown();
            if (rawResponseString == null) {
                return null;
            }
            if (Environment.SANDBOX.equals((Object)env)) {
                // empty if block
            }
            if ((mark = rawResponseString.indexOf("<?xml")) == -1) {
                return null;
            }
            response.parseString(rawResponseString.substring(mark, rawResponseString.length()));
            if (!response.IsAccessible()) {
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return response;
    }
}

