/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.payment.service.gateway;

import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Resource;
import org.broadleafcommerce.common.config.service.SystemPropertiesService;
import org.broadleafcommerce.common.payment.PaymentGatewayType;
import org.broadleafcommerce.common.payment.service.AbstractPaymentGatewayConfiguration;
import org.broadleafcommerce.common.web.BaseUrlResolver;
import org.broadleafcommerce.payment.service.gateway.AuthorizeNetConfiguration;
import org.broadleafcommerce.vendor.authorizenet.service.payment.AuthorizeNetGatewayType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="blAuthorizeNetConfiguration")
public class AuthorizeNetConfigurationImpl
extends AbstractPaymentGatewayConfiguration
implements AuthorizeNetConfiguration {
    @Resource(name="blBaseUrlResolver")
    protected BaseUrlResolver urlResolver;
    @Autowired
    @Qualifier(value="blSystemPropertiesService")
    protected SystemPropertiesService propertiesService;
    protected int failureReportingThreshold = 1;
    protected boolean performAuthorizeAndCapture = true;

    @Override
    public String getLoginId() {
        return this.propertiesService.resolveSystemProperty("gateway.authorizenet.loginId");
    }

    @Override
    public String getClientKey() {
        return this.propertiesService.resolveSystemProperty("gateway.authorizenet.clientKey");
    }

    @Override
    public String getTransactionKey() {
        return this.propertiesService.resolveSystemProperty("gateway.authorizenet.transactionKey");
    }

    @Override
    @Deprecated
    public String getMd5Key() {
        return this.propertiesService.resolveSystemProperty("gateway.authorizenet.merchantMd5Key");
    }

    @Override
    public String getTransactionVersion() {
        return this.propertiesService.resolveSystemProperty("gateway.authorizenet.transactionVersion");
    }

    @Override
    public String getResponseUrl() {
        String url = this.propertiesService.resolveSystemProperty("gateway.authorizenet.responseUrl");
        try {
            URI u = new URI(url);
            if (u.isAbsolute()) {
                return url;
            }
            String baseUrl = this.urlResolver.getSiteBaseUrl();
            return baseUrl + url;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("The value for 'gateway.authorizenet.responseUrl' is not valid.", e);
        }
    }

    @Override
    public String getConfirmUrl() {
        String url = this.propertiesService.resolveSystemProperty("gateway.authorizenet.confirmUrl");
        try {
            URI u = new URI(url);
            if (u.isAbsolute()) {
                return url;
            }
            String baseUrl = this.urlResolver.getSiteBaseUrl();
            return baseUrl + url;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("The value for 'gateway.authorizenet.confirmUrl' is not valid.", e);
        }
    }

    @Override
    public String getErrorUrl() {
        String url = this.propertiesService.resolveSystemProperty("gateway.authorizenet.errorUrl");
        try {
            URI u = new URI(url);
            if (u.isAbsolute()) {
                return url;
            }
            String baseUrl = this.urlResolver.getSiteBaseUrl();
            return baseUrl + url;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("The value for 'gateway.authorizenet.errorUrl' is not valid.", e);
        }
    }

    @Override
    public String getServerUrl() {
        return this.propertiesService.resolveSystemProperty("gateway.authorizenet.serverUrl");
    }

    @Override
    public String getXMLBaseUrl() {
        return this.getServerUrl().replace("/gateway/transact.dll", "").replace("test", "apitest").replace("secure", "api");
    }

    @Override
    public String getXTestRequest() {
        return this.propertiesService.resolveSystemProperty("gateway.authorizenet.xTestRequest");
    }

    public boolean isPerformAuthorizeAndCapture() {
        return this.performAuthorizeAndCapture;
    }

    public void setPerformAuthorizeAndCapture(boolean performAuthorizeAndCapture) {
        this.performAuthorizeAndCapture = performAuthorizeAndCapture;
    }

    public int getFailureReportingThreshold() {
        return this.failureReportingThreshold;
    }

    public void setFailureReportingThreshold(int failureReportingThreshold) {
        this.failureReportingThreshold = failureReportingThreshold;
    }

    public boolean handlesAuthorize() {
        return true;
    }

    public boolean handlesCapture() {
        return true;
    }

    public boolean handlesAuthorizeAndCapture() {
        return true;
    }

    public boolean handlesReverseAuthorize() {
        return true;
    }

    public boolean handlesVoid() {
        return true;
    }

    public boolean handlesRefund() {
        return true;
    }

    public boolean handlesPartialCapture() {
        return false;
    }

    public boolean handlesMultipleShipment() {
        return false;
    }

    public boolean handlesRecurringPayment() {
        return false;
    }

    public boolean handlesSavedCustomerPayment() {
        return false;
    }

    public boolean handlesMultiplePayments() {
        return false;
    }

    public PaymentGatewayType getGatewayType() {
        return AuthorizeNetGatewayType.AUTHORIZENET;
    }

    @Override
    public Boolean isSandbox() {
        return this.propertiesService.resolveBooleanSystemProperty("gateway.authorizenet.sandbox", true);
    }

    @Override
    public String getAcceptJsUrl() {
        return this.propertiesService.resolveSystemProperty("gateway.authorizenet.acceptJsUrl", "https://js.authorize.net/v1/Accept.js");
    }

    @Override
    public String getGatewayMerchantId() {
        return this.propertiesService.resolveSystemProperty("gateway.authorizenet.gatewayMerchantId");
    }

    @Override
    public String getAppleMerchantId() {
        return this.propertiesService.resolveSystemProperty("gateway.authorizenet.apple.merchantId");
    }

    @Override
    public String getAppleKeyStoreFilePath() {
        return this.propertiesService.resolveSystemProperty("gateway.authorizenet.apple.keyStoreFilePath");
    }

    @Override
    public String getAppleKeyStorePassword() {
        return this.propertiesService.resolveSystemProperty("gateway.authorizenet.apple.keyStorePassword");
    }

    @Override
    public String getVerifiedDomainName() {
        return this.propertiesService.resolveSystemProperty("gateway.authorizenet.apple.verifiedDomainName");
    }

    @Override
    public String getVerifiedDomainDisplayName() {
        return this.propertiesService.resolveSystemProperty("gateway.authorizenet.apple.verifiedDomainDisplayName");
    }
}

