/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.authorizenet.web.controller;

import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.authorize.sim.Result;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.common.payment.dto.PaymentResponseDTO;
import org.broadleafcommerce.common.payment.service.PaymentGatewayConfiguration;
import org.broadleafcommerce.common.payment.service.PaymentGatewayTransactionService;
import org.broadleafcommerce.common.payment.service.PaymentGatewayWebResponsePrintService;
import org.broadleafcommerce.common.payment.service.PaymentGatewayWebResponseService;
import org.broadleafcommerce.common.vendor.service.exception.PaymentException;
import org.broadleafcommerce.common.web.payment.controller.PaymentGatewayAbstractController;
import org.broadleafcommerce.payment.service.gateway.AuthorizeNetConfiguration;
import org.broadleafcommerce.vendor.authorizenet.service.payment.AuthorizeNetCheckoutService;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Deprecated
@Controller(value="blAuthorizeNetController")
@RequestMapping(value={"/authorizenet"})
public class BroadleafAuthorizeNetController
extends PaymentGatewayAbstractController {
    protected static final Log LOG = LogFactory.getLog(BroadleafAuthorizeNetController.class);
    protected static final String GATEWAY_CONTEXT_KEY = "authorizenet";
    @Resource(name="blAuthorizeNetWebResponseService")
    protected PaymentGatewayWebResponseService paymentGatewayWebResponseService;
    @Resource(name="blAuthorizeNetCheckoutService")
    protected AuthorizeNetCheckoutService authorizeNetCheckoutService;
    @Resource(name="blAuthorizeNetConfiguration")
    protected AuthorizeNetConfiguration configuration;
    @Resource(name="blPaymentGatewayWebResponsePrintService")
    protected PaymentGatewayWebResponsePrintService webResponsePrintService;
    @Resource(name="blAuthorizeNetTransactionService")
    protected PaymentGatewayTransactionService transactionService;

    public String getGatewayContextKey() {
        return GATEWAY_CONTEXT_KEY;
    }

    public void handleProcessingException(Exception e, RedirectAttributes redirectAttributes) throws PaymentException {
        throw new PaymentException((Throwable)e);
    }

    public void handleUnsuccessfulTransaction(Model model, RedirectAttributes redirectAttributes, PaymentResponseDTO responseDTO) throws PaymentException {
        LOG.trace((Object)"A Processing Exception Occurred for authorizenet. Adding Error to Redirect Attributes.");
        redirectAttributes.addAttribute("PAYMENT_PROCESSING_ERROR", (Object)BroadleafAuthorizeNetController.getProcessingErrorMessage());
    }

    public PaymentGatewayWebResponseService getWebResponseService() {
        return this.paymentGatewayWebResponseService;
    }

    public PaymentGatewayConfiguration getConfiguration() {
        return this.configuration;
    }

    @RequestMapping(value={"/error"}, method={RequestMethod.GET})
    public String errorEndpoint(Model model, HttpServletRequest request, RedirectAttributes redirectAttributes, Map<String, String> pathVars) throws PaymentException {
        redirectAttributes.addAttribute("PAYMENT_PROCESSING_ERROR", (Object)BroadleafAuthorizeNetController.getProcessingErrorMessage());
        for (String key : request.getParameterMap().keySet()) {
            redirectAttributes.addAttribute(key, (Object)request.getParameter(key));
        }
        return this.getOrderReviewRedirect();
    }

    @RequestMapping(value={"/return"}, method={RequestMethod.GET})
    public String returnEndpoint(Model model, HttpServletRequest request, RedirectAttributes redirectAttributes, @PathVariable Map<String, String> pathVars) throws PaymentException {
        PaymentResponseDTO responseDTO = this.getWebResponseService().translateWebResponse(request);
        String orderNumber = this.lookupOrderNumberFromOrderId(responseDTO);
        return this.getConfirmationViewRedirect(orderNumber);
    }

    @RequestMapping(value={"/process"}, method={RequestMethod.POST})
    @ResponseBody
    public String process(HttpServletRequest request, HttpServletResponse response, RedirectAttributes redirectAttributes, Model model) throws PaymentException {
        LOG.debug((Object)("Authorize URL request - " + request.getRequestURL().toString()));
        LOG.debug((Object)("Authorize Request Parameter Map (params: [" + this.requestParamToString(request) + "])"));
        Result result = Result.createResult((String)this.configuration.getLoginId(), (String)this.configuration.getMd5Key(), (Map)request.getParameterMap());
        boolean error = false;
        String returnUrl = "";
        try {
            returnUrl = super.process(model, request, redirectAttributes);
        }
        catch (Exception e) {
            error = true;
        }
        if (error || this.getErrorViewRedirect().equals(returnUrl)) {
            PaymentResponseDTO responseDTO = this.getWebResponseService().translateWebResponse(request);
            PaymentRequestDTO voidRequest = this.responseToVoidRequest(responseDTO);
            this.transactionService.voidPayment(voidRequest);
            return this.authorizeNetCheckoutService.buildRelayResponse(this.configuration.getErrorUrl(), result);
        }
        return this.authorizeNetCheckoutService.buildRelayResponse(this.configuration.getConfirmUrl(), result);
    }

    protected PaymentRequestDTO responseToVoidRequest(PaymentResponseDTO response) {
        PaymentRequestDTO request = new PaymentRequestDTO().transactionTotal(response.getAmount().toString());
        for (Map.Entry field : response.getResponseMap().entrySet()) {
            request.additionalField((String)field.getKey(), field.getValue());
        }
        return request;
    }

    protected String requestParamToString(HttpServletRequest request) {
        StringBuffer requestMap = new StringBuffer();
        for (String key : request.getParameterMap().keySet()) {
            requestMap.append(key + ": " + request.getParameter(key) + ", ");
        }
        return requestMap.toString();
    }
}

