/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.authorizenet.service.payment.type;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import net.authorize.data.creditcard.CardType;
import org.broadleafcommerce.common.BroadleafEnumerationType;
import org.broadleafcommerce.common.payment.CreditCardType;

public class AuthorizeNetCardType
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, AuthorizeNetCardType> TYPES = new LinkedHashMap<String, AuthorizeNetCardType>();
    public static final AuthorizeNetCardType MASTERCARD = new AuthorizeNetCardType("MASTERCARD", "Master Card", CardType.MASTER_CARD);
    public static final AuthorizeNetCardType VISA = new AuthorizeNetCardType("VISA", "Visa", CardType.VISA);
    public static final AuthorizeNetCardType AMEX = new AuthorizeNetCardType("AMEX", "American Express", CardType.AMERICAN_EXPRESS);
    public static final AuthorizeNetCardType DINERSCLUB_CARTEBLANCHE = new AuthorizeNetCardType("DINERSCLUB_CARTEBLANCHE", "Diner's Club / Carte Blanche", CardType.DINERS_CLUB);
    public static final AuthorizeNetCardType DISCOVER = new AuthorizeNetCardType("DISCOVER", "Discover", CardType.DISCOVER);
    public static final AuthorizeNetCardType JCB = new AuthorizeNetCardType("JCB", "JCB", CardType.JCB);
    public static final AuthorizeNetCardType ECHECK = new AuthorizeNetCardType("ECHECK", "eCheck", CardType.ECHECK);
    public static final AuthorizeNetCardType UNKNOWN = new AuthorizeNetCardType("UNKNOWN", "Unknown", CardType.UNKNOWN);
    private String type;
    private String friendlyType;
    private CardType authCardType;

    public static AuthorizeNetCardType getInstance(String type) {
        return TYPES.get(type);
    }

    public static AuthorizeNetCardType getInstanceFromAuthorizeNetType(CardType authNetCardType) {
        for (String type : TYPES.keySet()) {
            if (!TYPES.get(type).getAuthorizeNetCardType().equals((Object)authNetCardType)) continue;
            return TYPES.get(type);
        }
        return null;
    }

    public static AuthorizeNetCardType getInstanceFromBroadleafType(CreditCardType blcCardType) {
        return AuthorizeNetCardType.getInstance(blcCardType.getType());
    }

    public AuthorizeNetCardType() {
    }

    public AuthorizeNetCardType(String type, String friendlyType, CardType authCardType) {
        this.friendlyType = friendlyType;
        this.authCardType = authCardType;
        this.setType(type);
    }

    public String getType() {
        return this.type;
    }

    public String getFriendlyType() {
        return this.friendlyType;
    }

    public CardType getAuthorizeNetCardType() {
        return this.authCardType;
    }

    public CreditCardType getBroadleafCardType() {
        CreditCardType blcCardType = CreditCardType.getInstance((String)this.type);
        return blcCardType == null ? new CreditCardType(this.type, this.friendlyType) : blcCardType;
    }

    private void setType(String type) {
        this.type = type;
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.authCardType == null ? 0 : this.authCardType.hashCode());
        result = 31 * result + (this.friendlyType == null ? 0 : this.friendlyType.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuthorizeNetCardType other = (AuthorizeNetCardType)obj;
        if (this.authCardType != other.authCardType) {
            return false;
        }
        if (this.friendlyType == null ? other.friendlyType != null : !this.friendlyType.equals(other.friendlyType)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

