/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.payment.service.gateway;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Map;
import javax.annotation.Resource;
import javax.xml.bind.JAXBException;
import net.authorize.AuthNetField;
import net.authorize.Environment;
import net.authorize.Merchant;
import net.authorize.ResponseCode;
import net.authorize.ResponseField;
import net.authorize.aim.Transaction;
import net.authorize.api.contract.v1.CreateTransactionRequest;
import net.authorize.api.contract.v1.CreateTransactionResponse;
import net.authorize.api.contract.v1.CustomerAddressType;
import net.authorize.api.contract.v1.CustomerDataType;
import net.authorize.api.contract.v1.CustomerTypeEnum;
import net.authorize.api.contract.v1.MerchantAuthenticationType;
import net.authorize.api.contract.v1.MessageTypeEnum;
import net.authorize.api.contract.v1.OpaqueDataType;
import net.authorize.api.contract.v1.OrderType;
import net.authorize.api.contract.v1.TransactionRequestType;
import net.authorize.api.contract.v1.TransactionTypeEnum;
import net.authorize.api.controller.CreateTransactionController;
import net.authorize.api.controller.base.ApiOperationBase;
import net.authorize.cim.Result;
import net.authorize.cim.TransactionType;
import net.authorize.data.Order;
import net.authorize.data.ShippingCharges;
import net.authorize.data.cim.DirectResponse;
import net.authorize.data.cim.PaymentTransaction;
import net.authorize.data.creditcard.CreditCard;
import net.authorize.util.XmlUtility;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.payment.PaymentTransactionType;
import org.broadleafcommerce.common.payment.PaymentType;
import org.broadleafcommerce.common.payment.dto.AddressDTO;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.common.payment.dto.PaymentResponseDTO;
import org.broadleafcommerce.common.payment.service.AbstractPaymentGatewayTransactionService;
import org.broadleafcommerce.common.payment.service.PaymentGatewayTransactionService;
import org.broadleafcommerce.common.time.SystemTime;
import org.broadleafcommerce.common.vendor.service.exception.PaymentException;
import org.broadleafcommerce.payment.service.gateway.AuthorizeNetConfiguration;
import org.broadleafcommerce.vendor.authorizenet.service.payment.AuthorizeNetGatewayType;
import org.broadleafcommerce.vendor.authorizenet.service.payment.type.MessageConstants;
import org.broadleafcommerce.vendor.authorizenet.util.AuthorizeNetUtil;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="blAuthorizeNetTransactionService")
public class AuthorizeNetTransactionServiceImpl
extends AbstractPaymentGatewayTransactionService
implements PaymentGatewayTransactionService {
    private static final Log LOG = LogFactory.getLog(AuthorizeNetTransactionServiceImpl.class);
    @Resource(name="blAuthorizeNetConfiguration")
    protected AuthorizeNetConfiguration configuration;
    @Resource
    protected AuthorizeNetUtil util;

    public PaymentResponseDTO authorize(PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        return this.common(paymentRequestDTO, net.authorize.TransactionType.AUTH_ONLY, PaymentTransactionType.AUTHORIZE);
    }

    public PaymentResponseDTO capture(PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        Assert.isTrue((boolean)paymentRequestDTO.getAdditionalFields().containsKey(ResponseField.TRANSACTION_ID.getFieldName()), (String)"Must pass 'x_trans_id' value on the additionalFields of the Payment Request DTO");
        Assert.isTrue((paymentRequestDTO.getTransactionTotal() != null ? 1 : 0) != 0, (String)"The Transaction Total must not be null on the Payment Request DTO");
        return this.common(paymentRequestDTO, net.authorize.TransactionType.PRIOR_AUTH_CAPTURE, PaymentTransactionType.CAPTURE);
    }

    public PaymentResponseDTO authorizeAndCapture(PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        return this.common(paymentRequestDTO, net.authorize.TransactionType.AUTH_CAPTURE, PaymentTransactionType.AUTHORIZE_AND_CAPTURE);
    }

    public PaymentResponseDTO reverseAuthorize(PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        return this.voidPayment(paymentRequestDTO);
    }

    public PaymentResponseDTO refund(PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        Assert.isTrue((boolean)paymentRequestDTO.getAdditionalFields().containsKey(AuthNetField.X_TRANS_ID.getFieldName()), (String)"Must pass 'x_trans_id' value on the additionalFields of the Payment Request DTO");
        Assert.isTrue((paymentRequestDTO.getTransactionTotal() != null ? 1 : 0) != 0, (String)"The Transaction Total must not be null on the Payment Request DTO");
        Boolean cardNumOrLastFourPopulated = paymentRequestDTO.creditCardPopulated() && (paymentRequestDTO.getCreditCard().getCreditCardLastFour() != null || paymentRequestDTO.getCreditCard().getCreditCardNum() != null);
        Assert.isTrue((cardNumOrLastFourPopulated != false || paymentRequestDTO.getAdditionalFields().get(AuthNetField.X_CARD_NUM.getFieldName()) != null ? 1 : 0) != 0, (String)"Must pass the Last four card number digits on the credit card of the Payment Request DTO");
        return this.common(paymentRequestDTO, net.authorize.TransactionType.CREDIT, PaymentTransactionType.REFUND);
    }

    public PaymentResponseDTO voidPayment(PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        return this.common(paymentRequestDTO, net.authorize.TransactionType.VOID, PaymentTransactionType.VOID);
    }

    protected PaymentResponseDTO common(PaymentRequestDTO paymentRequestDTO, net.authorize.TransactionType transactionType, PaymentTransactionType paymentTransactionType) {
        Merchant merchant = this.getAuthorizenetMerchant(paymentRequestDTO);
        PaymentType requestPaymentType = paymentRequestDTO.getPaymentType() == null ? PaymentType.CREDIT_CARD : paymentRequestDTO.getPaymentType();
        PaymentResponseDTO responseDTO = new PaymentResponseDTO(requestPaymentType, AuthorizeNetGatewayType.AUTHORIZENET);
        this.parseOutConsolidatedTokenField(paymentRequestDTO);
        if (paymentRequestDTO.getAdditionalFields().containsKey(MessageConstants.CUSTOMER_PROFILE_ID) && paymentRequestDTO.getAdditionalFields().containsKey(MessageConstants.PAYMENT_PROFILE_ID)) {
            if (transactionType.equals((Object)net.authorize.TransactionType.VOID)) {
                TransactionRequestType transactionVoid = new TransactionRequestType();
                if (this.configuration.isSandbox().booleanValue()) {
                    ApiOperationBase.setEnvironment((Environment)Environment.SANDBOX);
                } else {
                    ApiOperationBase.setEnvironment((Environment)Environment.PRODUCTION);
                }
                MerchantAuthenticationType merchantAuthenticationType = new MerchantAuthenticationType();
                merchantAuthenticationType.setName(this.configuration.getLoginId());
                merchantAuthenticationType.setTransactionKey(this.configuration.getTransactionKey());
                ApiOperationBase.setMerchantAuthentication((MerchantAuthenticationType)merchantAuthenticationType);
                transactionVoid.setTransactionType(TransactionTypeEnum.VOID_TRANSACTION.value());
                transactionVoid.setRefTransId((String)paymentRequestDTO.getAdditionalFields().get(AuthNetField.X_TRANS_ID.getFieldName()));
                transactionVoid.setCustomer(null);
                transactionVoid.setPayment(null);
                transactionVoid.setAmount(null);
                CreateTransactionRequest apiRequest = new CreateTransactionRequest();
                apiRequest.setTransactionRequest(transactionVoid);
                CreateTransactionController controller = new CreateTransactionController(apiRequest);
                controller.execute();
                CreateTransactionResponse response = (CreateTransactionResponse)controller.getApiResponse();
                responseDTO.paymentTransactionType(paymentTransactionType);
                responseDTO.amount(new Money(paymentRequestDTO.getTransactionTotal().toString()));
                responseDTO.orderId(paymentRequestDTO.getOrderId());
                responseDTO.responseMap("transaction_time", SystemTime.asDate().toString());
                responseDTO.responseMap(ResponseField.RESPONSE_CODE.getFieldName(), "" + response.getTransactionResponse().getResponseCode());
                responseDTO.responseMap(ResponseField.RESPONSE_REASON_CODE.getFieldName(), "" + response.getTransactionResponse().getRawResponseCode());
                responseDTO.responseMap(ResponseField.AMOUNT.getFieldName(), paymentRequestDTO.getTransactionTotal().toString());
                responseDTO.responseMap(ResponseField.AUTHORIZATION_CODE.getFieldName(), response.getTransactionResponse().getAuthCode());
                responseDTO.responseMap(ResponseField.ACCOUNT_NUMBER.getFieldName(), response.getTransactionResponse().getAccountNumber());
                responseDTO.responseMap(AuthNetField.X_INVOICE_NUM.getFieldName(), (String)paymentRequestDTO.getAdditionalFields().get(AuthNetField.X_INVOICE_NUM.getFieldName()));
                responseDTO.responseMap(AuthNetField.X_LOGIN.getFieldName(), this.configuration.getLoginId());
                responseDTO.responseMap(AuthNetField.X_VERSION_FIELD.getFieldName(), this.configuration.getTransactionVersion());
                responseDTO.responseMap(AuthNetField.X_METHOD.getFieldName(), "CC");
                responseDTO.responseMap(AuthNetField.X_TYPE.getFieldName(), transactionType.getValue());
                responseDTO.responseMap(AuthNetField.X_AMOUNT.getFieldName(), paymentRequestDTO.getTransactionTotal());
                responseDTO.responseMap(AuthNetField.X_TEST_REQUEST.getFieldName(), this.configuration.getXTestRequest());
                responseDTO.responseMap(AuthNetField.X_CUST_ID.getFieldName(), paymentRequestDTO.getCustomer().getCustomerId());
                responseDTO.responseMap(AuthNetField.X_TRANS_ID.getFieldName(), response.getTransactionResponse().getTransId());
                responseDTO.responseMap("blc_cid", paymentRequestDTO.getCustomer().getCustomerId());
                responseDTO.responseMap("blc_oid", paymentRequestDTO.getOrderId());
                responseDTO.responseMap("authorizenet_server_url", this.configuration.getServerUrl());
                if (paymentRequestDTO.billToPopulated()) {
                    responseDTO.responseMap(AuthNetField.X_FIRST_NAME.getFieldName(), paymentRequestDTO.getBillTo().getAddressFirstName()).responseMap(AuthNetField.X_LAST_NAME.getFieldName(), paymentRequestDTO.getBillTo().getAddressLastName()).responseMap(AuthNetField.X_ADDRESS.getFieldName(), paymentRequestDTO.getBillTo().getAddressLine1()).responseMap(AuthNetField.X_CITY.getFieldName(), paymentRequestDTO.getBillTo().getAddressCityLocality()).responseMap(AuthNetField.X_STATE.getFieldName(), paymentRequestDTO.getBillTo().getAddressStateRegion()).responseMap(AuthNetField.X_ZIP.getFieldName(), paymentRequestDTO.getBillTo().getAddressPostalCode()).responseMap(AuthNetField.X_COUNTRY.getFieldName(), paymentRequestDTO.getBillTo().getAddressCountryCode()).responseMap(AuthNetField.X_EMAIL.getFieldName(), paymentRequestDTO.getBillTo().getAddressEmail() != null ? paymentRequestDTO.getBillTo().getAddressEmail() : paymentRequestDTO.getCustomer().getEmail()).responseMap(AuthNetField.X_PHONE.getFieldName(), paymentRequestDTO.getBillTo().getAddressPhone());
                }
                responseDTO.successful(response.getMessages().getResultCode().equals((Object)MessageTypeEnum.OK) && Integer.toString(ResponseCode.APPROVED.getCode()).equals(response.getTransactionResponse().getResponseCode()));
                if (!responseDTO.isSuccessful()) {
                    responseDTO.valid(false);
                    responseDTO.completeCheckoutOnCallback(false);
                }
                return responseDTO;
            }
            net.authorize.cim.Transaction transaction = merchant.createCIMTransaction(TransactionType.CREATE_CUSTOMER_PROFILE_TRANSACTION);
            transaction.setCustomerProfileId((String)paymentRequestDTO.getAdditionalFields().get(MessageConstants.CUSTOMER_PROFILE_ID));
            PaymentTransaction paymentTransaction = PaymentTransaction.createPaymentTransaction();
            transaction.setPaymentTransaction(paymentTransaction);
            paymentTransaction.setTransactionType(transactionType);
            paymentTransaction.setCustomerPaymentProfileId((String)paymentRequestDTO.getAdditionalFields().get(MessageConstants.PAYMENT_PROFILE_ID));
            Order order = Order.createOrder();
            paymentTransaction.setOrder(order);
            order.setTotalAmount(new BigDecimal(paymentRequestDTO.getTransactionTotal()));
            order.setInvoiceNumber(paymentRequestDTO.getOrderId());
            order.setDescription(paymentRequestDTO.getOrderDescription());
            ShippingCharges shipping = ShippingCharges.createShippingCharges();
            order.setShippingCharges(shipping);
            shipping.setFreightAmount(paymentRequestDTO.getShippingTotal());
            shipping.setTaxAmount(paymentRequestDTO.getTaxTotal());
            Result gatewayResult = (Result)merchant.postTransaction((net.authorize.Transaction)transaction);
            responseDTO.successful(gatewayResult.isOk());
            responseDTO.rawResponse(((net.authorize.cim.Transaction)gatewayResult.getTarget()).getCurrentResponse().dump());
            responseDTO.orderId(paymentRequestDTO.getOrderId());
            Map responseMap = ((DirectResponse)gatewayResult.getDirectResponseList().get(0)).getDirectResponseMap();
            responseDTO.creditCard().creditCardLastFour((String)responseMap.get(ResponseField.ACCOUNT_NUMBER)).creditCardType((String)responseMap.get(ResponseField.CARD_TYPE));
            responseDTO.amount(new Money((String)responseMap.get(ResponseField.AMOUNT)));
            responseDTO.customer().email((String)responseMap.get(ResponseField.EMAIL_ADDRESS));
            responseDTO.paymentTransactionType(paymentTransactionType);
            responseDTO.responseMap(AuthNetField.X_TRANS_ID.getFieldName(), (String)responseMap.get(ResponseField.TRANSACTION_ID));
            for (String fieldKey : paymentRequestDTO.getAdditionalFields().keySet()) {
                responseDTO.responseMap(fieldKey, (String)paymentRequestDTO.getAdditionalFields().get(fieldKey));
            }
            for (String fieldKey : ((DirectResponse)gatewayResult.getDirectResponseList().get(0)).getDirectResponseMap().keySet()) {
                responseDTO.responseMap(fieldKey.getFieldName(), (String)((DirectResponse)gatewayResult.getDirectResponseList().get(0)).getDirectResponseMap().get(fieldKey));
            }
        } else if (paymentRequestDTO.getAdditionalFields().containsKey("X_TRANS_ID")) {
            Transaction transaction = merchant.createAIMTransaction(transactionType, new BigDecimal(paymentRequestDTO.getTransactionTotal()));
            transaction.getRequestMap().put(AuthNetField.X_TEST_REQUEST.getFieldName(), this.configuration.getXTestRequest());
            transaction.getRequestMap().put(AuthNetField.X_TEST_REQUEST.getFieldName(), this.configuration.getXTestRequest());
            transaction.setMerchantDefinedField("blc_oid", paymentRequestDTO.getOrderId());
            for (Map.Entry field : paymentRequestDTO.getAdditionalFields().entrySet()) {
                if (field.getValue() == null) continue;
                transaction.setMerchantDefinedField((String)field.getKey(), (String)field.getValue());
            }
            transaction.setTransactionId((String)paymentRequestDTO.getAdditionalFields().get(AuthNetField.X_TRANS_ID.getFieldName()));
            if (transactionType.equals((Object)net.authorize.TransactionType.AUTH_CAPTURE) || transactionType.equals((Object)net.authorize.TransactionType.AUTH_ONLY)) {
                CreditCard creditCard = CreditCard.createCreditCard();
                creditCard.setCreditCardNumber(paymentRequestDTO.getCreditCard().getCreditCardNum());
                creditCard.setExpirationMonth(paymentRequestDTO.getCreditCard().getCreditCardExpMonth());
                creditCard.setExpirationYear(paymentRequestDTO.getCreditCard().getCreditCardExpYear());
                transaction.setCreditCard(creditCard);
            }
            if (transactionType.equals((Object)net.authorize.TransactionType.CREDIT)) {
                String cardNumOrLastFour = null;
                if (paymentRequestDTO.creditCardPopulated()) {
                    cardNumOrLastFour = paymentRequestDTO.getCreditCard().getCreditCardLastFour();
                }
                if (cardNumOrLastFour == null && ((String)paymentRequestDTO.getAdditionalFields().get(AuthNetField.X_CARD_NUM.getFieldName())).length() == 4) {
                    cardNumOrLastFour = (String)paymentRequestDTO.getAdditionalFields().get(AuthNetField.X_CARD_NUM.getFieldName());
                }
                if (cardNumOrLastFour == null && paymentRequestDTO.creditCardPopulated()) {
                    cardNumOrLastFour = paymentRequestDTO.getCreditCard().getCreditCardNum();
                }
                CreditCard creditCard = CreditCard.createCreditCard();
                creditCard.setCreditCardNumber(cardNumOrLastFour);
                transaction.setCreditCard(creditCard);
            }
            net.authorize.aim.Result result = (net.authorize.aim.Result)merchant.postTransaction((net.authorize.Transaction)transaction);
            responseDTO.paymentTransactionType(paymentTransactionType);
            responseDTO.rawResponse(((Transaction)result.getTarget()).toNVPString());
            if (((Transaction)result.getTarget()).getResponseField(ResponseField.AMOUNT) != null) {
                responseDTO.amount(new Money(((Transaction)result.getTarget()).getResponseField(ResponseField.AMOUNT)));
            }
            responseDTO.orderId(((Transaction)result.getTarget()).getMerchantDefinedField("blc_oid"));
            responseDTO.responseMap("transaction_time", SystemTime.asDate().toString());
            responseDTO.responseMap(ResponseField.RESPONSE_CODE.getFieldName(), "" + result.getResponseCode().getCode());
            responseDTO.responseMap(ResponseField.RESPONSE_REASON_CODE.getFieldName(), "" + result.getReasonResponseCode().getResponseReasonCode());
            responseDTO.responseMap(ResponseField.RESPONSE_REASON_TEXT.getFieldName(), result.getResponseText());
            responseDTO.responseMap(ResponseField.TRANSACTION_TYPE.getFieldName(), ((Transaction)result.getTarget()).getTransactionType().getValue());
            responseDTO.responseMap(ResponseField.AMOUNT.getFieldName(), ((Transaction)result.getTarget()).getResponseField(ResponseField.AMOUNT));
            responseDTO.responseMap(ResponseField.AUTHORIZATION_CODE.getFieldName(), ((Transaction)result.getTarget()).getAuthorizationCode());
            responseDTO.successful(result.isApproved());
            if (result.isError()) {
                responseDTO.valid(false);
                responseDTO.completeCheckoutOnCallback(false);
            }
            for (String fieldKey : ((Transaction)result.getTarget()).getMerchantDefinedMap().keySet()) {
                responseDTO.responseMap(fieldKey, ((Transaction)result.getTarget()).getMerchantDefinedField(fieldKey));
            }
        } else if (paymentRequestDTO.getAdditionalFields().containsKey("OPAQUE_DATA_DESCRIPTOR")) {
            OrderType orderType = new OrderType();
            orderType.setInvoiceNumber(paymentRequestDTO.getOrderId());
            orderType.setDescription(paymentRequestDTO.getOrderDescription());
            TransactionRequestType transaction = new TransactionRequestType();
            transaction.setOrder(orderType);
            net.authorize.api.contract.v1.PaymentType paymentType = new net.authorize.api.contract.v1.PaymentType();
            OpaqueDataType data = new OpaqueDataType();
            data.setDataDescriptor((String)paymentRequestDTO.getAdditionalFields().get("OPAQUE_DATA_DESCRIPTOR"));
            data.setDataValue((String)paymentRequestDTO.getAdditionalFields().get("OPAQUE_DATA_VALUE"));
            paymentType.setOpaqueData(data);
            CustomerDataType customer = new CustomerDataType();
            customer.setType(CustomerTypeEnum.INDIVIDUAL);
            customer.setId(paymentRequestDTO.getCustomer().getCustomerId());
            customer.setEmail(paymentRequestDTO.getCustomer().getEmail());
            transaction.setCustomer(customer);
            AddressDTO billing = paymentRequestDTO.getBillTo();
            if (billing != null) {
                CustomerAddressType customerAddress = new CustomerAddressType();
                customerAddress.setFirstName(billing.getAddressFirstName());
                customerAddress.setLastName(billing.getAddressLastName());
                customerAddress.setAddress(billing.getAddressLine1());
                customerAddress.setCity(billing.getAddressCityLocality());
                customerAddress.setState(billing.getAddressStateRegion());
                customerAddress.setZip(billing.getAddressPostalCode());
                customerAddress.setCountry(billing.getAddressCountryCode());
                customerAddress.setPhoneNumber(billing.getAddressPhone());
                if (StringUtils.isNotEmpty((CharSequence)billing.getAddressEmail())) {
                    customerAddress.setEmail(billing.getAddressEmail());
                } else {
                    customerAddress.setEmail(paymentRequestDTO.getCustomer().getEmail());
                }
                transaction.setBillTo(customerAddress);
            }
            transaction.setPayment(paymentType);
            transaction.setAmount(new BigDecimal(paymentRequestDTO.getTransactionTotal()));
            if (transactionType.equals((Object)net.authorize.TransactionType.AUTH_CAPTURE)) {
                transaction.setTransactionType(TransactionTypeEnum.AUTH_CAPTURE_TRANSACTION.value());
            } else if (transactionType.equals((Object)net.authorize.TransactionType.AUTH_ONLY)) {
                transaction.setTransactionType(TransactionTypeEnum.AUTH_ONLY_TRANSACTION.value());
            } else if (transactionType.equals((Object)net.authorize.TransactionType.VOID)) {
                transaction.setTransactionType(TransactionTypeEnum.VOID_TRANSACTION.value());
                transaction.setRefTransId((String)paymentRequestDTO.getAdditionalFields().get(AuthNetField.X_TRANS_ID.getFieldName()));
                transaction.setCustomer(null);
                transaction.setPayment(null);
                transaction.setAmount(null);
            } else if (transactionType.equals((Object)net.authorize.TransactionType.PRIOR_AUTH_CAPTURE)) {
                transaction.setTransactionType(TransactionTypeEnum.PRIOR_AUTH_CAPTURE_TRANSACTION.value());
            }
            CreateTransactionRequest apiRequest = new CreateTransactionRequest();
            apiRequest.setTransactionRequest(transaction);
            apiRequest.setMerchantAuthentication(this.getMerchantAuthentication(paymentRequestDTO));
            CreateTransactionController controller = new CreateTransactionController(apiRequest);
            Environment authnetEnv = this.configuration.isSandbox() != false ? Environment.SANDBOX : Environment.PRODUCTION;
            controller.execute(authnetEnv);
            CreateTransactionResponse response = (CreateTransactionResponse)controller.getApiResponse();
            try {
                responseDTO.rawResponse(XmlUtility.getXml((Serializable)response));
            }
            catch (IOException | JAXBException e) {
                LOG.error((Object)"Could not serialize raw response", e);
            }
            responseDTO.paymentTransactionType(paymentTransactionType);
            responseDTO.amount(new Money(paymentRequestDTO.getTransactionTotal().toString()));
            responseDTO.orderId(paymentRequestDTO.getOrderId());
            responseDTO.responseMap("transaction_time", SystemTime.asDate().toString());
            responseDTO.responseMap(ResponseField.RESPONSE_CODE.getFieldName(), "" + response.getTransactionResponse().getResponseCode());
            responseDTO.responseMap(ResponseField.RESPONSE_REASON_CODE.getFieldName(), "" + response.getTransactionResponse().getRawResponseCode());
            responseDTO.responseMap(ResponseField.AMOUNT.getFieldName(), paymentRequestDTO.getTransactionTotal().toString());
            responseDTO.responseMap(ResponseField.AUTHORIZATION_CODE.getFieldName(), response.getTransactionResponse().getAuthCode());
            responseDTO.responseMap(ResponseField.ACCOUNT_NUMBER.getFieldName(), response.getTransactionResponse().getAccountNumber()).responseMap(AuthNetField.X_INVOICE_NUM.getFieldName(), transaction.getOrder().getInvoiceNumber()).responseMap(AuthNetField.X_LOGIN.getFieldName(), this.configuration.getLoginId()).responseMap(AuthNetField.X_VERSION_FIELD.getFieldName(), this.configuration.getTransactionVersion()).responseMap(AuthNetField.X_METHOD.getFieldName(), "CC").responseMap(AuthNetField.X_TYPE.getFieldName(), transactionType.getValue()).responseMap(AuthNetField.X_AMOUNT.getFieldName(), paymentRequestDTO.getTransactionTotal()).responseMap(AuthNetField.X_TEST_REQUEST.getFieldName(), this.configuration.getXTestRequest()).responseMap(AuthNetField.X_CUST_ID.getFieldName(), paymentRequestDTO.getCustomer().getCustomerId()).responseMap(AuthNetField.X_TRANS_ID.getFieldName(), response.getTransactionResponse().getTransId()).responseMap("blc_cid", paymentRequestDTO.getCustomer().getCustomerId()).responseMap("blc_oid", paymentRequestDTO.getOrderId()).responseMap("authorizenet_server_url", this.configuration.getServerUrl());
            if (paymentRequestDTO.billToPopulated()) {
                responseDTO.responseMap(AuthNetField.X_FIRST_NAME.getFieldName(), paymentRequestDTO.getBillTo().getAddressFirstName()).responseMap(AuthNetField.X_LAST_NAME.getFieldName(), paymentRequestDTO.getBillTo().getAddressLastName()).responseMap(AuthNetField.X_ADDRESS.getFieldName(), paymentRequestDTO.getBillTo().getAddressLine1()).responseMap(AuthNetField.X_CITY.getFieldName(), paymentRequestDTO.getBillTo().getAddressCityLocality()).responseMap(AuthNetField.X_STATE.getFieldName(), paymentRequestDTO.getBillTo().getAddressStateRegion()).responseMap(AuthNetField.X_ZIP.getFieldName(), paymentRequestDTO.getBillTo().getAddressPostalCode()).responseMap(AuthNetField.X_COUNTRY.getFieldName(), paymentRequestDTO.getBillTo().getAddressCountryCode()).responseMap(AuthNetField.X_EMAIL.getFieldName(), paymentRequestDTO.getBillTo().getAddressEmail() != null ? paymentRequestDTO.getBillTo().getAddressEmail() : paymentRequestDTO.getCustomer().getEmail()).responseMap(AuthNetField.X_PHONE.getFieldName(), paymentRequestDTO.getBillTo().getAddressPhone());
            }
            for (String fieldKey : paymentRequestDTO.getAdditionalFields().keySet()) {
                responseDTO.responseMap(fieldKey, (String)paymentRequestDTO.getAdditionalFields().get(fieldKey));
            }
            responseDTO.successful(response.getMessages().getResultCode().equals((Object)MessageTypeEnum.OK) && Integer.toString(ResponseCode.APPROVED.getCode()).equals(response.getTransactionResponse().getResponseCode()));
            if (!responseDTO.isSuccessful()) {
                responseDTO.valid(false);
                responseDTO.completeCheckoutOnCallback(false);
            }
        } else {
            throw new IllegalStateException("Cannot determine action from additionalFields: \n" + paymentRequestDTO.getAdditionalFields());
        }
        return responseDTO;
    }

    protected Merchant getAuthorizenetMerchant(PaymentRequestDTO paymentRequestDTO) {
        Environment env = Environment.createEnvironment((String)this.configuration.getServerUrl(), (String)this.configuration.getXMLBaseUrl());
        Merchant merchant = Merchant.createMerchant((Environment)env, (String)this.configuration.getLoginId(), (String)this.configuration.getTransactionKey());
        return merchant;
    }

    protected MerchantAuthenticationType getMerchantAuthentication(PaymentRequestDTO paymentRequestDTO) {
        MerchantAuthenticationType merchantAuthenticationType = new MerchantAuthenticationType();
        merchantAuthenticationType.setName(this.configuration.getLoginId());
        merchantAuthenticationType.setTransactionKey(this.configuration.getTransactionKey());
        return merchantAuthenticationType;
    }

    protected void parseOutConsolidatedTokenField(PaymentRequestDTO paymentRequestDTO) {
        String consolidatedToken = (String)paymentRequestDTO.getAdditionalFields().get("TOKEN");
        if (consolidatedToken != null) {
            String[] profileIdPaymentId = this.util.parseConsolidatedPaymentToken(consolidatedToken);
            paymentRequestDTO.getAdditionalFields().put(MessageConstants.CUSTOMER_PROFILE_ID, profileIdPaymentId[0]);
            paymentRequestDTO.getAdditionalFields().put(MessageConstants.PAYMENT_PROFILE_ID, profileIdPaymentId[1]);
        }
    }
}

