/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.payment.service.gateway;

import javax.annotation.Resource;
import org.broadleafcommerce.common.payment.PaymentTransactionType;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.common.payment.dto.PaymentResponseDTO;
import org.broadleafcommerce.common.payment.service.AbstractPaymentGatewayTransactionConfirmationService;
import org.broadleafcommerce.common.payment.service.PaymentGatewayConfiguration;
import org.broadleafcommerce.common.payment.service.PaymentGatewayTransactionConfirmationService;
import org.broadleafcommerce.common.payment.service.PaymentGatewayTransactionService;
import org.broadleafcommerce.common.vendor.service.exception.PaymentException;
import org.springframework.stereotype.Service;

@Service(value="blAuthorizeNetTransactionConfirmationService")
public class AuthorizeNetTransactionConfirmationService
extends AbstractPaymentGatewayTransactionConfirmationService
implements PaymentGatewayTransactionConfirmationService {
    @Resource(name="blAuthorizeNetConfiguration")
    protected PaymentGatewayConfiguration configuration;
    @Resource(name="blAuthorizeNetTransactionService")
    protected PaymentGatewayTransactionService transactionService;

    public PaymentResponseDTO confirmTransaction(PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        PaymentResponseDTO responseDTO = null;
        if (this.configuration.isPerformAuthorizeAndCapture()) {
            responseDTO = this.transactionService.authorizeAndCapture(paymentRequestDTO);
            responseDTO.paymentTransactionType(PaymentTransactionType.AUTHORIZE_AND_CAPTURE);
        } else {
            responseDTO = this.transactionService.authorize(paymentRequestDTO);
            responseDTO.paymentTransactionType(PaymentTransactionType.AUTHORIZE);
        }
        return responseDTO;
    }
}

