/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.paypal.service.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.paypal.http.HttpResponse;
import com.paypal.http.exceptions.HttpException;
import com.paypal.http.exceptions.SerializeException;
import com.paypal.http.serializer.Json;
import com.paypal.orders.AmountWithBreakdown;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalErrorResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service(value="blPayPalUtils")
public class PayPalUtils {
    private static final Log LOG = LogFactory.getLog(PayPalUtils.class);
    @Autowired
    private ObjectMapper mapper;

    public String convertResponseToJson(HttpResponse<?> response) {
        try {
            return new Json().serialize(response.result());
        }
        catch (SerializeException e) {
            LOG.error((Object)"Could not convert response into JSON", (Throwable)e);
            return null;
        }
    }

    public PayPalErrorResponse convertFromErrorJson(HttpException ex) {
        try {
            return (PayPalErrorResponse)this.mapper.readValue(ex.getMessage(), PayPalErrorResponse.class);
        }
        catch (IOException e) {
            LOG.error((Object)"Could not convert error JSON", (Throwable)e);
            PayPalErrorResponse response = new PayPalErrorResponse();
            response.setMessage(HttpStatus.valueOf((int)ex.statusCode()).getReasonPhrase());
            return response;
        }
    }

    public Money getMoneyForAmountWithBreakdown(AmountWithBreakdown amount) {
        return new Money(amount.value(), amount.currencyCode());
    }

    public Money convertOrdersMoneyToMoney(com.paypal.orders.Money money) {
        return new Money(money.value(), money.currencyCode());
    }

    public Money convertPaymentsMoneyToMoney(com.paypal.payments.Money money) {
        return new Money(money.value(), money.currencyCode());
    }

    public com.paypal.payments.Money convertToPaymentsMoney(String value, String currencyCode) {
        return new com.paypal.payments.Money().value(value).currencyCode(currencyCode);
    }

    public com.paypal.orders.Money convertToOrdersMoney(String value, String currencyCode) {
        return new com.paypal.orders.Money().value(value).currencyCode(currencyCode);
    }
}

