/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.paypal.service.payment;

import com.paypal.http.HttpResponse;
import com.paypal.payments.AuthorizationsVoidRequest;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.vendor.paypal.service.PayPalClientProvider;
import org.broadleafcommerce.vendor.paypal.service.payment.AbstractPayPalRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.AbstractPayPalResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalVoidAuthResponse;

public class PayPalVoidAuthRequest
extends AbstractPayPalRequest<Void, AuthorizationsVoidRequest> {
    private final String authId;

    public PayPalVoidAuthRequest(PayPalClientProvider clientProvider, PaymentRequestDTO paymentRequest, String authId) {
        super(clientProvider, paymentRequest);
        this.authId = authId;
    }

    @Override
    protected AuthorizationsVoidRequest buildRequest() {
        return new AuthorizationsVoidRequest(this.getAuthId());
    }

    @Override
    protected AbstractPayPalResponse<Void> executeInternal() throws IOException {
        HttpResponse response = this.getClient().execute(this.getRequest());
        return new PayPalVoidAuthResponse((HttpResponse<Void>)response);
    }

    @Override
    protected boolean isValidInternal() {
        return StringUtils.isNotBlank((CharSequence)this.getAuthId());
    }

    protected String getAuthId() {
        return this.authId;
    }
}

