/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.paypal.service.payment;

import com.paypal.http.HttpResponse;
import com.paypal.orders.OrdersPatchRequest;
import com.paypal.orders.Patch;
import java.io.IOException;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.vendor.paypal.service.PayPalClientProvider;
import org.broadleafcommerce.vendor.paypal.service.payment.AbstractPayPalRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.AbstractPayPalResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalUpdateOrderResponse;

public class PayPalUpdateOrderRequest
extends AbstractPayPalRequest<Void, OrdersPatchRequest> {
    private static final Log LOG = LogFactory.getLog(PayPalUpdateOrderRequest.class);
    private final String orderId;
    private final List<Patch> patches;

    public PayPalUpdateOrderRequest(PayPalClientProvider clientProvider, PaymentRequestDTO paymentRequest, String orderId, List<Patch> patches) {
        super(clientProvider, paymentRequest);
        this.orderId = orderId;
        this.patches = patches;
    }

    @Override
    protected OrdersPatchRequest buildRequest() {
        OrdersPatchRequest request = new OrdersPatchRequest(this.getOrderId());
        request.requestBody(this.getPatches());
        return request;
    }

    @Override
    protected AbstractPayPalResponse<Void> executeInternal() throws IOException {
        HttpResponse response = this.getClient().execute(this.getRequest());
        return new PayPalUpdateOrderResponse((HttpResponse<Void>)response);
    }

    @Override
    protected boolean isValidInternal() {
        List<Patch> requestContent = this.getPatches();
        boolean paymentValid = StringUtils.isNotBlank((CharSequence)this.orderId);
        if (!paymentValid || !CollectionUtils.isNotEmpty(requestContent)) {
            return false;
        }
        int requestContentSize = requestContent.size();
        for (int i = 0; i < requestContentSize; ++i) {
            boolean missingChangeValue;
            boolean changesNothing;
            Patch patch = requestContent.get(i);
            boolean bl = changesNothing = patch == null || StringUtils.isBlank((CharSequence)patch.path()) || StringUtils.isBlank((CharSequence)patch.op());
            if (changesNothing) {
                LOG.debug((Object)String.format("Patch %d didn't contain any change info", i));
                return false;
            }
            boolean bl2 = missingChangeValue = !"remove".equals(patch.op()) && patch.value() == null;
            if (!missingChangeValue) continue;
            LOG.debug((Object)String.format("Patch %d ({ op: %s, path: %s, from: %s }) doesn't contain a value", i, patch.op(), patch.path(), patch.from()));
            return false;
        }
        return true;
    }

    protected String getOrderId() {
        return this.orderId;
    }

    protected List<Patch> getPatches() {
        return this.patches;
    }
}

