/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.paypal.service.payment;

import com.paypal.http.HttpResponse;
import com.paypal.payments.CapturesRefundRequest;
import com.paypal.payments.Money;
import com.paypal.payments.Refund;
import com.paypal.payments.RefundRequest;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.vendor.paypal.service.PayPalClientProvider;
import org.broadleafcommerce.vendor.paypal.service.payment.AbstractPayPalRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.AbstractPayPalResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalRefundResponse;

public class PayPalRefundRequest
extends AbstractPayPalRequest<Refund, CapturesRefundRequest> {
    private final String captureId;
    private final RefundRequest refundRequest;

    public PayPalRefundRequest(PayPalClientProvider clientProvider, PaymentRequestDTO paymentRequest, RefundRequest refundRequest, String captureId) {
        super(clientProvider, paymentRequest);
        this.refundRequest = refundRequest;
        this.captureId = captureId;
    }

    @Override
    protected CapturesRefundRequest buildRequest() {
        CapturesRefundRequest request = new CapturesRefundRequest(this.getCaptureId());
        request.requestBody(this.getRefundRequest());
        return request;
    }

    @Override
    protected AbstractPayPalResponse<Refund> executeInternal() throws IOException {
        HttpResponse response = this.getClient().execute(this.getRequest());
        return new PayPalRefundResponse((HttpResponse<Refund>)response);
    }

    @Override
    protected boolean isValidInternal() {
        RefundRequest request = this.getRefundRequest();
        return StringUtils.isNotBlank((CharSequence)this.captureId) && request != null && this.isAmountValid();
    }

    private boolean isAmountValid() {
        RefundRequest request = this.getRefundRequest();
        Money amount = request.amount();
        return amount == null || StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{amount.currencyCode(), amount.value()}) && NumberUtils.isCreatable((String)amount.value());
    }

    protected String getCaptureId() {
        return this.captureId;
    }

    protected RefundRequest getRefundRequest() {
        return this.refundRequest;
    }
}

