/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.paypal.service.payment;

import com.paypal.http.HttpResponse;
import com.paypal.payments.Authorization;
import com.paypal.payments.AuthorizationsReauthorizeRequest;
import com.paypal.payments.Money;
import com.paypal.payments.ReauthorizeRequest;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.vendor.paypal.service.PayPalClientProvider;
import org.broadleafcommerce.vendor.paypal.service.payment.AbstractPayPalRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.AbstractPayPalResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalReAuthorizeResponse;

public class PayPalReAuthorizeRequest
extends AbstractPayPalRequest<Authorization, AuthorizationsReauthorizeRequest> {
    private final String authId;
    private final ReauthorizeRequest reauthorizeRequest;

    public PayPalReAuthorizeRequest(PayPalClientProvider clientProvider, PaymentRequestDTO paymentRequest, String authId, ReauthorizeRequest reauthorizeRequest) {
        super(clientProvider, paymentRequest);
        this.authId = authId;
        this.reauthorizeRequest = reauthorizeRequest;
    }

    @Override
    protected AuthorizationsReauthorizeRequest buildRequest() {
        AuthorizationsReauthorizeRequest request = new AuthorizationsReauthorizeRequest(this.getAuthId());
        request.requestBody(this.getReauthorizeRequest());
        return request;
    }

    @Override
    protected AbstractPayPalResponse<Authorization> executeInternal() throws IOException {
        HttpResponse response = this.getClient().execute(this.getRequest());
        return new PayPalReAuthorizeResponse((HttpResponse<Authorization>)response);
    }

    @Override
    protected boolean isValidInternal() {
        ReauthorizeRequest request = this.getReauthorizeRequest();
        if (request == null) {
            return false;
        }
        Money amt = request.amount();
        return amt != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.getAuthId(), amt.currencyCode(), amt.value()}) && NumberUtils.isCreatable((String)amt.value());
    }

    protected String getAuthId() {
        return this.authId;
    }

    protected ReauthorizeRequest getReauthorizeRequest() {
        return this.reauthorizeRequest;
    }
}

