/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.paypal.service.payment;

import com.paypal.http.HttpResponse;
import com.paypal.orders.Order;
import com.paypal.orders.OrdersGetRequest;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.vendor.paypal.service.PayPalClientProvider;
import org.broadleafcommerce.vendor.paypal.service.payment.AbstractPayPalRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.AbstractPayPalResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalOrderRetrievalResponse;

public class PayPalOrderRetrievalRequest
extends AbstractPayPalRequest<Order, OrdersGetRequest> {
    private final String orderId;

    public PayPalOrderRetrievalRequest(PayPalClientProvider clientProvider, PaymentRequestDTO paymentRequest, String orderId) {
        super(clientProvider, paymentRequest);
        this.orderId = orderId;
    }

    @Override
    protected OrdersGetRequest buildRequest() {
        return new OrdersGetRequest(this.getOrderId());
    }

    @Override
    protected AbstractPayPalResponse<Order> executeInternal() throws IOException {
        HttpResponse response = this.getClient().execute(this.getRequest());
        return new PayPalOrderRetrievalResponse((HttpResponse<Order>)response);
    }

    @Override
    protected boolean isValidInternal() {
        return StringUtils.isNotBlank((CharSequence)this.getOrderId());
    }

    protected String getOrderId() {
        return this.orderId;
    }
}

