/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.paypal.service.payment;

import com.paypal.http.HttpResponse;
import com.paypal.orders.AmountBreakdown;
import com.paypal.orders.AmountWithBreakdown;
import com.paypal.orders.Order;
import com.paypal.orders.OrderRequest;
import com.paypal.orders.OrdersCreateRequest;
import com.paypal.orders.PurchaseUnitRequest;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.vendor.paypal.service.PayPalClientProvider;
import org.broadleafcommerce.vendor.paypal.service.payment.AbstractPayPalRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.AbstractPayPalResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalCreateOrderResponse;

public class PayPalCreateOrderRequest
extends AbstractPayPalRequest<Order, OrdersCreateRequest> {
    private final OrderRequest orderRequest;

    public PayPalCreateOrderRequest(PayPalClientProvider clientProvider, PaymentRequestDTO paymentRequest, OrderRequest orderRequest) {
        super(clientProvider, paymentRequest);
        this.orderRequest = orderRequest;
    }

    @Override
    protected OrdersCreateRequest buildRequest() {
        OrdersCreateRequest request = new OrdersCreateRequest();
        request.prefer("return=representation");
        request.requestBody(this.getOrderRequest());
        return request;
    }

    @Override
    protected AbstractPayPalResponse<Order> executeInternal() throws IOException {
        HttpResponse response = this.getClient().execute(this.getRequest());
        return new PayPalCreateOrderResponse((HttpResponse<Order>)response);
    }

    @Override
    protected boolean isValidInternal() {
        OrderRequest request = this.getOrderRequest();
        if (request == null || request.payer() == null || CollectionUtils.isEmpty((Collection)request.purchaseUnits()) || StringUtils.isBlank((CharSequence)request.checkoutPaymentIntent())) {
            return false;
        }
        PurchaseUnitRequest purchaseUnitRequest = (PurchaseUnitRequest)request.purchaseUnits().get(0);
        if (purchaseUnitRequest == null || purchaseUnitRequest.amountWithBreakdown() == null) {
            return false;
        }
        AmountWithBreakdown totalWithBreakdown = purchaseUnitRequest.amountWithBreakdown();
        String totalCurrency = totalWithBreakdown.currencyCode();
        String totalAmount = totalWithBreakdown.value();
        if (totalCurrency != null && StringUtils.isBlank((CharSequence)totalAmount)) {
            return false;
        }
        AmountBreakdown subtotals = totalWithBreakdown.amountBreakdown();
        return !(subtotals == null || subtotals.itemTotal() == null || !StringUtils.isNotBlank((CharSequence)subtotals.itemTotal().value()) || subtotals.shipping() != null && !StringUtils.isNotBlank((CharSequence)subtotals.shipping().value()) || subtotals.taxTotal() != null && !StringUtils.isNotBlank((CharSequence)subtotals.taxTotal().value()));
    }

    protected OrderRequest getOrderRequest() {
        return this.orderRequest;
    }
}

