/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.paypal.service.payment;

import com.paypal.http.HttpResponse;
import com.paypal.payments.Capture;
import com.paypal.payments.CapturesGetRequest;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.vendor.paypal.service.PayPalClientProvider;
import org.broadleafcommerce.vendor.paypal.service.payment.AbstractPayPalRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.AbstractPayPalResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalCaptureRetrievalResponse;

public class PayPalCaptureRetrievalRequest
extends AbstractPayPalRequest<Capture, CapturesGetRequest> {
    private final String captureId;

    public PayPalCaptureRetrievalRequest(PayPalClientProvider clientProvider, PaymentRequestDTO paymentRequest, String captureId) {
        super(clientProvider, paymentRequest);
        this.captureId = captureId;
    }

    @Override
    protected CapturesGetRequest buildRequest() {
        return new CapturesGetRequest(this.getCaptureId());
    }

    @Override
    protected AbstractPayPalResponse<Capture> executeInternal() throws IOException {
        HttpResponse response = this.getClient().execute(this.getRequest());
        return new PayPalCaptureRetrievalResponse((HttpResponse<Capture>)response);
    }

    @Override
    protected boolean isValidInternal() {
        return StringUtils.isNotBlank((CharSequence)this.getCaptureId());
    }

    protected String getCaptureId() {
        return this.captureId;
    }
}

