/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.paypal.service.payment;

import com.paypal.http.HttpResponse;
import com.paypal.payments.AuthorizationsCaptureRequest;
import com.paypal.payments.Capture;
import com.paypal.payments.CaptureRequest;
import com.paypal.payments.Money;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.vendor.paypal.service.PayPalClientProvider;
import org.broadleafcommerce.vendor.paypal.service.payment.AbstractPayPalRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.AbstractPayPalResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalCaptureAuthResponse;

public class PayPalCaptureAuthRequest
extends AbstractPayPalRequest<Capture, AuthorizationsCaptureRequest> {
    private final String authId;
    private final CaptureRequest captureRequest;

    public PayPalCaptureAuthRequest(PayPalClientProvider clientProvider, PaymentRequestDTO paymentRequest, CaptureRequest captureRequest, String authId) {
        super(clientProvider, paymentRequest);
        this.authId = authId;
        this.captureRequest = captureRequest;
    }

    @Override
    protected AuthorizationsCaptureRequest buildRequest() {
        AuthorizationsCaptureRequest request = new AuthorizationsCaptureRequest(this.getAuthId());
        request.requestBody(this.getCaptureRequest());
        return request;
    }

    @Override
    public AbstractPayPalResponse<Capture> executeInternal() throws IOException {
        HttpResponse response = this.getClient().execute(this.getRequest());
        return new PayPalCaptureAuthResponse((HttpResponse<Capture>)response);
    }

    @Override
    protected boolean isValidInternal() {
        CaptureRequest capture = this.getCaptureRequest();
        if (capture == null) {
            return false;
        }
        Money amount = capture.amount();
        return amount != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.authId, amount.currencyCode(), amount.value()}) && NumberUtils.isCreatable((String)amount.value());
    }

    protected String getAuthId() {
        return this.authId;
    }

    protected CaptureRequest getCaptureRequest() {
        return this.captureRequest;
    }
}

